/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.ASTMibs;
import com.sun.jdmk.tools.mibgen.CodeGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibGenProperties;
import com.sun.jdmk.tools.mibgen.ModulesHandler;
import com.sun.jdmk.tools.mibgen.ParseException;
import com.sun.jdmk.tools.mibgen.Parser;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.StoreGenerator;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class MibGen {
    private String program;
    private OutputStream out;
    private String genericPrefix = "";
    private String standardPrefix = "";
    private String specificPackageName = "";
    private String targetDir = ".";
    private String prefix = "";
    private boolean generateCode = true;
    private boolean generateMgrCode = true;
    private boolean generateMgrCodeOnly = false;
    private boolean standAlone = false;
    private boolean forAll = false;
    private String lastFile = "";
    private ASTMibs lastMib;
    private boolean status = true;
    private boolean commentRequested = false;
    private boolean defaultMibCore = true;
    private int gentype = 1;
    private Vector fileList;
    private static final String sccs_id = "@(#)MibGen.java 4.50 03/08/07 SMI";

    private MibGen(OutputStream o, String prog) {
        this.out = o;
        Trace.setOutput(this.out);
        this.program = prog;
    }

    private void output(String msg) {
        try {
            for (int i = 0; i < msg.length(); ++i) {
                this.out.write(msg.charAt(i));
            }
            this.out.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int error(String msg) {
        Trace.error(msg);
        Trace.info(MessageHandler.getMessage("compile.error.stop"));
        return 1;
    }

    private void usage() {
        Trace.info("Usage: " + this.program + " <options> <mib files>");
        Trace.info("\n" + MessageHandler.getMessage("usage.where"));
        Trace.info("  -n\t\t" + MessageHandler.getMessage("usage.n"));
        Trace.info("  -d <dir>\t" + MessageHandler.getMessage("usage.dir"));
        Trace.info("  -tp <pkgName>\t" + MessageHandler.getMessage("usage.tp"));
        Trace.info("  -desc\t\t" + MessageHandler.getMessage("usage.desc"));
        Trace.info("  -mo\t\t" + MessageHandler.getMessage("usage.mo"));
        Trace.info("  -mc\t\t" + MessageHandler.getMessage("usage.mc"));
        Trace.info("  -a\t\t" + MessageHandler.getMessage("usage.a"));
        Trace.info("  -g\t\t" + MessageHandler.getMessage("usage.g"));
        Trace.info("  -gp\t\t" + MessageHandler.getMessage("usage.gp"));
        Trace.info("  -sp\t\t" + MessageHandler.getMessage("usage.sp"));
        Trace.info("  -p <prefix>\t" + MessageHandler.getMessage("usage.p"));
        Trace.info("  -X:<advanced-option>\t" + MessageHandler.getMessage("usage.x"));
        Trace.info("  -help\t\t" + MessageHandler.getMessage("usage.help"));
    }

    private void xusage() {
        Trace.info(MessageHandler.getMessage("usage.x.option") + ":");
        Trace.info("  -X:define\t" + MessageHandler.getMessage("usage.x.define"));
        Trace.info("  -X:use-display-hint[:on|:off]\t" + MessageHandler.getMessage("usage.x.display"));
        Trace.info("  -X:abstract-mib[:on|:off]\t" + MessageHandler.getMessage("usage.x.abstract"));
        Trace.info("  -X:no-table-access[:on|:off]\t" + MessageHandler.getMessage("usage.x.table.noaccess"));
        Trace.info("  -X:target[:<target release number>]\t" + MessageHandler.getMessage("usage.x.target"));
        Trace.info("  -X:use-unsigned-long[:on|:off]\t" + MessageHandler.getMessage("usage.x.ulong"));
        Trace.info("  -X:help\t" + MessageHandler.getMessage("usage.x.help"));
    }

    private boolean parseArgs(String[] args) {
        int i;
        this.fileList = new Vector();
        boolean useUnsigned = false;
        boolean setNoption = false;
        if (args.length == 0) {
            this.usage();
            return false;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-X:target:5.0")) continue;
            System.setProperty("com.sun.jdmk.tools.mibgen.config.resource", MibGenProperties.MIBGEN_RESOURCE_NAME_JDMK50);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-tp")) {
                if (i + 1 < args.length) {
                    this.specificPackageName = args[++i];
                    continue;
                }
                Trace.error(MessageHandler.getMessage("compile.error.option.level", "-tp"));
                this.usage();
                return false;
            }
            if (args[i].equals("-d")) {
                if (i + 1 < args.length) {
                    this.targetDir = args[++i];
                    continue;
                }
                Trace.error(MessageHandler.getMessage("compile.error.option.level", "-d"));
                this.usage();
                return false;
            }
            if (args[i].equals("-p")) {
                if (i + 1 < args.length) {
                    this.prefix = args[++i];
                    continue;
                }
                Trace.error(MessageHandler.getMessage("compile.error.option.level", "-p"));
                this.usage();
                return false;
            }
            if (args[i].equals("-n")) {
                setNoption = true;
                this.generateCode = false;
                this.generateMgrCode = false;
                continue;
            }
            if (args[i].equals("-X:define")) {
                if (i + 1 < args.length) {
                    String property = args[++i];
                    try {
                        MibGenProperties.define(property);
                        continue;
                    }
                    catch (Exception x) {
                        Trace.error(MessageHandler.getMessage("compile.error.option.level", "-X:define " + property));
                        Trace.info("Syntax of -X:define option is:");
                        Trace.info("   -X:define <property-name>=<property-value>\t" + MessageHandler.getMessage("usage.x.define"));
                        this.xusage();
                        return false;
                    }
                }
                Trace.error(MessageHandler.getMessage("compile.error.option.level", "-X:define"));
                Trace.info("Syntax of -X:define option is:");
                Trace.info("   -X:define <property-name>=<property-value>\t" + MessageHandler.getMessage("usage.x.define"));
                this.xusage();
                return false;
            }
            if (args[i].equals("-X:use-display-hint") || args[i].equals("-X:use-display-hint:on")) {
                MibGenProperties.setProperty("com.sun.jdmk.tools.mibgen.options.use.display.hint", "true");
                continue;
            }
            if (args[i].equals("-X:use-display-hint:off")) {
                MibGenProperties.setProperty("com.sun.jdmk.tools.mibgen.options.use.display.hint", "false");
                continue;
            }
            if (args[i].equals("-X:abstract-mib") || args[i].equals("-X:abstract-mib:on")) {
                MibGenProperties.setProperty("com.sun.jdmk.tools.mibgen.options.mib.factory.abstract", "true");
                continue;
            }
            if (args[i].equals("-X:abstract-mib:off")) {
                MibGenProperties.setProperty("com.sun.jdmk.tools.mibgen.options.mib.factory.abstract", "false");
                continue;
            }
            if (args[i].equals("-X:no-table-access") || args[i].equals("-X:no-table-access:on")) {
                MibGenProperties.setProperty("com.sun.jdmk.tools.mibgen.options.mbean.table.accessor", "false");
                continue;
            }
            if (args[i].equals("-X:no-table-access:off")) {
                MibGenProperties.setProperty("com.sun.jdmk.tools.mibgen.options.mbean.table.accessor", "true");
                continue;
            }
            if (args[i].equals("-X:target:5.0")) continue;
            if (args[i].equals("-X:use-unsigned-long") || args[i].equals("-X:use-unsigned-long:on")) {
                useUnsigned = true;
                continue;
            }
            if (args[i].equals("-X:help")) {
                this.xusage();
                return false;
            }
            if (args[i].startsWith("-X:")) {
                Trace.error(MessageHandler.getMessage("compile.error.option.invalid", args[i]));
                this.xusage();
                return false;
            }
            if (args[i].equals("-g")) {
                this.gentype = 2;
                continue;
            }
            if (args[i].equals("-gp")) {
                if (i + 1 < args.length) {
                    this.genericPrefix = args[++i];
                    continue;
                }
                Trace.error(MessageHandler.getMessage("compile.error.option.level", "-gp"));
                this.usage();
                return false;
            }
            if (args[i].equals("-sp")) {
                if (i + 1 < args.length) {
                    this.standardPrefix = args[++i];
                    continue;
                }
                Trace.error(MessageHandler.getMessage("compile.error.option.level", "-sp"));
                this.usage();
                return false;
            }
            if (args[i].equals("-mo")) {
                this.generateMgrCodeOnly = true;
                this.generateCode = false;
                this.generateMgrCode = false;
                continue;
            }
            if (args[i].equals("-a")) {
                this.forAll = true;
                continue;
            }
            if (args[i].equals("-X:help")) {
                this.xusage();
                return false;
            }
            if (args[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (args[i].equals("-h")) {
                this.usage();
                return false;
            }
            if (args[i].equals("-desc")) {
                this.commentRequested = true;
                continue;
            }
            if (args[i].equals("-mc")) {
                this.defaultMibCore = false;
                continue;
            }
            if (args[i].startsWith("-")) {
                Trace.error(MessageHandler.getMessage("compile.error.option.invalid", args[i]));
                this.usage();
                return false;
            }
            this.fileList.addElement(args[i]);
            this.lastFile = args[i];
        }
        SyntaxMapper.fillTable(useUnsigned);
        if (setNoption && this.generateMgrCodeOnly) {
            Trace.error(MessageHandler.getMessage("compile.error.option.incompat", "-n", "-mo"));
            this.usage();
            return false;
        }
        return this.validTargetDir();
    }

    private synchronized boolean doCompile() {
        Parser parser;
        boolean errorStatus = true;
        ModulesHandler modulesHandler = new ModulesHandler();
        ASTMibs mibs = null;
        if (this.defaultMibCore) {
            String mibCoreFile = System.getProperty("mibcore.file");
            if (mibCoreFile == null) {
                mibCoreFile = DefaultPaths.getEtcDir((String)("mibgen" + File.separator + "mib_core.txt"));
            }
            Trace.info(MessageHandler.getMessage("compile.info.start.mibcore", mibCoreFile));
            parser = null;
            try {
                parser = new Parser(new FileInputStream(mibCoreFile));
                mibs = parser.Mibs(modulesHandler);
            }
            catch (FileNotFoundException e) {
                Trace.warning(MessageHandler.getMessage("compile.error.noMibCoreFile", mibCoreFile));
            }
            catch (ParseException e) {
                Trace.error(e.getMessage());
                errorStatus = false;
            }
            catch (Exception err) {
                if (err instanceof RuntimeException) {
                    throw (RuntimeException)err;
                }
                Trace.error(err.getMessage());
                errorStatus = false;
            }
        }
        for (int i = this.fileList.size() - 1; i >= 0; --i) {
            String name = (String)this.fileList.elementAt(i);
            Trace.info(MessageHandler.getMessage("compile.info.start", name));
            parser = null;
            try {
                parser = new Parser(new FileInputStream(name));
            }
            catch (FileNotFoundException e) {
                Trace.error(MessageHandler.getMessage("compile.error.noFile", name));
                return false;
            }
            try {
                ASTMibs n;
                this.lastMib = n = parser.Mibs(modulesHandler);
                continue;
            }
            catch (ParseException e) {
                Trace.error(e.getMessage());
                errorStatus = false;
                continue;
            }
            catch (Exception err) {
                if (err instanceof RuntimeException) {
                    throw (RuntimeException)err;
                }
                Trace.error(err.getMessage());
                errorStatus = false;
            }
        }
        if (!modulesHandler.resolve()) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        if (!modulesHandler.buildMibTrees()) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        if (this.defaultMibCore && mibs != null) {
            Enumeration e = mibs.mibElements();
            while (e.hasMoreElements()) {
                ASTMib aMib = (ASTMib)e.nextElement();
                modulesHandler.removeMibModule(aMib.getModuleName());
            }
        }
        this.status = this.generateAgentCode(modulesHandler) && this.generateMgrCode(modulesHandler) && errorStatus;
        return this.status;
    }

    private boolean generateAgentCode(ModulesHandler modulesHandler) {
        if (!this.generateCode) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration e = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (e == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        boolean status = true;
        Context ctxt = new Context();
        ctxt.genItfTableAccess = MibGenProperties.getBooleanProperty("com.sun.jdmk.tools.mibgen.options.mbean.table.accessor", true);
        ctxt.genAFNGetter = MibGenProperties.getBooleanProperty("com.sun.jdmk.tools.mibgen.options.mbean.notification.data.getter", true);
        ctxt.packageName = this.specificPackageName;
        ctxt.prefix = this.prefix;
        ctxt.dir = this.targetDir;
        ctxt.genericPrefix = this.genericPrefix;
        ctxt.standardPrefix = this.standardPrefix;
        ctxt.modules = modulesHandler;
        CodeGenerator codeGenerator = new CodeGenerator(new ResourceManager(), ctxt);
        while (e.hasMoreElements()) {
            ASTMib aMib = (ASTMib)e.nextElement();
            aMib.setDescriptionHandling(this.commentRequested);
            aMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.agent", aMib.getModuleName()));
            try {
                codeGenerator.generateCode(aMib, this.gentype);
            }
            catch (IOException a) {
                Trace.error(MessageHandler.getMessage("compile.error.io", aMib.getModuleName()));
                status = false;
            }
        }
        return status;
    }

    private boolean generateMgrCode(ModulesHandler modulesHandler) {
        if (!this.generateMgrCode && !this.generateMgrCodeOnly) {
            return true;
        }
        if (this.lastMib == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Enumeration e = this.forAll ? modulesHandler.mibElements() : this.lastMib.mibElements();
        if (e == null) {
            Trace.info(MessageHandler.getMessage("compile.error.stop"));
            return false;
        }
        Context ctxt = new Context();
        ctxt.genItfTableAccess = MibGenProperties.getBooleanProperty("com.sun.jdmk.tools.mibgen.options.mbean.table.accessor", true);
        ctxt.genAFNGetter = MibGenProperties.getBooleanProperty("com.sun.jdmk.tools.mibgen.options.mbean.notification.data.getter", true);
        ctxt.packageName = this.specificPackageName;
        ctxt.prefix = this.prefix;
        ctxt.dir = this.targetDir;
        ctxt.modules = modulesHandler;
        StoreGenerator codeGenerator = new StoreGenerator(new ResourceManager(), ctxt);
        while (e.hasMoreElements()) {
            ASTMib aMib;
            ctxt.mib = aMib = (ASTMib)e.nextElement();
            aMib.setModulesHandler(modulesHandler);
            Trace.info(MessageHandler.getMessage("compile.info.start.oidtable", aMib.getModuleName()));
            try {
                codeGenerator.generateCode(aMib);
            }
            catch (IOException a) {}
        }
        return true;
    }

    private void run() {
        if (this.fileList != null && this.fileList.size() > 0) {
            this.status = this.doCompile();
        }
    }

    public static void main(String[] args) {
        String outOfMemory = MessageHandler.getMessage("compile.error.internal.outmemory");
        try {
            int result = MibGen.compile(args);
            Trace.conclude();
            System.exit(result);
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                Trace.error(outOfMemory);
            } else {
                Trace.error(MessageHandler.getMessage("compile.error.internal", e.toString()));
                if (System.getProperty("LEVEL_DEBUG") != null) {
                    e.printStackTrace();
                }
                Trace.conclude();
            }
            System.exit(1);
        }
    }

    public static int compile(String[] args) {
        MibGen compiler = new MibGen(System.out, "mibgen");
        return compiler.startCompile(args) ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean startCompile(String[] args) {
        try {
            if (!this.parseArgs(args)) {
                boolean bl = false;
                return bl;
            }
            if (this.fileList.size() == 0) {
                this.usage();
                boolean bl = false;
                return bl;
            }
            boolean bl = this.doCompile();
            return bl;
        }
        finally {
            String filename = System.getProperty("com.sun.jdmk.tools.mibgen.config.store");
            if (filename != null) {
                try {
                    MibGenProperties.store(filename);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private boolean validTargetDir() {
        File dir;
        if (!this.generateCode) {
            return true;
        }
        try {
            dir = new File(this.targetDir);
        }
        catch (NullPointerException e) {
            return false;
        }
        if (!dir.exists()) {
            this.error(MessageHandler.getMessage("compile.error.noDir", this.targetDir));
            return false;
        }
        if (!dir.canWrite()) {
            this.error(MessageHandler.getMessage("compile.error.noWritePermission", this.targetDir));
            return false;
        }
        return true;
    }
}

