/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTIdentifier;
import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.IdentifierHandler;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.Node;
import com.sun.jdmk.tools.mibgen.Parser;
import com.sun.jdmk.tools.mibgen.SemanticException;
import com.sun.jdmk.tools.mibgen.SimpleNode;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Vector;

public class ASTDefinedValue
extends SimpleNode {
    protected String symbolName = null;
    protected String moduleName = null;

    ASTDefinedValue(int id) {
        super(id);
    }

    ASTDefinedValue(Parser p, int id) {
        super(p, id);
    }

    public static Node jjtCreate(int id) {
        return new ASTDefinedValue(id);
    }

    public static Node jjtCreate(Parser p, int id) {
        return new ASTDefinedValue(p, id);
    }

    public void resolve(IdentifierHandler handler, String key) {
        handler.addResolution(key, this);
        SimpleNode identifier = this.getChildOfType(36);
        if (identifier == null) {
            return;
        }
        handler.resolveIdentifier((ASTIdentifier)identifier);
    }

    public StringBuffer computeValue(Vector referenceList) throws SemanticException {
        StringBuffer result = new StringBuffer();
        if (this.children == null) {
            return result;
        }
        return ((SimpleNode)this.children[0]).computeValue(referenceList);
    }

    public String getDefValInitializer(String strMbeanSyntax, ASTNamedType syntax, String varName) {
        String result = new String();
        int intSnmpSyntax = SyntaxMapper.getIntSnmpSyntax(syntax.getSnmpSyntax());
        switch (intSnmpSyntax) {
            case 4: {
                if (syntax.isEnumeratedType()) {
                    if (!syntax.getEnumeratedDef().getEnum().containsKey(this.symbolName)) {
                        Trace.warning(MessageHandler.getMessage("compile.w.defval", this.symbolName, varName));
                        break;
                    }
                } else {
                    try {
                        Integer i = new Integer(this.symbolName);
                    }
                    catch (NumberFormatException e) {
                        Trace.warning(MessageHandler.getMessage("compile.w.defval", this.symbolName, varName));
                        break;
                    }
                }
                result = " = new " + strMbeanSyntax.trim() + "(\"" + this.symbolName + "\")";
                break;
            }
            case 9: {
                result = " = new " + strMbeanSyntax.trim() + "(\"" + this.symbolName + "\")";
                break;
            }
            case 11: {
                ASTMib localMib = this.getMib();
                String oid = localMib.translateOid(this.symbolName);
                if (oid != null) {
                    result = " = new " + strMbeanSyntax.trim() + "(\"" + oid + "\")";
                    break;
                }
                Trace.warning(MessageHandler.getMessage("compile.w.defval", this.symbolName, varName));
                break;
            }
            case 10: {
                result = String.valueOf(this.symbolName);
                result = " = {" + this.CharToByte(result) + "}";
                break;
            }
            default: {
                Trace.warning(MessageHandler.getMessage("compile.w.defval", this.symbolName, varName));
            }
        }
        return result;
    }

    String CharToByte(String ch) {
        StringBuffer result = new StringBuffer();
        byte[] value = ch.getBytes();
        int nbBytes = value.length;
        for (int i = 0; i < nbBytes; ++i) {
            result.append(" new Byte(\"");
            result.append(value[i]);
            result.append("\")");
            if (i >= nbBytes - 1) continue;
            result.append(",");
        }
        return new String(result);
    }
}

