/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTModuleIdentifier;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTNotificationGroup;
import com.sun.jdmk.tools.mibgen.ASTNotificationType;
import com.sun.jdmk.tools.mibgen.ASTObjectGroup;
import com.sun.jdmk.tools.mibgen.ASTObjectIdentity;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTOidValue;
import com.sun.jdmk.tools.mibgen.ASTValue;
import com.sun.jdmk.tools.mibgen.IdentifierHandler;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibTree;
import com.sun.jdmk.tools.mibgen.ModulesHandler;
import com.sun.jdmk.tools.mibgen.Node;
import com.sun.jdmk.tools.mibgen.ObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ParseException;
import com.sun.jdmk.tools.mibgen.Parser;
import com.sun.jdmk.tools.mibgen.RegisteredObject;
import com.sun.jdmk.tools.mibgen.SemanticException;
import com.sun.jdmk.tools.mibgen.SimpleNode;
import com.sun.jdmk.tools.mibgen.SyntaxHandler;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ASTMib
extends SimpleNode {
    protected ASTModuleIdentifier moduleIdentifier;
    protected Hashtable registrationTable = new Hashtable();
    protected Hashtable objectIdentities = new Hashtable();
    protected Hashtable objectGroups = new Hashtable();
    protected Hashtable notifGroups = new Hashtable();
    protected Hashtable notificationTypes = new Hashtable();
    protected Hashtable valueDefs = new Hashtable();
    protected Hashtable syntaxDefs = new Hashtable();
    protected Hashtable oidTranslation = new Hashtable();
    protected Hashtable symbolTranslation = new Hashtable();
    protected Hashtable v1 = new Hashtable();
    protected Hashtable v2 = new Hashtable();
    protected MibTree tree = null;
    private ModulesHandler modulesHandler;
    private boolean useDescription = true;
    protected IdentifierHandler identifierHandler;
    protected IdentifierHandler indexHandler;
    protected SyntaxHandler syntaxHandler;

    ASTMib(int id) {
        super(id);
    }

    ASTMib(Parser p, int id) {
        super(p, id);
    }

    public static Node jjtCreate(int id) {
        return new ASTMib(id);
    }

    public static Node jjtCreate(Parser p, int id) {
        return new ASTMib(p, id);
    }

    public void registerValueDef(String symbolName, SimpleNode aNode) {
        if (this.valueDefs.containsKey(symbolName)) {
            Trace.warning(MessageHandler.getMessage("compile.w.multiple.value", symbolName, this.getModuleName()));
        }
        this.valueDefs.put(symbolName, aNode);
    }

    public void registerSymbol(String symbolName, SimpleNode aNode) throws SemanticException {
        if (this.registrationTable.containsKey(symbolName)) {
            throw new SemanticException(MessageHandler.getMessage("compile.error.multiple.register", symbolName, this.getModuleName()));
        }
        this.registrationTable.put(symbolName, aNode);
    }

    public void registerObjectIdentity(String symbolName, SimpleNode aNode) throws ParseException {
        if (this.objectIdentities.containsKey(symbolName)) {
            Trace.error(MessageHandler.getMessage("compile.error.multiple.objectidentity", symbolName, this.getModuleName()));
        }
        this.objectIdentities.put(symbolName, aNode);
        this.registerSymbol(symbolName, aNode);
    }

    public void registerObjectGroup(String symbolName, SimpleNode aNode) throws ParseException {
        if (this.objectGroups.containsKey(symbolName)) {
            Trace.error(MessageHandler.getMessage("compile.error.multiple.objectgroup", symbolName, this.getModuleName()));
        }
        this.objectGroups.put(symbolName, aNode);
        this.registerSymbol(symbolName, aNode);
    }

    public void registerNotifGroup(String symbolName, SimpleNode aNode) throws ParseException {
        if (this.notifGroups.containsKey(symbolName)) {
            Trace.error(MessageHandler.getMessage("compile.error.multiple.notifgroup", symbolName, this.getModuleName()));
        }
        this.notifGroups.put(symbolName, aNode);
        this.registerSymbol(symbolName, aNode);
    }

    public void registerNotificationType(String symbolName, SimpleNode aNode) throws ParseException {
        if (this.notificationTypes.containsKey(symbolName)) {
            Trace.error(MessageHandler.getMessage("compile.error.multiple.notificationtype", symbolName, this.getModuleName()));
        }
        this.notificationTypes.put(symbolName, aNode);
        this.registerSymbol(symbolName, aNode);
    }

    public void registerSyntaxDef(String symbolName, SimpleNode aNode) {
        if (this.syntaxDefs.containsKey(symbolName)) {
            Trace.warning(MessageHandler.getMessage("compile.w.multiple.syntax", symbolName, this.getModuleName()));
        }
        this.syntaxDefs.put(symbolName, aNode);
    }

    public void registerV1ObjectType(String symbolName, ASTObjectTypeDefinition aNode) throws ParseException {
        if (this.v1.containsKey(symbolName)) {
            throw new SemanticException(MessageHandler.getMessage("compile.w.multiple.v1Object", symbolName, this.getModuleName()));
        }
        this.v1.put(symbolName, aNode);
        this.registerSymbol(symbolName, aNode);
    }

    public void registerV2ObjectType(String symbolName, ASTObjectTypeDefinition aNode) throws ParseException {
        if (this.v2.containsKey(symbolName)) {
            throw new SemanticException(MessageHandler.getMessage("compile.w.multiple.v2Object", symbolName, this.getModuleName()));
        }
        this.v2.put(symbolName, aNode);
        this.registerSymbol(symbolName, aNode);
    }

    public void localResolve() {
        this.identifierHandler = new IdentifierHandler(this.getModuleName());
        this.indexHandler = new IdentifierHandler(this.getModuleName());
        this.syntaxHandler = new SyntaxHandler(this.getModuleName());
        Trace.info(MessageHandler.getMessage("compile.resolve.local", this.getModuleName()));
        this.resolveValues();
        this.resolveObjectIdentities();
        this.resolveObjectGroups();
        this.resolveNotifGroups();
        this.resolveNotificationTypes();
        this.resolveSyntaxes();
        this.resolveAllObjectTypes();
    }

    public void globalResolve(Hashtable idTable, Hashtable refTable, Hashtable indexTable) {
        Trace.info(MessageHandler.getMessage("compile.resolve.global", this.getModuleName()));
        this.identifierHandler.resolve(idTable);
        this.syntaxHandler.resolve(refTable);
        this.indexHandler.resolve(indexTable);
    }

    public String resolveOidSymbol(String symbolName) {
        String dotString = null;
        dotString = this.getAssociatedOid(symbolName);
        if (dotString != null && dotString.equals("")) {
            dotString = null;
        }
        return dotString;
    }

    public String translateOid(String symboleName) {
        String dotString = null;
        dotString = this.resolveOidSymbol(symboleName);
        if (dotString != null) {
            return dotString;
        }
        Enumeration e = this.getModuleHandler().mibElements();
        while (e.hasMoreElements()) {
            ASTMib aMib = (ASTMib)e.nextElement();
            dotString = aMib.resolveOidSymbol(symboleName);
            if (dotString == null) continue;
            return dotString;
        }
        return null;
    }

    public String getValueDef(String symboleName) throws SemanticException {
        SimpleNode val = (SimpleNode)this.valueDefs.get(symboleName);
        if (val == null) {
            return null;
        }
        Vector<SimpleNode> ref = new Vector<SimpleNode>();
        ref.addElement(val);
        return val.computeValue(ref).toString();
    }

    public String getModuleName() {
        return this.moduleIdentifier.getModuleName();
    }

    public ModulesHandler getModuleHandler() {
        return this.modulesHandler;
    }

    public void setModulesHandler(ModulesHandler x) {
        this.modulesHandler = x;
    }

    public boolean buildMibTree() {
        this.buildOidTable();
        this.tree = new MibTree(this.getModuleName());
        boolean result = this.tree.buildTree(this.v1, this.v2);
        return result;
    }

    public MibTree getMibTree() {
        return this.tree;
    }

    public void buildOidTable() {
        String key;
        Enumeration e = this.valueDefs.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            SimpleNode valueDef = (SimpleNode)this.valueDefs.get(key);
            Vector<SimpleNode> ref = new Vector<SimpleNode>();
            ref.addElement(valueDef);
            try {
                StringBuffer val = valueDef.computeValue(ref);
                if (val.length() == 0) continue;
                this.oidTranslation.put(val.toString(), key);
                this.symbolTranslation.put(key, val.toString());
            }
            catch (SemanticException a) {}
        }
        e = this.registrationTable.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            RegisteredObject obj = (RegisteredObject)this.registrationTable.get(key);
            ASTOidValue oid = obj.getOidNode();
            Vector<ASTOidValue> ref = new Vector<ASTOidValue>();
            ref.addElement(oid);
            try {
                StringBuffer val = oid.computeValue(ref);
                if (val.length() == 0) continue;
                this.oidTranslation.put(val.toString(), key);
                this.symbolTranslation.put(key, val.toString());
            }
            catch (SemanticException a) {}
        }
    }

    public void printMibTree(String prefix) {
        this.tree.dump(prefix);
    }

    public Hashtable getOidTranslation() {
        return this.oidTranslation;
    }

    public Hashtable getSymbolTranslation() {
        return this.symbolTranslation;
    }

    public String getAssociatedOid(String symbol) {
        return (String)this.symbolTranslation.get(symbol);
    }

    public String getAssociatedSymbol(String dotOid) {
        return (String)this.oidTranslation.get(dotOid);
    }

    public boolean computeValues() {
        if (!this.computeAllObjectTypeOid()) {
            return false;
        }
        if (!this.computeObjectIdentityOid()) {
            return false;
        }
        if (!this.computeObjectGroupOid()) {
            return false;
        }
        if (!this.computeNotifGroupOid()) {
            return false;
        }
        return this.computeNotificationTypeOid();
    }

    public IdentifierHandler getIdResolver() {
        return this.identifierHandler;
    }

    public IdentifierHandler getIndexResolver() {
        return this.indexHandler;
    }

    public SyntaxHandler getRefResolver() {
        return this.syntaxHandler;
    }

    public boolean printUndefinedSymbols() {
        return this.identifierHandler.printUnresolved() && this.syntaxHandler.printUnresolved() && this.indexHandler.printUnresolved();
    }

    private void resolveValues() {
        Enumeration e = this.valueDefs.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            SimpleNode valueDef = (SimpleNode)this.valueDefs.get(key);
            valueDef.resolve(this.identifierHandler, key);
        }
    }

    private void resolveSyntaxes() {
        Enumeration e = this.syntaxDefs.elements();
        while (e.hasMoreElements()) {
            SimpleNode aSyntax = (SimpleNode)e.nextElement();
            aSyntax.resolve(this.syntaxHandler);
        }
    }

    private void resolveAllObjectTypes() {
        this.resolveObjectType(this.v1);
        this.resolveObjectType(this.v2);
    }

    private void resolveObjectIdentities() {
        Enumeration e = this.objectIdentities.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTObjectIdentity objectIdentity = (ASTObjectIdentity)this.objectIdentities.get(key);
            ASTOidValue oid = objectIdentity.getOidNode();
            oid.resolve(this.identifierHandler, key);
        }
    }

    private void resolveObjectGroups() {
        Enumeration e = this.objectGroups.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTObjectGroup objectGroup = (ASTObjectGroup)this.objectGroups.get(key);
            ASTOidValue oid = objectGroup.getOidNode();
            oid.resolve(this.identifierHandler, key);
        }
    }

    private void resolveNotifGroups() {
        Enumeration e = this.notifGroups.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTNotificationGroup notifGroup = (ASTNotificationGroup)this.notifGroups.get(key);
            ASTOidValue oid = notifGroup.getOidNode();
            oid.resolve(this.identifierHandler, key);
        }
    }

    private void resolveNotificationTypes() {
        Enumeration e = this.notificationTypes.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTNotificationType notificationType = (ASTNotificationType)this.notificationTypes.get(key);
            ASTOidValue oid = notificationType.getOidNode();
            oid.resolve(this.identifierHandler, key);
        }
    }

    private void resolveObjectType(Hashtable table) {
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            Node node;
            String key = (String)e.nextElement();
            ASTObjectTypeDefinition obj = (ASTObjectTypeDefinition)table.get(key);
            this.indexHandler.addResolution(key, obj);
            ObjectTypeDefinition definition = obj.getDefinition();
            ASTOidValue oid = definition.getOidNode();
            oid.resolve(this.identifierHandler, key);
            ASTNamedType syntax = obj.getSyntax();
            syntax.resolve(this.syntaxHandler);
            ASTValue defVal = definition.getDefValue();
            if (defVal != null) {
                defVal.setDefValSnmpSyntax(SyntaxMapper.getIntSnmpSyntax(obj.getSnmpSyntax()));
                defVal.resolve(this.identifierHandler);
            }
            if ((node = definition.getIndex()) == null) continue;
            this.resolveIndexOfTable(node);
        }
    }

    private void resolveIndexOfTable(Node aNode) {
        SimpleNode index = (SimpleNode)aNode;
        index.validateIndexNames(this.indexHandler);
    }

    private boolean computeNotificationTypeOid() {
        boolean ok = true;
        Enumeration e = this.notificationTypes.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTNotificationType obj = (ASTNotificationType)this.notificationTypes.get(key);
            ASTOidValue oid = obj.getOidNode();
            Vector<ASTOidValue> ref = new Vector<ASTOidValue>();
            ref.addElement(oid);
            try {
                StringBuffer res = oid.computeValue(ref);
            }
            catch (SemanticException a) {
                String val = a.getMessage();
                Trace.error(MessageHandler.getMessage("compile.error.loop", key, val, this.getModuleName()));
                ok = false;
            }
        }
        return ok;
    }

    private boolean computeObjectIdentityOid() {
        boolean ok = true;
        Enumeration e = this.objectIdentities.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTObjectIdentity obj = (ASTObjectIdentity)this.objectIdentities.get(key);
            ASTOidValue oid = obj.getOidNode();
            Vector<ASTOidValue> ref = new Vector<ASTOidValue>();
            ref.addElement(oid);
            try {
                StringBuffer res = oid.computeValue(ref);
            }
            catch (SemanticException a) {
                String val = a.getMessage();
                Trace.error(MessageHandler.getMessage("compile.error.loop", key, val, this.getModuleName()));
                ok = false;
            }
        }
        return ok;
    }

    private boolean computeObjectGroupOid() {
        boolean ok = true;
        Enumeration e = this.objectGroups.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTObjectGroup obj = (ASTObjectGroup)this.objectGroups.get(key);
            ASTOidValue oid = obj.getOidNode();
            Vector<ASTOidValue> ref = new Vector<ASTOidValue>();
            ref.addElement(oid);
            try {
                StringBuffer res = oid.computeValue(ref);
            }
            catch (SemanticException a) {
                String val = a.getMessage();
                Trace.error(MessageHandler.getMessage("compile.error.loop", key, val, this.getModuleName()));
                ok = false;
            }
        }
        return ok;
    }

    private boolean computeNotifGroupOid() {
        boolean ok = true;
        Enumeration e = this.notifGroups.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTNotificationGroup obj = (ASTNotificationGroup)this.notifGroups.get(key);
            ASTOidValue oid = obj.getOidNode();
            Vector<ASTOidValue> ref = new Vector<ASTOidValue>();
            ref.addElement(oid);
            try {
                StringBuffer res = oid.computeValue(ref);
            }
            catch (SemanticException a) {
                String val = a.getMessage();
                Trace.error(MessageHandler.getMessage("compile.error.loop", key, val, this.getModuleName()));
                ok = false;
            }
        }
        return ok;
    }

    private boolean computeAllObjectTypeOid() {
        return this.computeObjectTypeOid(this.v1) && this.computeObjectTypeOid(this.v2);
    }

    private boolean computeObjectTypeOid(Hashtable table) {
        boolean ok = true;
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ASTObjectTypeDefinition obj = (ASTObjectTypeDefinition)table.get(key);
            ObjectTypeDefinition definition = obj.getDefinition();
            ASTOidValue oid = definition.getOidNode();
            Vector<ASTOidValue> ref = new Vector<ASTOidValue>();
            ref.addElement(oid);
            try {
                StringBuffer res = oid.computeValue(ref);
            }
            catch (SemanticException a) {
                String val = a.getMessage();
                Trace.error(MessageHandler.getMessage("compile.error.loop", key, val, this.getModuleName()));
                ok = false;
            }
        }
        return ok;
    }

    public void setDescriptionOn() {
        this.useDescription = true;
    }

    public void setDescriptionOff() {
        this.useDescription = false;
    }

    public boolean isDescriptionOn() {
        return this.useDescription;
    }

    public void setDescriptionHandling(boolean val) {
        this.useDescription = val;
    }
}

