/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.Enumerated;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class EnumGenerator
extends Generator
implements Serializable {
    protected StringBuffer var_list = new StringBuffer();
    protected StringBuffer accessors = new StringBuffer();
    protected StringBuffer constructor = new StringBuffer();
    protected Enumerated enumeration;
    private String typeName;
    private static Hashtable enumList = new Hashtable();

    public EnumGenerator(ResourceManager mgr, String var, Enumerated enumeration, Context ctxt) throws IOException {
        super(mgr, ctxt);
        this.typeName = EnumGenerator.getRealEnumName(ctxt, var, enumeration);
        this.enumeration = enumeration;
        this.mib = ctxt.mib;
        EnumGenerator gen = (EnumGenerator)enumList.get(this.typeName);
        if (gen == null) {
            this.generateEnum();
            enumList.put(this.typeName, this);
        }
    }

    public static String getRealEnumName(Context ctxt, String var, Enumerated enumeration) {
        String typeName = enumeration.getSymbol();
        if (typeName.length() == 0) {
            return var;
        }
        EnumGenerator gen = (EnumGenerator)enumList.get(typeName);
        if (gen != null) {
            return gen.getRealName();
        }
        return typeName;
    }

    public static String getEnumClassName(Context ctxt, String var, Enumerated enumeration) {
        String typeName = EnumGenerator.getRealEnumName(ctxt, var, enumeration);
        return ctxt.prefix + Def.ENUMPREFIX + typeName + " ";
    }

    public void setContext(Context ctxt) {
        super.setContext(ctxt);
        this.mib = ctxt.mib;
    }

    protected String getRealName() {
        return this.typeName;
    }

    public String getTypeName() {
        return this.prefix + Def.ENUMPREFIX + this.typeName + " ";
    }

    protected void writeVersion() throws IOException {
        String msgid = "generate.version";
        this.write("\n//\n// " + MessageHandler.getMessage(msgid, this.mib.getModuleName()) + "\n//\n\n");
    }

    private void generateEnum() throws IOException {
        String className = this.prefix + Def.ENUMPREFIX + this.typeName;
        Trace.info(MessageHandler.getMessage("generate.info.enum", this.typeName));
        this.out = this.openFile(className + Def.JAVA);
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_HASHTABLE + Def.SEMICOLON);
        this.write("\n// RI imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_ENUMERATED + Def.SEMICOLON + "\n");
        this.write("/**\n * " + MessageHandler.getMessage("generate.enum.comment.desc", this.typeName) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + className + Def.EXTEND + Def.ENUM_CLASS);
        this.write(Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n" + Def.TAB + "protected static Hashtable intTable = new Hashtable();\n" + Def.TAB + "protected static Hashtable stringTable = new Hashtable();\n");
        this.write(Def.TAB + Def.STATIC + Def.LBRACE);
        Hashtable list = this.enumeration.getEnum();
        StringBuffer buff1 = new StringBuffer();
        StringBuffer buff2 = new StringBuffer();
        Enumeration e = list.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)list.get(key);
            buff1.append(Def.TAB2 + Def.ENUM_INTTAB + ".put(new Integer(" + val + "), \"" + key + "\");\n");
            buff2.append(Def.TAB2 + Def.ENUM_STRINGTAB + ".put(\"" + key + "\", new Integer(" + val + "));\n");
        }
        this.write(buff1.toString());
        this.write(buff2.toString());
        this.write(Def.TAB + Def.RBRACE + "\n");
        this.write(Def.TAB + Def.PUBLIC + className + "(int valueIndex) " + Def.THROWS + Def.EXCP_ARGUMENT + Def.LBRACE + Def.TAB2 + "super(valueIndex)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n" + Def.TAB + Def.PUBLIC + className + "(Integer valueIndex) " + Def.THROWS + Def.EXCP_ARGUMENT + Def.LBRACE + Def.TAB2 + "super(valueIndex)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n" + Def.TAB + Def.PUBLIC + className + "() " + Def.THROWS + Def.EXCP_ARGUMENT + Def.LBRACE + Def.TAB2 + "super()" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n" + Def.TAB + Def.PUBLIC + className + "(String x) " + Def.THROWS + Def.EXCP_ARGUMENT + Def.LBRACE + Def.TAB2 + "super(x)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.write(Def.TAB + "protected Hashtable getIntTable() {\n" + Def.TAB2 + "return intTable ;\n" + Def.TAB + Def.RBRACE + "\n" + Def.TAB + "protected Hashtable getStringTable() {\n" + Def.TAB2 + "return stringTable ;\n" + Def.TAB + Def.RBRACE + "\n" + Def.RBRACE);
        this.closeIO();
    }
}

