/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTValue;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.EnumGenerator;
import com.sun.jdmk.tools.mibgen.Enumerated;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MbeanGenerator;
import com.sun.jdmk.tools.mibgen.MbeanIfGenerator;
import com.sun.jdmk.tools.mibgen.MetaBeanGenerator;
import com.sun.jdmk.tools.mibgen.MetaGroupGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class GroupGenerator
extends Generator
implements Serializable {
    public GroupGenerator(ResourceManager mgr, Context ctxt) {
        super(mgr, ctxt);
    }

    public void generateCode(MibNode aGroup, Context ctxt) throws IOException {
        MbeanGenerator beanGen = new MbeanGenerator(this.manager, aGroup, ctxt);
        MbeanIfGenerator beanIfGen = new MbeanIfGenerator(this.manager, aGroup, ctxt);
        MetaBeanGenerator metaGen = this.mkMetaBeanGenerator(this.manager, aGroup, ctxt);
        Enumeration e = aGroup.getChildren().elements();
        while (e.hasMoreElements()) {
            MibNode aNode = (MibNode)e.nextElement();
            beanGen.handleNode(aNode);
            beanIfGen.handleNode(aNode);
            metaGen.handleNode(aNode);
        }
        beanGen.endOfGroup();
        beanIfGen.endOfGroup();
        metaGen.endOfGroup();
    }

    public void buildSymbolTable(MibNode aGroup, Context ctxt) throws IOException {
        Enumeration e = aGroup.getChildren().elements();
        while (e.hasMoreElements()) {
            MibNode aNode = (MibNode)e.nextElement();
            if (!aNode.isAssociated()) continue;
            if (aNode.isTable()) {
                this.buildTableSymbolTable(aNode, ctxt);
                continue;
            }
            this.buildVariableSymbolTable(aNode, ctxt);
        }
    }

    protected void buildTableSymbolTable(MibNode aTable, Context ctxt) throws IOException {
        Enumeration e = aTable.getChildren().elements();
        while (e.hasMoreElements()) {
            MibNode aNode = (MibNode)e.nextElement();
            if (!aNode.isAssociated()) continue;
            this.buildSymbolTable(aNode, ctxt);
        }
    }

    public void addExternalSymbol(Context ctxt, String symbol) {
        if (ctxt == null) {
            return;
        }
        if (ctxt.modules == null) {
            return;
        }
        MibNode aNode = ctxt.modules.findNodeWithName(symbol);
        if (aNode == null) {
            return;
        }
        if (aNode.isVariable()) {
            this.buildVariableSymbolTable(aNode, ctxt);
        }
    }

    protected void buildVariableSymbolTable(MibNode aNode, Context ctxt) {
        String varName = aNode.getSymbolName();
        ASTObjectTypeDefinition definition = aNode.getObjectType();
        if (definition == null) {
            return;
        }
        ASTNamedType syntax = definition.getSyntax();
        String strSyntax = null;
        ASTValue defValue = definition.getDefValue();
        if (syntax.isEnumeratedType()) {
            strSyntax = this.getEnumClassName(this.context, varName, syntax.getEnumeratedDef());
            aNode.setEnumerated(true);
            aNode.setEnumeratedType(strSyntax);
        } else {
            strSyntax = syntax.getMbeanSyntax();
        }
        String typeRef = syntax.getTypeReferenceName();
        if (typeRef != null) {
            ctxt.setTypeRef(varName, typeRef);
        }
        ctxt.setJavaSyntax(varName, strSyntax);
    }

    public String getEnumClassName(Context ctxt, String var, Enumerated enumeration) {
        return EnumGenerator.getEnumClassName(ctxt, var, enumeration);
    }

    public MetaBeanGenerator mkMetaBeanGenerator(ResourceManager mgr, MibNode aGroup, Context ctxt) throws IOException {
        if (aGroup.isGroup()) {
            return new MetaGroupGenerator(mgr, aGroup, ctxt);
        }
        return new MetaBeanGenerator(mgr, aGroup, ctxt);
    }
}

