/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTValue;
import com.sun.jdmk.tools.mibgen.BeanGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.EnumGenerator;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.TableBeanGenerator;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;

public class MbeanGenerator
extends BeanGenerator
implements Serializable {
    protected int gentype = 0;
    protected StringBuffer var_list = new StringBuffer();
    protected StringBuffer accessors = new StringBuffer();
    protected StringBuffer constructor1 = new StringBuffer();
    protected StringBuffer constructor2 = new StringBuffer();

    public static String getNodeSymbolName(Context ctxt, MibNode node) {
        String vName = node.getSymbolName();
        if (vName == null) {
            vName = Generator.getClassName(ctxt, node.getComputedOid());
        }
        String sName = ctxt.prefix + vName;
        return sName;
    }

    String getNodeSymbolName(MibNode node) {
        return MbeanGenerator.getNodeSymbolName(this.context, node);
    }

    public MbeanGenerator(ResourceManager mgr, MibNode aGroup, Context ctxt) throws IOException {
        super(mgr, aGroup, ctxt);
        this.gentype = ctxt.gentype;
        this.oid = this.node.getComputedOid();
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = this.getNodeSymbolName(this.node);
        Trace.info(MessageHandler.getMessage("generate.info.var", this.varName));
        this.out = this.openFile(this.symboleName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.buildConstructorHeader();
    }

    public void setContext(Context ctxt) {
        super.setContext(ctxt);
        this.gentype = ctxt.gentype;
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbean.comment.desc", this.varName) + "\n" + " * " + MessageHandler.getMessage("generate.mbean.comment.oid", this.oid) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.symboleName + Def.IMPLEMENT + this.symboleName + Def.MBEANSUFFIX + ", " + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeVersion() throws IOException {
        String msgid = "generate.version";
        this.write("\n//\n// " + MessageHandler.getMessage(msgid, this.mib.getModuleName()) + "\n//\n\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STATUS_EXCEPTION + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write("\n");
    }

    public String getSnmpClassName() {
        return this.symboleName;
    }

    public void endOfGroup() throws IOException {
        this.closeConstructor();
        this.write(this.var_list.toString());
        this.write(this.constructor1.toString());
        this.write(this.constructor2.toString());
        this.write(this.accessors.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    public void handleNode(MibNode aNode) throws IOException {
        if (aNode.isGroup() || aNode.hasNestedGroups()) {
            this.handleNestedGroups(aNode);
            return;
        }
        if (aNode.isTable()) {
            this.handleTable(aNode);
            return;
        }
        String varName = aNode.getSymbolName();
        ASTObjectTypeDefinition definition = aNode.getObjectType();
        if (definition == null) {
            return;
        }
        ASTNamedType syntax = definition.getSyntax();
        String strSyntax = "";
        ASTValue defValue = definition.getDefValue();
        String init = "";
        if (syntax.isEnumeratedType()) {
            EnumGenerator enumgen = new EnumGenerator(this.manager, varName, syntax.getEnumeratedDef(), this.context);
            strSyntax = enumgen.getTypeName();
            if (defValue != null) {
                init = defValue.getDefValInitializer(strSyntax, syntax, varName);
            }
            if (defValue == null || init.equals("")) {
                init = " = new " + strSyntax.trim() + "()";
            }
            aNode.setEnumerated(true);
            aNode.setEnumeratedType(strSyntax);
        } else {
            strSyntax = syntax.getMbeanSyntax();
            if (defValue != null) {
                init = defValue.getDefValInitializer(strSyntax, syntax, varName);
            }
            if (defValue == null || init.equals("")) {
                init = SyntaxMapper.getInitializer(syntax.getSnmpSyntax());
            }
        }
        long length = syntax.getFixedLength();
        aNode.setFixedLength(length);
        this.addCacheVar(aNode, strSyntax, length, init, varName);
        this.addAccessors(aNode, strSyntax, varName);
    }

    protected void handleNestedGroups(MibNode node) throws IOException {
    }

    protected void handleTable(MibNode node) throws IOException {
        TableBeanGenerator table = new TableBeanGenerator(this.manager, node, this.context);
        String entry = table.getEntryName();
        String tableName = table.getTableClassName();
        String variable = table.getSymbolName();
        this.addCacheVar(node, tableName, -1L, null, variable);
        this.constructor1.append(Def.TAB2 + variable + " = " + Def.NEW + tableName + "(myMib)" + Def.SEMICOLON);
        this.constructor2.append(Def.TAB2 + variable + " = " + Def.NEW + tableName + "(myMib, server)" + Def.SEMICOLON);
        this.accessors.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.access", variable) + "\n" + Def.TAB + " */\n");
        this.accessors.append(Def.TAB + Def.PUBLIC + tableName + Def.ACCESS + variable + "() " + accessThrows);
        this.accessors.append(Def.TAB2 + Def.RETURN + variable + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.accessors.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.entry", variable) + "\n" + Def.TAB + " */\n");
        this.accessors.append(Def.TAB + Def.PUBLIC + entry + Def.MBEANSUFFIX + "[] " + Def.GET + variable + "() " + accessThrows);
        this.accessors.append(Def.TAB2 + Def.RETURN + variable + ".getEntries()" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void addGetter(Context ctxt, MibNode node, String description, String syntax, String var, StringBuffer buff) {
        buff.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.getter", var) + "\n" + Def.TAB + " */\n");
        buff.append(Def.TAB + Def.PUBLIC + syntax + Def.GET + var + "() " + accessThrows);
        buff.append(Def.TAB2 + Def.RETURN + var + Def.SEMICOLON);
        buff.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void addChecker(Context ctxt, MibNode node, String description, String syntax, String var, StringBuffer buff) {
        buff.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.checker", var) + "\n" + Def.TAB + " */\n");
        buff.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.CHECK + var + "(" + syntax + "x) " + accessThrows);
        buff.append(Def.TAB2 + "//\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mbean.comment.checker.policy") + "\n" + Def.TAB2 + "//\n");
        buff.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void addSetter(Context ctxt, MibNode node, String description, String syntax, String var, StringBuffer buff) {
        buff.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.setter", var) + "\n" + Def.TAB + " */\n");
        buff.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.SET + var + "(" + syntax + "x) " + accessThrows);
        buff.append(Def.TAB2 + var + " = x" + Def.SEMICOLON);
        buff.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void addAccessors(MibNode node, String syntax, String var) throws IOException {
        ASTObjectTypeDefinition definition = node.getObjectType();
        String description = definition.getDefinition().getDescription();
        this.addGetter(this.context, node, description, syntax, var, this.accessors);
        int access = definition.getDefinition().getAccess();
        if (access == 68 || access == 85 || access == 66) {
            this.addSetter(this.context, node, description, syntax, var, this.accessors);
            this.addChecker(this.context, node, description, syntax, var, this.accessors);
        }
    }

    protected void addCacheVar(MibNode node, String syntax, long fixed, String init, String var) throws IOException {
        this.var_list.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.varUse", var) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.varOid", node.getOid()) + "\n" + Def.TAB);
        if (fixed != -1L) {
            this.var_list.append(" * " + MessageHandler.getMessage("generate.mbean.comment.varFix", String.valueOf(fixed)) + "\n" + Def.TAB);
        }
        if (this.mib.isDescriptionOn()) {
            ASTObjectTypeDefinition definition = node.getObjectType();
            String description = definition.getDefinition().getDescription();
            this.var_list.append(this.formatDescription(description));
        }
        this.var_list.append(" */\n");
        if (init == null) {
            init = "";
        }
        this.var_list.append(Def.TAB + Def.PROTECTED + syntax + var + init + Def.SEMICOLON + "\n");
    }

    protected void buildConstructorHeader() throws IOException {
        this.constructor1.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.noRegistration") + "\n" + Def.TAB + " */\n");
        this.constructor1.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib)" + Def.LBRACE);
        this.constructor2.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.registration") + "\n" + Def.TAB + " */\n");
        this.constructor2.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib, MBeanServer server)" + Def.LBRACE);
    }

    protected void closeConstructor() throws IOException {
        this.constructor1.append(Def.TAB + Def.RBRACE + "\n");
        this.constructor2.append(Def.TAB + Def.RBRACE + "\n");
    }
}

