/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.BeanIfGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MbeanIfGenerator
extends BeanIfGenerator
implements Serializable {
    protected StringBuffer accessors = new StringBuffer();

    public static String buildMBeanIfName(String pre, String name) {
        return pre + name + Def.MBEANSUFFIX;
    }

    public MbeanIfGenerator(ResourceManager mgr, MibNode aGroup, Context ctxt) throws IOException {
        super(mgr, aGroup, ctxt);
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = MbeanIfGenerator.buildMBeanIfName(this.prefix, this.varName);
        Trace.info(MessageHandler.getMessage("generate.info.if", this.varName));
        this.out = this.openFile(this.symboleName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbeanif.comment.desc", this.varName) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.INTERFACE + this.symboleName + Def.LBRACE + "\n");
    }

    public void endOfGroup() throws IOException {
        this.write(this.accessors.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    public void handleNode(MibNode aNode) throws IOException {
        this.handleNode(aNode, this.context);
    }

    public void handleNode(MibNode aNode, Context ctxt) throws IOException {
        if (aNode.isGroup() || aNode.hasNestedGroups()) {
            this.handleNestedGroups(aNode, ctxt);
            return;
        }
        if (aNode.isTable()) {
            this.handleTable(aNode, ctxt);
            return;
        }
        String varName = aNode.getSymbolName();
        ASTObjectTypeDefinition definition = aNode.getObjectType();
        if (definition == null) {
            return;
        }
        ASTNamedType syntax = definition.getSyntax();
        String strSyntax = "";
        if (syntax.isEnumeratedType()) {
            String enumTypeName = syntax.getEnumeratedDef().getSymbol();
            if (enumTypeName.length() == 0) {
                enumTypeName = varName;
            }
            strSyntax = this.prefix + Def.ENUMPREFIX + enumTypeName + " ";
            aNode.setEnumerated(true);
            aNode.setEnumeratedType(strSyntax);
        } else {
            strSyntax = syntax.getMbeanSyntax();
        }
        this.addAccessors(aNode, strSyntax, varName, ctxt);
    }

    protected void handleNestedGroups(MibNode node, Context ctxt) throws IOException {
    }

    protected void handleTable(MibNode aNode, Context ctxt) throws IOException {
        if (!ctxt.genItfTableAccess) {
            return;
        }
        String variable = aNode.getSymbolName();
        String tableName = this.prefix + Def.TABLEPREFIX + variable;
        String entryName = this.getTableEntryName(aNode);
        this.accessors.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.access", variable) + "\n" + Def.TAB + " */\n");
        this.accessors.append(Def.TAB + Def.PUBLIC + tableName + " " + Def.ACCESS + variable + "() " + accessThrows + "\n");
    }

    private String getTableEntryName(MibNode aNode) throws IOException {
        Hashtable children = aNode.getChildren();
        if (children.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", aNode.getRealSymbolName()));
            throw new IOException();
        }
        Enumeration a = children.elements();
        MibNode entryNode = (MibNode)a.nextElement();
        String varName = entryNode.getSymbolName();
        if (varName == null) {
            varName = this.getClassName(entryNode.getComputedOid());
        }
        String symboleName = this.prefix + varName;
        return symboleName;
    }

    protected void addGetter(Context ctxt, MibNode node, String description, String syntax, String var, StringBuffer buff) {
        buff.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.getter", var) + "\n" + Def.TAB + " */\n");
        buff.append(Def.TAB + Def.PUBLIC + syntax + Def.GET + var + "() " + accessThrows + "\n");
    }

    protected void addChecker(Context ctxt, MibNode node, String description, String syntax, String var, StringBuffer buff) {
        buff.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.checker", var) + "\n" + Def.TAB + " */\n");
        buff.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.CHECK + var + "(" + syntax + "x) " + accessThrows + "\n");
    }

    protected void addSetter(Context ctxt, MibNode node, String description, String syntax, String var, StringBuffer buff) {
        buff.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.setter", var) + "\n" + Def.TAB + " */\n");
        buff.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.SET + var + "(" + syntax + "x) " + accessThrows + "\n");
    }

    protected void addAccessors(MibNode node, String syntax, String var, Context ctxt) throws IOException {
        ASTObjectTypeDefinition definition = node.getObjectType();
        String description = definition.getDefinition().getDescription();
        int access = definition.getDefinition().getAccess();
        if (access != 7 || ctxt.genAFNGetter) {
            this.addGetter(ctxt, node, description, syntax, var, this.accessors);
        }
        if (access == 68 || access == 85 || access == 66) {
            this.addSetter(ctxt, node, description, syntax, var, this.accessors);
            this.addChecker(ctxt, node, description, syntax, var, this.accessors);
        }
    }
}

