/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MetaBeanGenerator;
import com.sun.jdmk.tools.mibgen.MetaTableGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import java.io.IOException;

class MetaGroupGenerator
extends MetaBeanGenerator {
    protected StringBuffer isTable_impl;
    protected StringBuffer getTable_impl;
    protected StringBuffer getTable_body;
    protected StringBuffer regTable_impl;
    protected StringBuffer factory_impl;
    protected int tablecount;

    public MetaGroupGenerator(ResourceManager mgr, MibNode aGroup, Context ctxt) throws IOException {
        super(mgr, aGroup, ctxt);
    }

    protected void initBuffers() {
        super.initBuffers();
        this.tablecount = 0;
        this.getTable_impl = new StringBuffer();
        this.getTable_body = new StringBuffer();
        this.regTable_impl = new StringBuffer();
        this.isTable_impl = new StringBuffer();
        this.factory_impl = new StringBuffer();
    }

    protected String getParentClass() {
        return Def.SNMP_GROUP;
    }

    protected String getParentClassPkg() {
        return Def.PKG_SNMP_MIB_GROUP;
    }

    protected void handleInit(String id, String var, int acc) throws IOException {
        if (acc == 67 || acc == 66 || acc == 68) {
            this.init_impl.append(Def.TAB3 + Def.METH_REGISTER_VAR + "(" + id + ")" + Def.SEMICOLON);
            ++this.counter;
        }
    }

    protected void closeConstructor() throws IOException {
        if (this.counter > 0) {
            this.constructor.append(Def.TAB2 + "try " + Def.N_LBRACE);
        }
        this.constructor.append(this.init_impl.toString());
        if (this.counter > 0) {
            this.constructor.append(Def.TAB2 + Def.N_RBRACE + " catch (" + Def.EXCP_ILLEGAL + " e)" + Def.LBRACE);
            this.constructor.append(Def.TAB3 + "throw new " + Def.EXCP_RT + "(e.getMessage())" + Def.SEMICOLON);
            this.constructor.append(Def.TAB2 + Def.RBRACE);
        }
        this.constructor.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildIsTableHeader() throws IOException {
        this.isTable_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.istable", "arc") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + "boolean" + " " + Def.METH_IS_TABLE + "(long arc)" + Def.LBRACE);
        this.isTable_impl.append("\n" + Def.TAB2 + "switch((int)arc)" + Def.LBRACE);
    }

    protected void handleIsTable(MibNode aNode, String name, String id) throws IOException {
        this.isTable_impl.append(Def.TAB3 + "case " + id + ":\n");
        this.isTable_impl.append(Def.TAB4 + "return true" + Def.SEMICOLON);
    }

    protected void closeIsTable() throws IOException {
        this.isTable_impl.append(Def.TAB3 + "default:\n");
        this.isTable_impl.append(Def.TAB4 + "break" + Def.SEMICOLON);
        this.isTable_impl.append(Def.TAB2 + Def.RBRACE);
        this.isTable_impl.append(Def.TAB2 + "return false" + Def.SEMICOLON);
        this.isTable_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildGetTableHeader() throws IOException {
        this.getTable_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.gettable", "arc") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_TABLE + " " + Def.METH_GET_TABLE + "(long arc)" + Def.LBRACE);
    }

    protected void handleGetTable(MibNode aNode, String name, String id) throws IOException {
        this.getTable_body.append(Def.TAB3 + "case " + id + ":\n");
        this.getTable_body.append(Def.TAB4 + "return table" + name + Def.SEMICOLON);
    }

    protected void closeGetTable() throws IOException {
        if (this.tablecount > 0) {
            this.getTable_impl.append("\n" + Def.TAB2 + "switch((int)arc)" + Def.LBRACE);
            this.getTable_impl.append((Object)this.getTable_body);
            this.getTable_impl.append(Def.TAB2 + "default:\n");
            this.getTable_impl.append(Def.TAB3 + "break" + Def.SEMICOLON);
            this.getTable_impl.append(Def.TAB2 + Def.RBRACE);
        }
        this.getTable_impl.append(Def.TAB2 + "return null" + Def.SEMICOLON);
        this.getTable_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildRegisterTableHeader() throws IOException {
        this.regTable_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.regtables") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_REGTABLES + "(" + Def.SNMP_MIB + " mib, " + Def.MBEANSERVER + " server)" + Def.LBRACE);
    }

    protected void handleRegisterTable(MibNode aNode, String name, String id) throws IOException {
        String metaName = MetaTableGenerator.buildMetaName(this.context, this.context.prefix, name);
        String metafactory = this.getMetaFactoryName(metaName);
        this.regTable_impl.append(Def.TAB2 + "table" + name + " = " + metafactory + "(\"" + name + "\", \"" + this.varName + "\", mib, server)" + Def.SEMICOLON);
        this.regTable_impl.append(Def.TAB2 + "if ( table" + name + " != null) " + Def.LBRACE + Def.TAB3 + "table" + name + "." + Def.METH_T_REGENTRY + "(mib,server)" + Def.SEMICOLON + Def.TAB3 + "mib." + Def.METH_T_REGTABLEMETA + "(\"" + name + "\", table" + name + ")" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + "\n");
    }

    public void generateFactoryComments(String groupName, String className, String tableName, String type, StringBuffer result) {
        result.append("\n" + Def.TAB + "/**");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.table.abstract." + type, tableName));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text1." + type));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text2." + type));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.table.param.tablename", tableName));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.table.param.groupname", groupName));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.table.param.mib"));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.server"));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.return1." + type));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.table.return2." + type, tableName, className));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " **/" + "\n");
    }

    protected void handleTableFactory(MibNode aNode, String name, String id) throws IOException {
        this.generateMetaFactory(this.varName, name, this.factory_impl);
    }

    protected String getMetaFactoryName(String metaName) {
        return "create" + metaName + "Node";
    }

    protected void createMeta(String metaName, StringBuffer result) {
        result.append(Def.TAB2 + Def.RETURN + "new " + metaName + "(mib, " + OBJSRV + ")" + Def.SEMICOLON);
    }

    protected void generateMetaFactory(String groupName, String tableName, StringBuffer result) {
        String metaName = MetaTableGenerator.buildMetaName(this.context, this.context.prefix, tableName);
        String metafactory = this.getMetaFactoryName(metaName);
        this.generateFactoryComments(groupName, metaName, tableName, "meta", result);
        result.append(Def.TAB + Def.PROTECTED + metaName + " " + metafactory + "(String tableName, String groupName, " + Def.SNMP_MIB + " mib, MBeanServer server) " + Def.LBRACE);
        this.createMeta(metaName, result);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeRegisterTable() throws IOException {
        this.regTable_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void handleDeclareTable(MibNode aNode, String name, String id) {
        this.var_def.append(Def.TAB + Def.PROTECTED + this.prefix + name + Def.TABLEMETA + " table" + name + " = null" + Def.SEMICOLON);
    }

    protected void handleTableId(MibNode aNode, String name, String id) throws IOException {
        super.handleTableId(aNode, name, id);
        ++this.tablecount;
        this.handleIsTable(aNode, name, id);
        this.handleGetTable(aNode, name, id);
        this.handleRegisterTable(aNode, name, id);
        this.handleDeclareTable(aNode, name, id);
        this.handleTableFactory(aNode, name, id);
    }

    protected void buildMethodHeaders() throws IOException {
        super.buildMethodHeaders();
        this.buildIsTableHeader();
        this.buildGetTableHeader();
        this.buildRegisterTableHeader();
    }

    protected void closeMethods() throws IOException {
        super.closeMethods();
        this.closeIsTable();
        this.closeGetTable();
        this.closeRegisterTable();
    }

    protected void writeMethods() throws IOException {
        super.writeMethods();
        this.write(this.isTable_impl.toString());
        this.write(this.getTable_impl.toString());
        this.write(this.regTable_impl.toString());
        this.write(this.factory_impl.toString());
    }
}

