/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTIdentifier;
import com.sun.jdmk.tools.mibgen.ASTIndexParts;
import com.sun.jdmk.tools.mibgen.ASTIndexTypesV2;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinitionV1;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinitionV2;
import com.sun.jdmk.tools.mibgen.BeanGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MbeanGenerator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MetaBeanGenerator;
import com.sun.jdmk.tools.mibgen.MetaEntryGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.Node;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.TableBeanGenerator;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MetaTableGenerator
extends BeanGenerator
implements Serializable {
    protected int gentype = 0;
    protected StringBuffer var_list = new StringBuffer();
    protected StringBuffer table_impl = new StringBuffer();
    protected StringBuffer getReq_impl = new StringBuffer();
    protected StringBuffer validateVar_impl = new StringBuffer();
    protected StringBuffer readableVar_impl = new StringBuffer();
    protected StringBuffer getNextVarId_impl = new StringBuffer();
    protected StringBuffer skipEntryVar_impl = new StringBuffer();
    protected StringBuffer setReq_impl = new StringBuffer();
    protected StringBuffer checkReq_impl = new StringBuffer();
    protected StringBuffer constructor = new StringBuffer();
    protected StringBuffer create_req_impl = new StringBuffer();
    protected StringBuffer factory_impl = new StringBuffer();
    private String entryName = "";
    private String realName = "";
    private MibNode entryNode;
    private MetaEntryGenerator entryGen = null;
    public static final String OBJSRV = "objectserver";
    public static final String NODE = "node";

    public static String buildMetaName(Context ctxt, String pre, String name) {
        if (ctxt.gentype == 2) {
            return pre + name + ctxt.genericPrefix + Def.TABLEMETA;
        }
        if (ctxt.gentype == 1) {
            return pre + name + ctxt.standardPrefix + Def.TABLEMETA;
        }
        return pre + name + Def.METAPREFIX;
    }

    public MetaTableGenerator(ResourceManager mgr, MibNode table, Context ctxt) throws IOException {
        super(mgr, table, ctxt);
        this.gentype = ctxt.gentype;
        this.varName = this.node.getSymbolName();
        this.realName = this.node.getRealSymbolName();
        this.oid = this.node.getOid();
        this.symboleName = MetaTableGenerator.buildMetaName(ctxt, ctxt.prefix, this.varName);
    }

    public void generateCode() throws IOException {
        this.processEntry();
        this.processTable();
    }

    protected void processEntry() throws IOException {
        Hashtable children = this.node.getChildren();
        if (children.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", this.realName));
            throw new IOException();
        }
        Enumeration a = children.elements();
        this.entryNode = (MibNode)a.nextElement();
        this.entryName = MbeanGenerator.getNodeSymbolName(this.context, this.entryNode);
        this.entryGen = new MetaEntryGenerator(this.manager, this.entryNode, this.context);
        Enumeration e = this.entryNode.getChildren().elements();
        while (e.hasMoreElements()) {
            MibNode var = (MibNode)e.nextElement();
            this.entryGen.handleNode(var);
        }
        this.entryGen.endOfGroup();
    }

    protected void processTable() throws IOException {
        this.out = this.openFile(this.symboleName + Def.JAVA);
        try {
            this.writeHeader();
            this.writeClassDeclaration();
            this.buildMethods();
            this.writeBuffers();
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (IOException x) {
            throw x;
        }
        finally {
            this.closeIO();
        }
    }

    protected void buildRowStatus() throws IOException {
        if (this.entryGen == null) {
            throw new NullPointerException("Can't find entry generator");
        }
        if (this.entryGen.implementsRowStatus()) {
            String rsid = this.entryGen.getRowStatusId();
            String rsname = this.entryGen.getRowStatusName();
            this.generateRowStatus(rsid, rsname, this.table_impl);
        } else {
            this.generateRowStatus();
        }
    }

    protected void genMethodCall(String tab, String call, String res, StringBuffer result) throws IOException {
        String meth = null;
        if (this.isStandard()) {
            result.append(tab + this.entryName + Def.MBEANSUFFIX + " entry = (" + this.entryName + Def.MBEANSUFFIX + ") " + Def.GET_ENTRY + "(rowOid)" + Def.SEMICOLON);
            meth = Def.SET_MOI;
        }
        if (this.isGeneric()) {
            result.append(tab + "ObjectName entry = " + Def.GET_ENTRYNAME + "(rowOid)" + Def.SEMICOLON);
            meth = Def.SET_OBJNAME;
        }
        result.append(tab + Def.SYNCHRONIZE + "(this)" + Def.LBRACE);
        if (meth != null) {
            result.append(tab + Def.TAB + NODE + "." + meth + "(entry)" + Def.SEMICOLON);
        }
        result.append(tab + Def.TAB + res + NODE + "." + call + Def.SEMICOLON + tab + Def.RBRACE);
    }

    protected void genCatchedMethodCall(String tab, String call, String res, StringBuffer result) throws IOException {
        String meth = null;
        if (this.isStandard()) {
            result.append(tab + this.entryName + Def.MBEANSUFFIX + " entry = null" + Def.SEMICOLON);
            result.append(tab + "try " + Def.LBRACE);
            result.append(tab + Def.TAB + "entry = (" + this.entryName + Def.MBEANSUFFIX + ") " + Def.GET_ENTRY + "(rowOid)" + Def.SEMICOLON);
            result.append(tab + Def.N_RBRACE + " catch (" + Def.EXCP_SNMP + " x) " + Def.LBRACE);
            result.append(tab + Def.TAB + "entry = null" + Def.SEMICOLON);
            result.append(tab + Def.RBRACE);
            meth = Def.SET_MOI;
        }
        if (this.isGeneric()) {
            result.append(tab + "ObjectName entry = null" + Def.SEMICOLON);
            result.append(tab + "try " + Def.LBRACE);
            result.append(tab + Def.TAB + "entry = " + Def.GET_ENTRYNAME + "(rowOid)" + Def.SEMICOLON);
            result.append(tab + Def.N_RBRACE + " catch (" + Def.EXCP_SNMP + " x) " + Def.LBRACE);
            result.append(tab + Def.TAB + "entry = null" + Def.SEMICOLON);
            result.append(tab + Def.RBRACE);
            meth = Def.SET_OBJNAME;
        }
        result.append(tab + Def.SYNCHRONIZE + "(this)" + Def.LBRACE);
        if (meth != null) {
            result.append(tab + Def.TAB + NODE + "." + meth + "(entry)" + Def.SEMICOLON);
        }
        result.append(tab + Def.TAB + res + NODE + "." + call + Def.SEMICOLON + tab + Def.RBRACE);
    }

    protected void generateRowStatus() throws IOException {
    }

    protected void generateRowStatus(String rowStatusId, String rowStatusName, StringBuffer result) throws IOException {
        this.genAbstractMethodComment(Def.METH_T_ISRS, Def.SNMP_TABLE, result);
        result.append("\n" + Def.TAB + Def.PUBLIC + " boolean " + Def.METH_T_ISRS + "(" + Def.SNMP_OID + " rowOid, " + "long var, " + Def.SNMP_USERDATA + " userData) " + Def.LBRACE);
        result.append(Def.TAB2 + Def.RETURN + "(var == " + rowStatusId + ")" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_HASRS, Def.SNMP_TABLE, result);
        result.append("\n" + Def.TAB + Def.PUBLIC + " boolean " + Def.METH_T_HASRS + "() " + Def.LBRACE);
        result.append(Def.TAB2 + Def.RETURN + "true" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_SETRS, Def.SNMP_TABLE, result);
        result.append("\n" + Def.TAB + Def.PUBLIC + " SnmpValue " + Def.METH_T_SETRS + "(" + Def.SNMP_OID + " rowOid, " + "int status, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genMethodCall(Def.TAB2, Def.METH_T_SETRS + "(status, userData)", "return ", result);
        result.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_ISROWREADY, Def.SNMP_TABLE, result);
        result.append("\n" + Def.TAB + Def.PUBLIC + " boolean " + Def.METH_T_ISROWREADY + "(" + Def.SNMP_OID + " rowOid, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genMethodCall(Def.TAB2, Def.METH_T_ISROWREADY + "(userData)", "return ", result);
        result.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_MAPRSVALUE, Def.SNMP_TABLE, result);
        result.append("\n" + Def.TAB + Def.PUBLIC + " int " + Def.METH_T_MAPRSVALUE + "(" + Def.SNMP_OID + " rowOid, " + Def.SNMP_VARBIND + " vbstatus, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genCatchedMethodCall(Def.TAB2, Def.METH_T_MAPRSVALUE + "(vbstatus, userData)", "return ", result);
        result.append(Def.TAB + Def.RBRACE + "\n");
        result.append("\n" + Def.TAB + Def.PUBLIC + " int " + Def.METH_T_GETRS + "(" + Def.SNMP_OID + " rowOid, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genMethodCall(Def.TAB2, Def.METH_T_GETRS + "(userData)", "return ", result);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildMethods() throws IOException {
        this.buildCreateReqHeader();
        this.processIndex();
        this.buildTable();
        this.buildRowStatus();
        this.buildConstructorHeader();
        this.buildGetReqHeader();
        this.buildSetReqHeader();
        this.buildCheckReqHeader();
        this.buildValidateVarHeader();
        this.buildIsReadableVarHeader();
        this.buildGetNextVarIdHeader();
        this.buildSkipEntryVarHeader();
        this.generateMetaFactory(this.factory_impl);
    }

    protected void writeBuffers() throws IOException {
        this.write(this.constructor.toString());
        this.write(this.factory_impl.toString());
        this.write(this.create_req_impl.toString());
        this.write(this.table_impl.toString());
        this.write(this.getReq_impl.toString());
        this.write(this.setReq_impl.toString());
        this.write(this.checkReq_impl.toString());
        this.write(this.validateVar_impl.toString());
        this.write(this.readableVar_impl.toString());
        this.write(this.getNextVarId_impl.toString());
        this.write(this.skipEntryVar_impl.toString());
        this.write(this.var_list.toString());
        this.write("\n" + Def.RBRACE);
    }

    public void setContext(Context ctxt) {
        super.setContext(ctxt);
        this.gentype = ctxt.gentype;
    }

    boolean isStandard() {
        return (this.gentype & 1) != 0;
    }

    boolean isGeneric() {
        return (this.gentype & 2) != 0;
    }

    public String getTableClassName() {
        return this.symboleName + " ";
    }

    public String getSymbolName() {
        return this.varName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbean.comment.desc", this.varName) + "\n" + " * " + MessageHandler.getMessage("generate.mbean.comment.oid", this.oid) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.symboleName + Def.EXTEND + Def.SNMP_TABLE + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_VECTOR + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_OBJECT_NAME + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_COUNTER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_COUNTER64 + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_GAUGE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_INT + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_UINT + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_IP_ADDR + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_TIME_TICKS + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_OPAQUE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING_FIXED + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_OID + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_NULL + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_VALUE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_VARBIND + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STATUS_EXCEPTION + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_INDEX + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB_TABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_SUBREQ + Def.SEMICOLON);
        String[] intf = this.getInterfacePkgs();
        if (intf != null) {
            for (int i = 0; i < intf.length; ++i) {
                this.write(Def.IMPORT + intf[i] + Def.SEMICOLON);
            }
        }
        this.write("\n");
    }

    protected String getObjectServerClass() {
        if (this.isStandard()) {
            return Def.SNMP_STANDARD_OSRV;
        }
        if (this.isGeneric()) {
            return Def.SNMP_GENERIC_OSRV;
        }
        return "Object";
    }

    protected String[] getInterfacePkgs() {
        int count = 0;
        if (this.isStandard()) {
            ++count;
        }
        if (this.isGeneric()) {
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] result = new String[count];
        if (this.isGeneric()) {
            result[--count] = Def.PKG_SNMP_GENERIC_OSRV;
        }
        if (this.isStandard()) {
            result[--count] = Def.PKG_SNMP_STANDARD_OSRV;
        }
        return result;
    }

    private void buildTable() throws IOException {
        this.table_impl.append("\n");
        this.genAbstractMethodComment(Def.METH_T_ISNAMEREQ, Def.SNMP_TABLE, this.table_impl);
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.BOOLEAN + Def.METH_T_ISNAMEREQ + "() " + Def.LBRACE);
        if (this.isGeneric()) {
            this.table_impl.append(Def.TAB2 + Def.RETURN + "true" + Def.SEMICOLON);
        } else {
            this.table_impl.append(Def.TAB2 + Def.RETURN + "false" + Def.SEMICOLON);
        }
        this.table_impl.append(Def.TAB + Def.RBRACE + "\n\n");
        String nodeType = MetaBeanGenerator.buildMetaName(this.context, "", this.entryName);
        this.table_impl.append("\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_REGENTRY + "(" + Def.SNMP_MIB + " mib, " + Def.MBEANSERVER + " server) " + Def.LBRACE);
        this.table_impl.append(Def.TAB2 + NODE + " = " + this.getMetaFactoryName(nodeType) + "(" + "\"" + this.entryName + "\", \"" + this.varName + "\", mib, server)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_ADD, Def.SNMP_TABLE, this.table_impl);
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.SYNCHRONIZE + Def.VOID + Def.METH_T_ADD + "(" + Def.SNMP_OID + " rowOid, " + Def.OBJECT_NAME + " objname,\n" + Def.TAB4 + " Object entry)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        if (this.isGeneric()) {
            this.table_impl.append(Def.TAB2 + Def.METH_T_ADD + "(rowOid, objname, entry, true)" + Def.SEMICOLON);
        } else {
            String stdbeanclass = TableBeanGenerator.getEntryInterfaceName(this.context, this.entryName);
            this.table_impl.append(Def.TAB2 + "if (! (entry instanceof " + stdbeanclass + ") )\n");
            this.table_impl.append(Def.TAB3 + "throw new ClassCastException(" + "\"Entries for Table \\\"\" + \n");
            this.table_impl.append(Def.TAB3 + "               " + "\"" + this.varName + "\" + \"\\\" must implement the \\\"\" + \n");
            this.table_impl.append(Def.TAB3 + "               " + "\"" + stdbeanclass + "\" + \"\\\" interface.\")" + Def.SEMICOLON);
            this.table_impl.append(Def.TAB2 + "super." + Def.METH_T_ADD + "(rowOid, objname, entry)" + Def.SEMICOLON);
        }
        this.table_impl.append(Def.TAB + Def.RBRACE + "\n");
        if (this.isGeneric()) {
            this.table_impl.append(Def.TAB + Def.PUBLIC + Def.SYNCHRONIZE + Def.VOID + Def.METH_T_ADD + "(" + Def.SNMP_OID + " rowOid," + Def.OBJECT_NAME + " objname," + " Object entry," + " boolean registerFlag)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
            this.table_impl.append(Def.TAB2 + "if (" + "objname == null" + ")\n");
            this.table_impl.append(Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_INCONSISTENTNAME + ")" + Def.SEMICOLON);
            this.table_impl.append(Def.TAB2 + "if (" + "entry != null" + " && " + "registerFlag" + ")" + Def.LBRACE);
            this.table_impl.append(Def.TAB3 + OBJSRV + ".registerTableEntry" + "(this, rowOid, objname, entry)" + Def.SEMICOLON + Def.TAB3 + Def.RBRACE);
            this.table_impl.append(Def.TAB2 + "super." + Def.METH_T_ADD + "(rowOid, objname, entry)" + Def.SEMICOLON);
            this.table_impl.append(Def.TAB + Def.RBRACE + "\n");
        }
    }

    private void processIndex() throws IOException {
        this.getIndexFromEntry(null);
    }

    private void getIndexFromEntry(MibNode ref) throws IOException {
        ASTObjectTypeDefinition definition = ref != null ? ref.getObjectType() : this.entryNode.getObjectType();
        if (!(definition.getDefinition() instanceof ASTObjectTypeDefinitionV1)) {
            this.getV2IndexFromEntry((ASTObjectTypeDefinitionV2)definition.getDefinition(), ref);
            return;
        }
        this.getV1IndexFromEntry((ASTObjectTypeDefinitionV1)definition.getDefinition(), ref);
    }

    private void getV1IndexFromEntry(ASTObjectTypeDefinitionV1 definition, MibNode ref) throws IOException {
        this.processIndexes(definition.getIndex(), ref);
    }

    private void processIndexes(Node indexes, MibNode ref) throws IOException {
        if (indexes == null) {
            Trace.error(MessageHandler.getMessage("generate.error.table.noIndex", this.realName));
            throw new IOException();
        }
        int nbIndexes = indexes.jjtGetNumChildren();
        String[] indexObjectNames = new String[nbIndexes];
        for (int i = 0; i < nbIndexes; ++i) {
            ASTIdentifier id = (ASTIdentifier)indexes.jjtGetChild(i);
            String key = id.getName();
            MibNode indexNode = ref == null ? this.entryNode.getChildWithName(key) : ref.getChildWithName(key);
            if (indexNode == null) {
                indexNode = this.mib.getModuleHandler().findNodeWithName(key);
                if (indexNode == null) {
                    Trace.error(MessageHandler.getMessage("generate.error.table.index", key, this.realName));
                    throw new IOException();
                }
                this.node.addExternalIndex(indexNode);
            }
            if (ref != null) {
                this.node.addExternalIndex(indexNode);
            }
            ASTObjectTypeDefinition def = indexNode.getObjectType();
            String keyName = indexNode.getSymbolName();
            ASTNamedType syntaxObject = def.getSyntax();
            String baseSyntaxEntry = syntaxObject.getSnmpSyntax();
            String snmpSyntax = SyntaxMapper.getTypeName(baseSyntaxEntry);
            indexObjectNames[i] = keyName;
        }
        String dot = this.packageName.length() != 0 ? "." : "";
        String entryObjectName = "\"" + this.symboleName + ":name=" + this.packageName + dot + this.entryName + "\"";
        String buildObjectName = "\"" + this.symboleName + ":name=" + this.packageName + dot + this.entryName + "\"";
        for (int j = 0; j < nbIndexes; ++j) {
            entryObjectName = entryObjectName + " + \"," + indexObjectNames[j] + "=\" + " + "entry." + indexObjectNames[j];
            buildObjectName = buildObjectName + " + \"," + indexObjectNames[j] + "=\" + " + "_key" + indexObjectNames[j];
        }
    }

    private void getV2IndexFromEntry(ASTObjectTypeDefinitionV2 definition, MibNode ref) throws IOException {
        ASTIndexParts indexParts = (ASTIndexParts)definition.getIndex();
        if (indexParts.type == 11) {
            String reference = indexParts.getAugmentIdentifier();
            MibNode indexNode = this.mib.getModuleHandler().findNodeWithName(reference);
            if (indexNode == null) {
                Trace.error(MessageHandler.getMessage("generate.error.table.index", reference, this.realName));
                throw new IOException();
            }
            this.getIndexFromEntry(indexNode);
            return;
        }
        ASTIndexTypesV2 v2Index = (ASTIndexTypesV2)indexParts.jjtGetChild(0);
        this.processIndexes(v2Index, ref);
    }

    public void generateFactoryComments(String entryName, String className, String varName, String type, StringBuffer result) {
        result.append("\n" + Def.TAB + "/**");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.abstract." + type, entryName));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text1." + type));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text2." + type));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.name", entryName));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.tablename", varName));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.mib"));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.server"));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.return1." + type));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.return2." + type, entryName, className));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " **/" + "\n");
    }

    protected String getMetaFactoryName(String metaName) {
        return new String("create" + metaName + "Node");
    }

    protected void createMeta(String metaName, StringBuffer result) {
        result.append(Def.TAB2 + Def.RETURN + "new " + metaName + "(mib, " + OBJSRV + ")" + Def.SEMICOLON);
    }

    protected void generateMetaFactory(StringBuffer result) {
        String metaName = MetaBeanGenerator.buildMetaName(this.context, "", this.entryName);
        this.generateFactoryComments(this.entryName, metaName, this.varName, "meta", result);
        String metafactory = this.getMetaFactoryName(metaName);
        result.append(Def.TAB + Def.PROTECTED + metaName + " " + metafactory + "(String snmpEntryName, " + "String tableName, " + Def.SNMP_MIB + " mib, MBeanServer server) " + Def.LBRACE);
        this.createMeta(metaName, result);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildConstructorHeader() throws IOException {
        this.constructor.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.registration") + "\n" + Def.TAB + " */\n");
        this.constructor.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib, " + this.getObjectServerClass() + " objserv)" + Def.LBRACE);
        String nodeType = MetaBeanGenerator.buildMetaName(this.context, "", this.entryName);
        this.constructor.append(Def.TAB2 + "super(myMib)" + Def.SEMICOLON + Def.TAB2 + OBJSRV + " = objserv" + Def.SEMICOLON);
        this.constructor.append(Def.TAB + Def.RBRACE + "\n");
        this.var_list.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.var") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PRIVATE + nodeType + " " + NODE + Def.SEMICOLON + "\n");
        this.var_list.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.objserver") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PROTECTED + this.getObjectServerClass() + " " + OBJSRV + Def.SEMICOLON);
    }

    protected void buildValidateVarHeader() throws IOException {
        this.validateVar_impl.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.validatevarid", "var") + "\n" + Def.TAB + " */\n");
        this.validateVar_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_VALIDATE + "( " + Def.SNMP_OID + " rowOid, long var, " + Def.SNMP_USERDATA + " data )\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.validateVar_impl.append(Def.TAB2 + NODE + ".validateVarId(var, data)" + Def.SEMICOLON + Def.TAB + Def.RBRACE);
    }

    protected void buildIsReadableVarHeader() throws IOException {
        this.readableVar_impl.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.isreadable", "var") + "\n" + Def.TAB + " */\n");
        this.readableVar_impl.append(Def.TAB + Def.PUBLIC + Def.BOOLEAN + Def.METH_T_READABLE + "( " + Def.SNMP_OID + " rowOid, long var, " + Def.SNMP_USERDATA + " data )\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.readableVar_impl.append(Def.TAB2 + Def.RETURN + NODE + "." + Def.METH_IS_READABLE + "(var)" + Def.SEMICOLON + Def.TAB + Def.RBRACE);
    }

    protected void buildGetNextVarIdHeader() throws IOException {
        this.getNextVarId_impl.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.getnextvarid", "var") + "\n" + Def.TAB + " */\n");
        this.getNextVarId_impl.append(Def.TAB + Def.PUBLIC + "long " + Def.METH_T_GETNEXTVARID + "( " + Def.SNMP_OID + " rowOid, long var, " + Def.SNMP_USERDATA + " data )\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.getNextVarId_impl.append(Def.TAB2 + "long nextvar = " + NODE + ".getNextVarId(var, data)" + Def.SEMICOLON);
        this.getNextVarId_impl.append(Def.TAB2 + "while (!" + Def.METH_T_READABLE + "(rowOid, nextvar, data))\n");
        this.getNextVarId_impl.append(Def.TAB3 + "nextvar = " + NODE + ".getNextVarId(nextvar, data)" + Def.SEMICOLON);
        this.getNextVarId_impl.append(Def.TAB2 + Def.RETURN + "nextvar" + Def.SEMICOLON + Def.TAB + Def.RBRACE);
    }

    protected void buildSkipEntryVarHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_SKIPVARIABLE, Def.SNMP_TABLE, this.skipEntryVar_impl);
        this.skipEntryVar_impl.append(Def.TAB + Def.PUBLIC + "boolean " + Def.METH_T_SKIPVARIABLE + "( " + Def.SNMP_OID + " rowOid, long var, " + Def.SNMP_USERDATA + " data, int pduVersion)" + Def.LBRACE);
        this.skipEntryVar_impl.append(Def.TAB2 + "try" + Def.LBRACE);
        this.genMethodCall(Def.TAB3, Def.METH_SKIP_VARIABLE + "(var, data, pduVersion)", "return ", this.skipEntryVar_impl);
        this.skipEntryVar_impl.append(Def.TAB2 + Def.N_RBRACE + " catch (" + Def.EXCP_SNMP + " x)" + Def.LBRACE + Def.TAB3 + "return false" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE);
        this.skipEntryVar_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void genAbstractMethodComment(String methname, String classname, StringBuffer result) throws IOException {
        result.append("\n" + Def.TAB + Def.LINE);
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.implements", methname, classname));
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.seedoc", classname));
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + Def.LINE + "\n\n");
    }

    protected void buildSetReqHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_SETREQ, Def.SNMP_TABLE, this.getReq_impl);
        this.setReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_SETREQ + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid," + " int depth" + ")\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.setReq_impl.append(Def.TAB2 + "if (req.getSize() == 0) return;\n\n");
        this.genMethodCall(Def.TAB2, "set(req,depth)", "", this.setReq_impl);
        this.setReq_impl.append(Def.TAB + Def.RBRACE);
    }

    protected void buildGetReqHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_GETREQ, Def.SNMP_TABLE, this.getReq_impl);
        this.getReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_GETREQ + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid," + " int depth" + ")\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genMethodCall(Def.TAB2, "get(req,depth)", "", this.getReq_impl);
        this.getReq_impl.append(Def.TAB + Def.RBRACE);
    }

    protected void buildCheckReqHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_CHECKREQ, Def.SNMP_TABLE, this.checkReq_impl);
        this.checkReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_CHECKREQ + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid," + " int depth" + ")\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.checkReq_impl.append(Def.TAB2 + "if (req.getSize() == 0) return;\n\n");
        this.genMethodCall(Def.TAB2, "check(req,depth)", "", this.checkReq_impl);
        this.checkReq_impl.append(Def.TAB + Def.RBRACE);
    }

    protected void buildCreateReqHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_CREATE, Def.SNMP_TABLE, this.create_req_impl);
        this.create_req_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_CREATE + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid, int depth)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.create_req_impl.append(Def.TAB2 + "if (factory != null)\n");
        this.create_req_impl.append(Def.TAB3 + "factory." + Def.METH_T_CREATE + "(req, rowOid, depth, this)" + Def.SEMICOLON);
        this.create_req_impl.append(Def.TAB2 + "else\n");
        this.create_req_impl.append(Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(\n");
        this.create_req_impl.append(Def.TAB4 + Def.EXCP_SNMP + "." + Def.V_NOACCESS + ")" + Def.SEMICOLON);
        this.create_req_impl.append(Def.TAB + Def.RBRACE + "\n");
    }
}

