/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MetaBeanGenerator;
import com.sun.jdmk.tools.mibgen.MibGenProperties;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import java.io.IOException;
import java.io.Serializable;

public class MibGenerator
extends Generator
implements Serializable {
    protected String module = "";
    protected String translatedMibName = "";
    protected String fileName = "";
    protected int gentype = 0;
    protected StringBuffer init_impl = new StringBuffer();
    protected StringBuffer regmeta_impl = new StringBuffer();
    protected StringBuffer getmeta_impl = new StringBuffer();
    protected StringBuffer objsrv_impl = new StringBuffer();
    protected StringBuffer initprereg_impl = new StringBuffer();
    protected StringBuffer populate_impl = new StringBuffer();
    protected StringBuffer factory_impl = new StringBuffer();
    protected StringBuffer var_def = new StringBuffer();
    private String domainSeparator = ".";
    private static final String OBJSRV = "objectserver";
    private static final String ISINIT = "isInitialized";
    private static final String METAS = "metadatas";

    public MibGenerator(ResourceManager mgr, ASTMib aMib, Context ctxt) throws IOException {
        super(mgr, ctxt);
        this.mib = aMib;
        this.gentype = ctxt.gentype;
        this.context.mib = aMib;
        this.context.mibgen = this;
        this.module = aMib.getModuleName();
        this.translatedMibName = this.translateMibName();
        this.fileName = MibGenerator.getMibClassName(this.prefix, aMib);
        this.out = this.openFile(this.fileName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.writeConstructor();
        this.buildInitHeader();
        this.buildPopulateHeader();
        this.buildInitPreRegHeader();
        this.buildRegisterTableMeta(this.regmeta_impl);
        this.buildGetRegisteredMeta(this.getmeta_impl);
        if (this.isStandard()) {
            this.buildGetStandardObjectServer(this.objsrv_impl);
        }
    }

    public void setContext(Context ctxt) {
        super.setContext(ctxt);
        this.mib = ctxt.mib;
        this.gentype = ctxt.gentype;
        ctxt.mibgen = this;
    }

    protected boolean isAbstractFactory() {
        return MibGenProperties.getBooleanProperty("com.sun.jdmk.tools.mibgen.options.mib.factory.abstract", false);
    }

    protected String getMetaFactoryName(String metaName) {
        return "create" + metaName + "Node";
    }

    protected String getBeanFactoryName(String beanName) {
        return "create" + beanName + Def.MBEANSUFFIX;
    }

    protected String getBeanFactoryResult(Context ctxt, String varName, String beanName) {
        if (MibGenerator.isGeneric(ctxt, varName)) {
            return "Object";
        }
        return "Object";
    }

    protected String getBeanInterfaceName(Context ctxt, String varName, String beanName) {
        return beanName + Def.MBEANSUFFIX;
    }

    public void generateFactoryComments(String varName, String className, String actualClass, String type, StringBuffer result) {
        result.append("\n" + Def.TAB + "/**");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.abstract." + type, varName));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text1." + type));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text2." + type));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.name", varName));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.oid"));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.objname"));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.server"));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.return1." + type));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.return2." + type, varName, className));
        result.append("\n" + Def.TAB + " * ");
        if (actualClass != null) {
            if (this.isStandard()) {
                result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
                result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", actualClass));
                result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
            } else {
                result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
                result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", actualClass));
                result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
            }
        }
        result.append("\n" + Def.TAB + " **/" + "\n");
    }

    protected void createMeta(String metaName, StringBuffer result) {
        result.append(Def.TAB2 + Def.RETURN + "new " + metaName + "(this, " + OBJSRV + ")" + Def.SEMICOLON);
    }

    protected void generateMetaFactory(Context ctxt, String varName, String oid, String metaName, String implName, String objname, StringBuffer result) {
        this.generateFactoryComments(varName, metaName, null, "meta", result);
        String metafactory = this.getMetaFactoryName(metaName);
        result.append(Def.TAB + Def.PROTECTED + metaName + " " + metafactory + "(String groupName,\n" + Def.TAB4 + "String groupOid," + " ObjectName groupObjname, MBeanServer server) " + Def.LBRACE);
        this.createMeta(metaName, result);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void generateBeanFactory(Context ctxt, String varName, String oid, String metaName, String implName, String objname, StringBuffer result) {
        String beanfactory = this.getBeanFactoryName(implName);
        String stdbeanclass = this.getBeanInterfaceName(ctxt, varName, implName);
        String beanclass = this.getBeanFactoryResult(ctxt, varName, implName);
        String abstr = this.isAbstractFactory() ? Def.ABSTRACT : "";
        this.generateFactoryComments(varName, implName, stdbeanclass, "bean", result);
        result.append(Def.TAB + Def.PROTECTED + abstr + beanclass + " " + beanfactory + "(String groupName,\n" + Def.TAB4 + "String groupOid, " + " ObjectName groupObjname, MBeanServer server)");
        if (this.isAbstractFactory()) {
            result.append(Def.SEMICOLON + "\n");
            return;
        }
        result.append(" " + Def.LBRACE);
        if (this.isStandard()) {
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", stdbeanclass));
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
            result.append("\n" + Def.TAB2 + "//\n");
        } else {
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", stdbeanclass));
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
            result.append("\n" + Def.TAB2 + "//\n");
        }
        result.append(Def.TAB2 + "if (server != null) \n" + Def.TAB3 + Def.RETURN + "new " + implName + "(this,server)" + Def.SEMICOLON + Def.TAB2 + "else \n" + Def.TAB3 + Def.RETURN + "new " + implName + "(this)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    public String getInitMethodName(Context ctxt, String varName) {
        if (ctxt.gentype == 2) {
            return Def.INIT + ctxt.genericPrefix + varName;
        }
        if (ctxt.gentype == 1) {
            return Def.INIT + ctxt.standardPrefix + varName;
        }
        return Def.INIT + varName;
    }

    public void generateInitNodeMethod(Context ctxt, String varName, String oid, String metaName, String implName, String objname, StringBuffer result) {
        result.append("\n" + Def.TAB + "/**");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init.group", varName));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init.support1"));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init.support2", this.getMetaFactoryName(metaName)));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.server"));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " **/\n");
        result.append(Def.TAB + Def.PROTECTED + Def.VOID + this.getInitMethodName(ctxt, varName) + "(" + Def.MBEANSERVER + " server) " + "\n" + Def.TAB2 + Def.THROWS + "Exception" + Def.LBRACE);
        this.populateMib(ctxt, varName, oid, metaName, implName, objname, result);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    public void populateMib(Context ctxt, String varName, String oid, String metaName, String implName, String objname, StringBuffer result) {
        String objnamevar = "objname";
        String server = "server";
        String metafactory = this.getMetaFactoryName(metaName);
        String beanfactory = this.getBeanFactoryName(implName);
        String stdbeanclass = this.getBeanInterfaceName(ctxt, varName, implName);
        String beanclass = this.getBeanFactoryResult(ctxt, varName, implName);
        result.append(Def.TAB2 + "final String oid = " + Def.METH_T_GETOID + "(\"" + varName + "\", \"" + oid + "\")" + Def.SEMICOLON);
        result.append(Def.TAB2 + "ObjectName " + objnamevar + " = null" + Def.SEMICOLON);
        result.append(Def.TAB2 + "if (" + server + " != null) " + Def.N_LBRACE);
        result.append(Def.TAB3 + objnamevar + " = " + Def.METH_T_GETOBJNAME + "(\"" + varName + "\", oid, " + objname + ")" + Def.SEMICOLON);
        result.append(Def.TAB2 + Def.RBRACE);
        result.append(Def.TAB2 + "final " + metaName + " meta = " + metafactory + "(\"" + varName + "\", oid, " + objnamevar + ", " + server + ")" + Def.SEMICOLON);
        result.append(Def.TAB2 + "if (meta != null) " + Def.N_LBRACE);
        result.append(Def.TAB3 + "meta." + Def.METH_T_REGTABLES + "( this, server )" + Def.SEMICOLON);
        if (this.isGeneric()) {
            result.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
            result.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", stdbeanclass));
            result.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
            result.append("\n" + Def.TAB3 + "//\n");
            result.append(Def.TAB3 + "final " + beanclass + " group = " + beanfactory + "(\"" + varName + "\", oid, " + objnamevar + ", " + server + ")" + Def.SEMICOLON);
        } else {
            result.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
            result.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", stdbeanclass));
            result.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
            result.append("\n" + Def.TAB3 + "//\n");
            result.append(Def.TAB3 + "final " + stdbeanclass + " group = (" + stdbeanclass + ") " + beanfactory + "(\"" + varName + "\", oid, " + objnamevar + ", " + server + ")" + Def.SEMICOLON);
        }
        if (MibGenerator.isStandard(ctxt, varName)) {
            result.append(Def.TAB3 + "meta." + Def.SET_MOI + "( group )" + Def.SEMICOLON);
        }
        if (MibGenerator.isGeneric(ctxt, varName)) {
            result.append(Def.TAB3 + "meta." + Def.SET_OBJNAME + "( " + objnamevar + " )" + Def.SEMICOLON);
        }
        result.append(Def.TAB3 + Def.METH_T_REGGROUP + "(\"" + varName + "\", oid, " + objnamevar + ", meta, group, " + server + ")" + Def.SEMICOLON);
        result.append(Def.TAB2 + Def.RBRACE);
    }

    public void registerNode(MibNode node, Context ctxt, String domain) throws IOException {
        String varName = node.getSymbolName();
        if (varName == null) {
            varName = this.getClassName(node.getComputedOid());
        }
        String oid = node.getComputedOid();
        String metaName = MetaBeanGenerator.buildMetaName(this.context, this.context.prefix, varName);
        String implName = this.prefix + varName;
        String dot = this.packageName.length() != 0 ? "." : "";
        domain = domain == null ? "" : this.domainSeparator + domain;
        String objname = new String("mibName + \"" + domain + ":name=" + this.packageName + dot + implName + "\"");
        this.populate_impl.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.init.group", varName) + "\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.init.support1") + "\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.init.support2", this.getMetaFactoryName(metaName)) + "\n" + Def.TAB2 + "//\n");
        this.populate_impl.append(Def.TAB2 + this.getInitMethodName(ctxt, varName) + "(server)" + Def.SEMICOLON);
        this.populate_impl.append("\n");
        this.factory_impl.append("\n" + Def.TAB + Def.LINE);
        this.factory_impl.append("\n" + Def.TAB + "// ");
        this.factory_impl.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.init.group", varName));
        this.factory_impl.append("\n" + Def.TAB + "// ");
        this.factory_impl.append("\n" + Def.TAB + Def.LINE + "\n\n");
        this.generateInitNodeMethod(ctxt, varName, oid, metaName, implName, objname, this.factory_impl);
        this.generateMetaFactory(ctxt, varName, oid, metaName, implName, objname, this.factory_impl);
        this.generateBeanFactory(ctxt, varName, oid, metaName, implName, objname, this.factory_impl);
    }

    public void endMib() throws IOException {
        this.closeInit();
        this.closeInitPreReg();
        this.closePopulate();
        this.write(this.init_impl.toString());
        this.write(this.initprereg_impl.toString());
        this.write(this.populate_impl.toString());
        this.write(this.factory_impl.toString());
        this.write(this.regmeta_impl.toString());
        this.write(this.getmeta_impl.toString());
        if (this.isStandard()) {
            this.write(this.objsrv_impl.toString());
        }
        this.writeVariableDefinition();
        this.write(Def.RBRACE);
        this.closeIO();
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mib.comment.header", this.module) + "\n" + " * " + MessageHandler.getMessage("generate.mib.comment.modif") + "\n" + " */\n");
        this.write(Def.PUBLIC);
        if (this.isAbstractFactory()) {
            this.write(Def.ABSTRACT);
        }
        this.write(Def.CLASS + this.fileName + Def.EXTEND + Def.SNMP_MIB + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_HASHTABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_OBJECT_NAME + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_INSTANCE_ALREADY_EXISTS_EXCEPTION + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB_NODE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_TABLE + Def.SEMICOLON);
        String[] intf = this.getInterfacePkgs();
        if (intf != null) {
            for (int i = 0; i < intf.length; ++i) {
                this.write(Def.IMPORT + intf[i] + Def.SEMICOLON);
            }
        }
        this.write("\n");
    }

    protected void writeConstructor() throws IOException {
        this.write(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.const") + "\n" + Def.TAB + " */\n");
        this.write(Def.TAB + Def.PUBLIC + this.fileName + "()" + Def.LBRACE + Def.TAB2 + "mibName = \"" + this.translatedMibName + "\"" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildInitHeader() throws IOException {
        this.init_impl.append(Def.TAB + "/**\n");
        this.init_impl.append(Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init") + "\n");
        this.init_impl.append(Def.TAB + " */\n");
        this.init_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_INIT + "() " + Def.THROWS + Def.EXCP_ILLEGAL + Def.LBRACE);
        this.init_impl.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.oneCall") + "\n");
        this.init_impl.append(Def.TAB2 + "//\n");
        this.init_impl.append(Def.TAB2 + "if (" + ISINIT + " == true)" + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + Def.RETURN + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.RBRACE + "\n");
        this.init_impl.append(Def.TAB2 + "try " + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + Def.METH_T_POPULATE + "(null, null)" + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(" + Def.EXCP_ILLEGAL + " x) " + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + "throw x" + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(RuntimeException x) " + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + "throw x" + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(Exception x) " + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + Def.THROW_NEW + "Error(x.getMessage())" + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.RBRACE + "\n");
    }

    static boolean isStandard(Context ctxt, String groupName) {
        return (ctxt.gentype & 1) != 0;
    }

    static boolean isGeneric(Context ctxt, String groupName) {
        return (ctxt.gentype & 2) != 0;
    }

    protected String getObjectServerClass() {
        if (this.isStandard()) {
            return Def.SNMP_STANDARD_OSRV;
        }
        if (this.isGeneric()) {
            return Def.SNMP_GENERIC_OSRV;
        }
        return "Object";
    }

    protected String[] getInterfacePkgs() {
        int count = 0;
        if (this.isStandard()) {
            ++count;
        }
        if (this.isGeneric()) {
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] result = new String[count];
        if (this.isGeneric()) {
            result[--count] = Def.PKG_SNMP_GENERIC_OSRV;
        }
        if (this.isStandard()) {
            result[--count] = Def.PKG_SNMP_STANDARD_OSRV;
        }
        return result;
    }

    protected void createObjectServer(StringBuffer result) {
        if (this.isStandard()) {
            this.createStandardObjectServer(result);
        }
        if (this.isGeneric()) {
            this.createGenericObjectServer(result);
        }
    }

    protected void createStandardObjectServer(StringBuffer result) {
        result.append(Def.TAB2 + "if (" + OBJSRV + " == null) \n");
        result.append(Def.TAB3 + OBJSRV + " = new " + this.getObjectServerClass() + "()" + Def.SEMICOLON);
    }

    protected void createGenericObjectServer(StringBuffer result) {
        result.append(Def.TAB2 + "if (" + OBJSRV + " == null) \n");
        result.append(Def.TAB3 + OBJSRV + " = new " + this.getObjectServerClass() + "(server)" + Def.SEMICOLON);
    }

    protected void buildPopulateHeader() throws IOException {
        this.populate_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_POPULATE + "(MBeanServer server, ObjectName name) " + "\n" + Def.TAB2 + Def.THROWS + "Exception" + Def.LBRACE + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.oneCall") + "\n" + Def.TAB2 + "//\n" + Def.TAB2 + "if (" + ISINIT + " == true)" + Def.LBRACE + Def.TAB3 + Def.RETURN + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + "\n");
        this.createObjectServer(this.populate_impl);
        this.populate_impl.append("\n");
    }

    protected void buildGetStandardObjectServer(StringBuffer result) {
        result.append(Def.TAB + Def.PUBLIC + this.getObjectServerClass() + " " + Def.METH_T_GETSTDOBJSRV + "()" + Def.LBRACE);
        this.createStandardObjectServer(result);
        result.append(Def.TAB2 + Def.RETURN + OBJSRV + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildRegisterTableMeta(StringBuffer result) {
        result.append("\n" + Def.TAB + Def.LINE);
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.implements", Def.METH_T_REGTABLEMETA, Def.SNMP_MIB));
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.seedoc", Def.SNMP_MIB));
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + Def.LINE + "\n\n");
        result.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_REGTABLEMETA + "( String name, " + Def.SNMP_TABLE + " meta)" + Def.LBRACE);
        result.append(Def.TAB2 + "if (" + METAS + " == null) return" + Def.SEMICOLON);
        result.append(Def.TAB2 + "if (name == null) return" + Def.SEMICOLON);
        result.append(Def.TAB2 + METAS + ".put(name,meta)" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildGetRegisteredMeta(StringBuffer result) {
        result.append("\n" + Def.TAB + Def.LINE);
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.implements", Def.METH_T_GETTABLEMETA, Def.SNMP_MIB));
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.seedoc", Def.SNMP_MIB));
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + Def.LINE + "\n\n");
        result.append(Def.TAB + Def.PUBLIC + Def.SNMP_TABLE + " " + Def.METH_T_GETTABLEMETA + "( String name )" + Def.LBRACE);
        result.append(Def.TAB2 + "if (" + METAS + " == null) return null" + Def.SEMICOLON);
        result.append(Def.TAB2 + "if (name == null) return null" + Def.SEMICOLON);
        result.append(Def.TAB2 + Def.RETURN + "(" + Def.SNMP_TABLE + ") " + METAS + ".get(name)" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildInitPreRegHeader() throws IOException {
        this.initprereg_impl.append(Def.TAB + "/**\n");
        this.initprereg_impl.append(Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.preRegister") + "\n");
        this.initprereg_impl.append(Def.TAB + " */\n");
        this.initprereg_impl.append(Def.TAB + Def.PUBLIC + "ObjectName " + "preRegister(MBeanServer server, " + "ObjectName name)\n");
        this.initprereg_impl.append(Def.TAB3 + Def.THROWS + "Exception" + Def.LBRACE);
        this.initprereg_impl.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.oneCall") + "\n");
        this.initprereg_impl.append(Def.TAB2 + "//\n");
        this.initprereg_impl.append(Def.TAB2 + "if (" + ISINIT + " == true)" + Def.LBRACE);
        this.initprereg_impl.append(Def.TAB3 + Def.THROW_NEW + "InstanceAlreadyExistsException()" + Def.SEMICOLON);
        this.initprereg_impl.append(Def.TAB2 + Def.RBRACE + "\n");
        this.initprereg_impl.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.cmf") + "\n");
        this.initprereg_impl.append(Def.TAB2 + "//\n");
        this.initprereg_impl.append(Def.TAB2 + "this.server = server" + Def.SEMICOLON + "\n");
        this.initprereg_impl.append(Def.TAB2 + Def.METH_T_POPULATE + "(server, name)" + Def.SEMICOLON + "\n");
    }

    protected void closeInit() throws IOException {
        this.init_impl.append(Def.TAB2 + ISINIT + " = true" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closePopulate() throws IOException {
        this.populate_impl.append(Def.TAB2 + ISINIT + " = true" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeInitPreReg() throws IOException {
        this.initprereg_impl.append(Def.TAB2 + ISINIT + " = true" + Def.SEMICOLON + Def.TAB2 + Def.RETURN + "name" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void writeVariableDefinition() throws IOException {
        this.write(Def.TAB + Def.PRIVATE + Def.BOOLEAN + ISINIT + " = false" + Def.SEMICOLON + "\n");
        this.write(Def.TAB + Def.PROTECTED + this.getObjectServerClass() + " " + OBJSRV + Def.SEMICOLON + "\n");
        this.write(Def.TAB + Def.PROTECTED + Def.FINAL + "Hashtable " + METAS + " = new Hashtable()" + Def.SEMICOLON);
    }

    private String translateMibName() throws IOException {
        return MibGenerator.translateMibName(this.module);
    }

    public static String translateMibName(String moduleName) throws IOException {
        String result = moduleName.trim();
        result = result.replace('-', '_');
        result = result.replace('.', '_');
        result = result.replace(',', '_');
        result = result.replace(',', '_');
        result = result.replace(' ', '_');
        return result;
    }

    public static String getMibClassName(String prefix, ASTMib aMib) throws IOException {
        return prefix + MibGenerator.translateMibName(aMib.getModuleName());
    }

    public String setDomainSeparator(String s) {
        if (s != null) {
            this.domainSeparator = s;
        }
        return this.domainSeparator;
    }
}

