/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ObjectTypeDefinition;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MibNode {
    private Hashtable children;
    private String symbolName = null;
    private String oid = null;
    private ASTObjectTypeDefinition objectType = null;
    private String nodeId = "";
    private String computedOid = "";
    private String oidName = "";
    private boolean enumerated = false;
    private String enumeratedType = "";
    private String snmpSyntax = "";
    private long length = -1L;
    private Vector externalIndex = new Vector();

    public MibNode(String nodeId) {
        this.nodeId = nodeId;
        this.computedOid = nodeId;
        this.children = new Hashtable();
    }

    public MibNode getId(String id) {
        if (this.children.containsKey(id)) {
            return (MibNode)this.children.get(id);
        }
        MibNode child = new MibNode(id);
        if (this.nodeId.length() != 0) {
            child.setComputedOid(this.computedOid + "." + id);
        }
        this.children.put(id, child);
        return child;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getOid() {
        return this.oid;
    }

    public Hashtable getChildren() {
        return this.children;
    }

    public MibNode getChildWithName(String name) {
        if (this.children == null) {
            return null;
        }
        if (this.children.isEmpty()) {
            return null;
        }
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            MibNode child = (MibNode)e.nextElement();
            String sym = child.getRealSymbolName();
            if (!name.equals(sym)) continue;
            return child;
        }
        return null;
    }

    public MibNode findNodeWithName(String name) {
        if (this.symbolName != null && name.equals(this.symbolName)) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        if (this.children.isEmpty()) {
            return null;
        }
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            MibNode child = (MibNode)e.nextElement();
            MibNode result = child.findNodeWithName(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getSymbolName() {
        if (this.symbolName == null) {
            return null;
        }
        String result = this.symbolName.trim();
        result = result.replace('-', '_');
        result = result.replace('.', '_');
        result = result.replace(',', '_');
        result = result.replace(',', '_');
        result = result.replace(' ', '_');
        return Character.toUpperCase(result.charAt(0)) + result.substring(1, result.length());
    }

    public String getRealSymbolName() {
        return this.symbolName;
    }

    public String getRealOidName() {
        return this.oidName;
    }

    public boolean isAssociated() {
        return this.symbolName != null;
    }

    public void setComputedOid(String oid) {
        this.computedOid = oid;
    }

    public String getComputedOid() {
        return this.computedOid;
    }

    public void setOidName(String name) {
        this.oidName = name;
    }

    public String getOidName() {
        return Character.toUpperCase(this.oidName.charAt(0)) + this.oidName.substring(1, this.oidName.length());
    }

    public boolean isEnumeratedType() {
        return this.enumerated;
    }

    public void setEnumerated(boolean x) {
        this.enumerated = x;
    }

    public void setEnumeratedType(String x) {
        this.enumeratedType = x;
        this.enumerated = true;
    }

    public String getEnumeratedType() {
        return this.enumeratedType;
    }

    public void setSnmpSyntax(String syntax) {
        this.snmpSyntax = syntax;
    }

    public String getSnmpSyntax() {
        return this.snmpSyntax;
    }

    public ASTObjectTypeDefinition getObjectType() {
        return this.objectType;
    }

    public void setAssociation(String oid, String symbolName, ASTObjectTypeDefinition objectType) {
        this.oid = oid;
        this.symbolName = symbolName;
        this.objectType = objectType;
    }

    public boolean isGroup() {
        if (this.objectType != null) {
            return false;
        }
        boolean result = false;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            MibNode n = (MibNode)e.nextElement();
            if (n == null || !n.isAssociated()) continue;
            result = true;
        }
        return result;
    }

    public boolean oldIsValidGroup() throws IOException {
        if (this.objectType != null) {
            return false;
        }
        boolean result = false;
        MibNode aGroup = null;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            MibNode n = (MibNode)e.nextElement();
            if (n == null) continue;
            if (n.isAssociated()) {
                result = true;
            }
            if (!n.isGroup()) continue;
            aGroup = n;
        }
        if (result && aGroup != null) {
            throw new IOException(aGroup.getComputedOid());
        }
        return result;
    }

    public boolean isValidGroup() throws IOException {
        if (this.objectType != null) {
            return false;
        }
        boolean result = false;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            MibNode n = (MibNode)e.nextElement();
            if (n == null) continue;
            if (n.isAssociated()) {
                result = true;
                continue;
            }
            if (!n.isGroup() && !n.hasNestedGroups()) continue;
        }
        return result;
    }

    public boolean hasNestedGroups() {
        if (this.objectType != null) {
            return false;
        }
        boolean result = false;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            MibNode n = (MibNode)e.nextElement();
            if (n == null) continue;
            if (n.isAssociated() || n.isGroup()) {
                result = true;
                continue;
            }
            if (!n.hasNestedGroups()) continue;
            result = true;
        }
        return result;
    }

    public boolean isSimpleGroup() {
        return this.isGroup() && !this.hasNestedGroups();
    }

    public boolean isComplexGroup() {
        return this.isGroup() && this.hasNestedGroups();
    }

    public boolean isTable() {
        if (this.isGroup()) {
            return false;
        }
        if (this.hasNestedGroups()) {
            return false;
        }
        if (this.children.isEmpty()) {
            return false;
        }
        if (!this.isAssociated()) {
            return false;
        }
        if (this.isEntry()) {
            return false;
        }
        if (this.objectType == null) {
            return false;
        }
        ASTNamedType syntax = this.objectType.getSyntax();
        if (syntax == null) {
            return false;
        }
        return syntax.isSequenceOfType();
    }

    public boolean isEntry() {
        if (!this.isAssociated()) {
            return false;
        }
        if (this.objectType == null) {
            return false;
        }
        ObjectTypeDefinition def = this.objectType.getDefinition();
        if (def == null) {
            return false;
        }
        return def.getIndex() != null;
    }

    public boolean isVariable() {
        if (!this.isAssociated()) {
            return false;
        }
        if (this.isTable()) {
            return false;
        }
        return !this.isEntry();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            MibNode n = (MibNode)e.nextElement();
            if (n == null) continue;
            n.dump(prefix + " ");
        }
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public String toString() {
        if (this.isAssociated()) {
            return "Name= " + this.symbolName + " OID= " + this.oid + " GROUP= " + String.valueOf(this.isGroup());
        }
        return "OID= " + this.computedOid + " Name= " + this.oidName + " GROUP= " + String.valueOf(this.isGroup());
    }

    public void addExternalIndex(MibNode aNode) {
        if (!this.externalIndex.contains(aNode)) {
            this.externalIndex.addElement(aNode);
        }
    }

    public Vector getExternalIndex() {
        return this.externalIndex;
    }

    public void setFixedLength(long fixed) {
        this.length = fixed;
    }

    public long getFixedLength() {
        return this.length;
    }
}

