/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTOidValue;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MibTree {
    private MibNode root;
    private String moduleName;

    public MibTree(String moduleName) {
        this.moduleName = moduleName;
        this.root = new MibNode("");
    }

    public boolean buildTree(Hashtable v1, Hashtable v2) {
        return this.handleObjectList(v1) && this.handleObjectList(v2);
    }

    public void dump(String prefix) {
        Trace.info("MIB MODULE= " + this.moduleName);
        this.root.dump(prefix);
    }

    public MibNode getRoot() {
        return this.root;
    }

    private boolean handleObjectList(Hashtable table) {
        boolean result = true;
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            ASTObjectTypeDefinition obj;
            String key = (String)e.nextElement();
            if (this.register(key, obj = (ASTObjectTypeDefinition)table.get(key))) continue;
            result = false;
        }
        return result;
    }

    private boolean register(String key, ASTObjectTypeDefinition objectType) {
        ObjectTypeDefinition definition = objectType.getDefinition();
        ASTOidValue oid = definition.getOidNode();
        StringBuffer dotNotation = oid.getDotNotation();
        return this.addNode(dotNotation.toString(), key, objectType);
    }

    private boolean addNode(String oid, String key, ASTObjectTypeDefinition objectType) {
        StringTokenizer st = new StringTokenizer(oid, ".", false);
        MibNode curr = this.root;
        while (st.hasMoreTokens()) {
            String id = st.nextToken();
            curr = curr.getId(id);
        }
        if (curr.isAssociated()) {
            Object[] params = new Object[]{curr.getSymbolName(), key, oid, this.moduleName};
            Trace.error(MessageHandler.getMessage("compile.error.duplicate.oid", params));
            return false;
        }
        curr.setAssociation(oid, key, objectType);
        return true;
    }
}

