/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.MibTree;
import com.sun.jdmk.tools.mibgen.SemanticException;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModulesHandler {
    protected Hashtable modules = new Hashtable();
    protected Hashtable id_resolvers = new Hashtable();
    protected Hashtable ind_resolvers;
    protected Hashtable ref_resolvers = new Hashtable();
    private static final String sccs_id = "@(#)ModulesHandler.java 4.12 03/08/07 SMI";

    public ModulesHandler() {
        this.ind_resolvers = new Hashtable();
    }

    public void addMibModule(String mibName, ASTMib theNewMib) throws SemanticException {
        ASTMib aMib = (ASTMib)this.modules.get(mibName);
        if (aMib != null) {
            throw new SemanticException(MessageHandler.getMessage("compile.error.duplicate.module", mibName));
        }
        this.modules.put(mibName, theNewMib);
        Trace.info(MessageHandler.getMessage("compile.info.endParse", mibName));
    }

    public void removeMibModule(String mibName) {
        this.modules.remove(mibName);
    }

    public Enumeration mibElements() {
        return this.modules.elements();
    }

    public boolean resolve() {
        this.localResolve();
        this.globalResolve();
        if (!this.checkSymbolClosure()) {
            return false;
        }
        return this.computeValues();
    }

    public boolean buildMibTrees() {
        boolean result = true;
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            ASTMib mib = (ASTMib)e.nextElement();
            boolean ok = mib.buildMibTree();
            if (ok) continue;
            result = false;
        }
        return result;
    }

    public void dumpMibTrees(String prefix) {
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            ASTMib mib = (ASTMib)e.nextElement();
            mib.printMibTree(prefix);
        }
    }

    public MibNode findNodeWithName(String name) {
        MibNode result = null;
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            ASTMib mib = (ASTMib)e.nextElement();
            MibTree tree = mib.getMibTree();
            MibNode root = tree.getRoot();
            result = root.findNodeWithName(name);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    private boolean computeValues() {
        boolean ok = true;
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            ASTMib mib = (ASTMib)e.nextElement();
            if (mib.computeValues()) continue;
            ok = false;
        }
        return ok;
    }

    private void localResolve() {
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            ASTMib mib = (ASTMib)e.nextElement();
            mib.localResolve();
            this.id_resolvers.put(mib.getModuleName(), mib.getIdResolver());
            this.ref_resolvers.put(mib.getModuleName(), mib.getRefResolver());
            this.ind_resolvers.put(mib.getModuleName(), mib.getIndexResolver());
        }
    }

    private void globalResolve() {
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            ASTMib mib = (ASTMib)e.nextElement();
            mib.globalResolve(this.id_resolvers, this.ref_resolvers, this.ind_resolvers);
        }
    }

    private boolean checkSymbolClosure() {
        boolean ok = true;
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            ASTMib mib = (ASTMib)e.nextElement();
            if (mib.printUndefinedSymbols()) continue;
            ok = false;
        }
        return ok;
    }
}

