/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.SimpleNode;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SymbolHandler {
    protected Hashtable unresolved;
    protected Hashtable resolved;
    protected String mibName;
    private static final String sccs_id = "@(#)SymbolHandler.java 4.9 03/08/07 SMI";

    public SymbolHandler(String mibModule) {
        this.mibName = mibModule;
        this.resolved = new Hashtable();
        this.unresolved = new Hashtable();
    }

    public void addResolution(String symbol, SimpleNode value) {
        SimpleNode val = (SimpleNode)this.resolved.get(symbol);
        if (val != null) {
            Trace.warning(MessageHandler.getMessage("compile.w.resolve", symbol));
            return;
        }
        this.resolved.put(symbol, value);
        Vector list = (Vector)this.unresolved.get(symbol);
        if (list == null) {
            return;
        }
        this.unresolved.remove(symbol);
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            SimpleNode node = (SimpleNode)e.nextElement();
            node.setResolver(value);
        }
    }

    public SimpleNode lookupIdentifier(String symbolName) {
        return (SimpleNode)this.resolved.get(symbolName);
    }

    public boolean printUnresolved() {
        if (this.unresolved.isEmpty()) {
            return true;
        }
        Enumeration e = this.unresolved.keys();
        while (e.hasMoreElements()) {
            String symbol = (String)e.nextElement();
            Trace.error(MessageHandler.getMessage("compile.error.undef", symbol, this.mibName));
        }
        return false;
    }

    public void resolve(Hashtable resolvers) {
        if (this.unresolved.isEmpty()) {
            return;
        }
        Enumeration e = this.unresolved.keys();
        block0: while (e.hasMoreElements()) {
            String symbolName = (String)e.nextElement();
            Enumeration a = resolvers.keys();
            while (a.hasMoreElements()) {
                String key = (String)a.nextElement();
                SymbolHandler external = (SymbolHandler)resolvers.get(key);
                SimpleNode result = external.lookupIdentifier(symbolName);
                if (result == null) continue;
                Trace.info(MessageHandler.getMessage("compile.resolve.info", symbolName, this.mibName, external.getModuleName()));
                this.addResolution(symbolName, result);
                continue block0;
            }
        }
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    public String getModuleName() {
        return this.mibName;
    }
}

