/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTIdentifier;
import com.sun.jdmk.tools.mibgen.ASTIndexParts;
import com.sun.jdmk.tools.mibgen.ASTIndexTypesV2;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinitionV1;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinitionV2;
import com.sun.jdmk.tools.mibgen.BeanGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.EntryGenerator;
import com.sun.jdmk.tools.mibgen.EntryIfGenerator;
import com.sun.jdmk.tools.mibgen.MbeanGenerator;
import com.sun.jdmk.tools.mibgen.MbeanIfGenerator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.Node;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableBeanGenerator
extends BeanGenerator
implements Serializable {
    protected int gentype = 0;
    protected StringBuffer var_list = new StringBuffer();
    protected StringBuffer build_impl = new StringBuffer();
    protected StringBuffer oid_impl = new StringBuffer();
    protected StringBuffer oidval_impl = new StringBuffer();
    protected StringBuffer index_impl = new StringBuffer();
    protected StringBuffer table_impl = new StringBuffer();
    protected StringBuffer get_impl = new StringBuffer();
    protected StringBuffer getReq_impl = new StringBuffer();
    protected StringBuffer getNext_impl = new StringBuffer();
    protected StringBuffer validateVar_impl = new StringBuffer();
    protected StringBuffer getNextVarId_impl = new StringBuffer();
    protected StringBuffer set_impl = new StringBuffer();
    protected StringBuffer setReq_impl = new StringBuffer();
    protected StringBuffer check_impl = new StringBuffer();
    protected StringBuffer checkReq_impl = new StringBuffer();
    protected StringBuffer constructor1 = new StringBuffer();
    protected StringBuffer constructor2 = new StringBuffer();
    protected StringBuffer create_impl = new StringBuffer();
    protected StringBuffer buildname_impl = new StringBuffer();
    protected StringBuffer setobj_impl = new StringBuffer();
    protected StringBuffer factory_impl = new StringBuffer();
    private String entryName = "";
    private String realName = "";
    private MibNode entryNode;
    private MbeanGenerator beanGen;
    private MbeanIfGenerator beanIfGen;

    public TableBeanGenerator(ResourceManager mgr, MibNode table, Context ctxt) throws IOException {
        super(mgr, table, ctxt);
        this.gentype = ctxt.gentype;
        this.varName = this.node.getSymbolName();
        this.realName = this.node.getRealSymbolName();
        this.oid = this.node.getOid();
        this.symboleName = this.prefix + Def.TABLEPREFIX + this.varName;
        this.processEntry();
        this.out = this.openFile(this.symboleName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.buildCreateHeader();
        this.buildBuildNameHeader();
        this.processIndex(ctxt);
        this.processTable();
        this.updateEntryWithExternalIndex();
        this.buildConstructorHeader();
        this.write(this.constructor1.toString());
        this.write(this.constructor2.toString());
        this.write(this.create_impl.toString());
        this.write(this.table_impl.toString());
        this.write(this.buildname_impl.toString());
        this.write(this.build_impl.toString());
        this.write(this.oid_impl.toString());
        this.write(this.oidval_impl.toString());
        this.write(this.index_impl.toString());
        this.write(this.factory_impl.toString());
        this.write(this.var_list.toString());
        this.write("\n" + Def.RBRACE);
        this.closeIO();
    }

    public void setContext(Context ctxt) {
        super.setContext(ctxt);
        this.gentype = ctxt.gentype;
    }

    boolean isStandard() {
        return (this.gentype & 1) != 0;
    }

    boolean isGeneric() {
        return (this.gentype & 2) != 0;
    }

    public String getTableClassName() {
        return this.symboleName + " ";
    }

    public String getSymbolName() {
        return this.varName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbean.comment.desc", this.varName) + "\n" + " * " + MessageHandler.getMessage("generate.mbean.comment.oid", this.oid) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.symboleName + Def.EXTEND + Def.SNMP_TABLE_SUPPORT + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeVersion() throws IOException {
        String msgid = "generate.version";
        this.write("\n//\n// " + MessageHandler.getMessage(msgid, this.mib.getModuleName()) + "\n//\n\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_VECTOR + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_OBJECT_NAME + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_COUNTER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_COUNTER64 + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_GAUGE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_INT + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_UINT + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_IP_ADDR + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_TIME_TICKS + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_OPAQUE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING_FIXED + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_OID + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_NULL + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_VALUE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_VARBIND + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STATUS_EXCEPTION + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_INDEX + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB_TABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_SUBREQ + Def.SEMICOLON);
        String[] intf = this.getInterfacePkgs();
        if (intf != null) {
            for (int i = 0; i < intf.length; ++i) {
                this.write(Def.IMPORT + intf[i] + Def.SEMICOLON);
            }
        }
        this.write("\n");
    }

    protected void genAbstractMethodComment(String methname, String classname, StringBuffer result) throws IOException {
        result.append("\n" + Def.TAB + Def.LINE);
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.implements", methname, classname));
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.seedoc", classname));
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + Def.LINE + "\n\n");
    }

    protected String[] getInterfacePkgs() {
        int count = 3;
        String[] result = new String[count];
        result[--count] = Def.PKG_SNMP_TABLE_SUPPORT;
        result[--count] = Def.PKG_SNMP_TABLE_CB;
        result[--count] = Def.PKG_SNMP_ENTRY_FACTORY;
        return result;
    }

    private void cline(String comment, StringBuffer result) throws IOException {
        result.append("\n" + Def.TAB + " * " + comment);
    }

    private void processTable() throws IOException {
        this.table_impl.append("\n");
        this.genAbstractMethodComment(Def.METH_T_GETTABLEMETA, Def.SNMP_TABLE_SUPPORT, this.table_impl);
        this.table_impl.append(Def.TAB + Def.PROTECTED + Def.SNMP_TABLE + " " + Def.METH_T_GETTABLEMETA + "(" + Def.SNMP_MIB + " mib) " + Def.LBRACE);
        this.table_impl.append(Def.TAB2 + Def.RETURN + "mib." + Def.METH_T_GETTABLEMETA + "(\"" + this.varName + "\")" + Def.SEMICOLON);
        this.table_impl.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_REMENTRYCB, Def.SNMP_TABLE_SUPPORT, this.table_impl);
        this.table_impl.append(Def.TAB + Def.PUBLIC + "void " + Def.METH_T_REMENTRYCB + "(int pos, " + Def.SNMP_OID + " row, " + Def.OBJECT_NAME + " name,\n" + Def.TAB4 + "Object entry, " + Def.SNMP_TABLE + " meta)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.table_impl.append(Def.TAB2 + "try " + Def.LBRACE);
        this.table_impl.append(Def.TAB3 + "super." + Def.METH_T_REMENTRYCB + "(pos,row,name,entry,meta)" + Def.SEMICOLON);
        this.table_impl.append(Def.TAB3 + "if (server != null && name != null)\n");
        this.table_impl.append(Def.TAB4 + "server.unregisterMBean(name)" + Def.SEMICOLON);
        this.table_impl.append(Def.TAB2 + Def.N_RBRACE + " catch (Exception x)" + " { }\n");
        this.table_impl.append(Def.TAB + Def.RBRACE + "\n");
        this.table_impl.append("\n" + Def.TAB + "/**");
        this.cline(MessageHandler.getMessage("generate.table.comment.add1"), this.table_impl);
        this.cline("", this.table_impl);
        this.cline(MessageHandler.getMessage("generate.table.comment.add2"), this.table_impl);
        this.cline(MessageHandler.getMessage("generate.table.comment.add3", Def.METH_T_BUILDNAME), this.table_impl);
        this.cline("", this.table_impl);
        this.cline(MessageHandler.getMessage("generate.table.comment.calls", Def.METH_T_ADD, Def.SNMP_TABLE_SUPPORT), this.table_impl);
        this.cline(MessageHandler.getMessage("generate.mib.comment.seedoc", Def.SNMP_TABLE_SUPPORT), this.table_impl);
        this.cline("", this.table_impl);
        this.table_impl.append("\n" + Def.TAB + " **/\n\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.SYNCHRONIZE + Def.VOID + Def.METH_T_ADD + "(" + this.entryName + Def.MBEANSUFFIX + " entry)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.table_impl.append(Def.TAB2 + Def.SNMP_INDEX + " index = " + Def.BUILD + Def.SNMP_INDEX + "(entry)" + Def.SEMICOLON);
        this.table_impl.append(Def.TAB2 + "super." + Def.METH_T_ADD + "(index, (Object) entry)" + Def.SEMICOLON);
        this.table_impl.append(Def.TAB + Def.RBRACE + "\n");
        this.table_impl.append("\n" + Def.TAB + "/**");
        this.cline(MessageHandler.getMessage("generate.table.comment.add1"), this.table_impl);
        this.cline("", this.table_impl);
        this.cline(MessageHandler.getMessage("generate.table.comment.calls", Def.METH_T_ADD, Def.SNMP_TABLE_SUPPORT), this.table_impl);
        this.cline(MessageHandler.getMessage("generate.mib.comment.seedoc", Def.SNMP_TABLE_SUPPORT), this.table_impl);
        this.cline("", this.table_impl);
        this.table_impl.append("\n" + Def.TAB + " **/\n\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.SYNCHRONIZE + Def.VOID + Def.METH_T_ADD + "(" + this.entryName + Def.MBEANSUFFIX + " entry, ObjectName name)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.table_impl.append(Def.TAB2 + Def.SNMP_INDEX + " index = " + Def.BUILD + Def.SNMP_INDEX + "(entry)" + Def.SEMICOLON);
        this.table_impl.append(Def.TAB2 + "super." + Def.METH_T_ADD + "(index, name, (Object) entry)" + Def.SEMICOLON);
        this.table_impl.append(Def.TAB + Def.RBRACE + "\n");
        this.table_impl.append("\n" + Def.TAB + "/**");
        this.cline(MessageHandler.getMessage("generate.table.comment.getentries"), this.table_impl);
        this.cline("", this.table_impl);
        this.cline(MessageHandler.getMessage("generate.table.comment.calls", Def.METH_T_BASIC, Def.SNMP_TABLE_SUPPORT), this.table_impl);
        this.cline(MessageHandler.getMessage("generate.mib.comment.seedoc", Def.SNMP_TABLE_SUPPORT), this.table_impl);
        this.cline("", this.table_impl);
        this.table_impl.append("\n" + Def.TAB + " **/\n\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.SYNCHRONIZE + this.entryName + Def.MBEANSUFFIX + "[] " + Def.GET_ENTRIES + "()" + Def.LBRACE + Def.TAB2 + "Object[] array = " + Def.METH_T_BASIC + "()" + Def.SEMICOLON + Def.TAB2 + this.entryName + Def.MBEANSUFFIX + "[] result = new " + this.entryName + Def.MBEANSUFFIX + "[array.length]" + Def.SEMICOLON + Def.TAB2 + "java.lang.System.arraycopy(array,0, result," + "0, array.length)" + Def.SEMICOLON + Def.TAB2 + Def.RETURN + "result" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.table_impl.append("\n" + Def.TAB + "/**");
        this.cline(MessageHandler.getMessage("generate.table.comment.remove"), this.table_impl);
        this.cline("", this.table_impl);
        this.cline(MessageHandler.getMessage("generate.table.comment.calls", Def.METH_T_REM, Def.SNMP_TABLE_SUPPORT), this.table_impl);
        this.cline(MessageHandler.getMessage("generate.mib.comment.seedoc", Def.SNMP_TABLE_SUPPORT), this.table_impl);
        this.cline("", this.table_impl);
        this.table_impl.append("\n" + Def.TAB + " **/\n\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_REM + "(" + this.entryName + Def.MBEANSUFFIX + " entry)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.table_impl.append(Def.TAB2 + Def.SNMP_INDEX + " index = " + Def.BUILD + Def.SNMP_INDEX + "(entry)" + Def.SEMICOLON);
        this.table_impl.append(Def.TAB2 + "super." + Def.METH_T_REM + "(index, entry) " + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    private void processIndex(Context ctxt) throws IOException {
        this.buildBuildIndexHeader();
        this.buildBuildOidIndexHeader();
        this.buildBuildIndexOidHeader();
        this.getIndexFromEntry(ctxt, null);
    }

    private void getIndexFromEntry(Context ctxt, MibNode ref) throws IOException {
        ASTObjectTypeDefinition definition = ref != null ? ref.getObjectType() : this.entryNode.getObjectType();
        if (!(definition.getDefinition() instanceof ASTObjectTypeDefinitionV1)) {
            this.getV2IndexFromEntry(ctxt, (ASTObjectTypeDefinitionV2)definition.getDefinition(), ref);
            return;
        }
        this.getV1IndexFromEntry(ctxt, (ASTObjectTypeDefinitionV1)definition.getDefinition(), ref);
    }

    private void getV1IndexFromEntry(Context ctxt, ASTObjectTypeDefinitionV1 definition, MibNode ref) throws IOException {
        this.processIndexes(ctxt, definition.getIndex(), ref);
    }

    private void processIndexes(Context ctxt, Node indexes, MibNode ref) throws IOException {
        if (indexes == null) {
            Trace.error(MessageHandler.getMessage("generate.error.table.noIndex", this.realName));
            throw new IOException();
        }
        int nbIndexes = indexes.jjtGetNumChildren();
        this.build_impl.append(Def.TAB2 + Def.SNMP_OID + "[] oids = new " + Def.SNMP_OID + "[" + String.valueOf(nbIndexes) + "]" + Def.SEMICOLON + Def.TAB2 + Def.SNMP_VALUE + " val = null" + Def.SEMICOLON);
        this.index_impl.append(Def.TAB2 + Def.SNMP_OID + "[] oids = new " + Def.SNMP_OID + "[" + String.valueOf(nbIndexes) + "]" + Def.SEMICOLON + Def.TAB2 + "int pos = start" + Def.SEMICOLON);
        this.oid_impl.append(Def.TAB2 + "if (index.getNbComponents() != " + String.valueOf(nbIndexes) + ")\n" + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + Def.TAB2 + "try" + Def.LBRACE);
        this.oid_impl.append(Def.TAB3 + "Vector v = index.getComponents()" + Def.SEMICOLON);
        this.oidval_impl.append(Def.TAB2 + "try" + Def.LBRACE);
        String[] indexObjectNames = new String[nbIndexes];
        StringBuffer fcall = new StringBuffer();
        String stdbeanclass = TableBeanGenerator.getEntryInterfaceName(ctxt, this.entryName);
        String beanclass = TableBeanGenerator.getEntryFactoryResult(ctxt, this.entryName);
        if (this.isGeneric()) {
            fcall.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
            fcall.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", stdbeanclass));
            fcall.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
            fcall.append("\n" + Def.TAB3 + "//\n");
        } else {
            fcall.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
            fcall.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", stdbeanclass));
            fcall.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
            fcall.append("\n" + Def.TAB3 + "//\n");
        }
        fcall.append(Def.TAB3 + "final " + beanclass + " entry =\n " + Def.TAB4 + TableBeanGenerator.getEntryFactoryName(ctxt, this.entryName) + "(req, rowOid, depth, objname, meta");
        for (int i = 0; i < nbIndexes; ++i) {
            ASTIdentifier id = (ASTIdentifier)indexes.jjtGetChild(i);
            String key = id.getName();
            MibNode indexNode = ref == null ? this.entryNode.getChildWithName(key) : ref.getChildWithName(key);
            if (indexNode == null) {
                ctxt.addExternalSymbol(key);
                indexNode = this.mib.getModuleHandler().findNodeWithName(key);
                if (indexNode == null) {
                    Trace.error(MessageHandler.getMessage("generate.error.table.index", key, this.realName));
                    throw new IOException();
                }
                this.node.addExternalIndex(indexNode);
            }
            if (ref != null) {
                this.node.addExternalIndex(indexNode);
            }
            ASTObjectTypeDefinition def = indexNode.getObjectType();
            String keyName = indexNode.getSymbolName();
            ASTNamedType syntaxObject = def.getSyntax();
            if (ctxt.getJavaSyntax(keyName) == null) {
                ctxt.setIndexSyntax(keyName, syntaxObject);
            }
            String baseSyntaxEntry = syntaxObject.getSnmpSyntax();
            String snmpSyntax = SyntaxMapper.getTypeName(baseSyntaxEntry);
            indexObjectNames[i] = keyName;
            this.create_impl.append(Def.TAB3 + Def.FINAL + Def.SNMP_OID + " oid" + i + " = (" + Def.SNMP_OID + ") v.elementAt(" + String.valueOf(i) + ")" + Def.SEMICOLON);
            this.buildname_impl.append(Def.TAB3 + "oid = (" + Def.SNMP_OID + ") v.elementAt(" + String.valueOf(i) + ")" + Def.SEMICOLON);
            if (!indexNode.isEnumeratedType()) {
                fcall.append(",\n" + Def.TAB5 + "oid" + i + "." + SyntaxMapper.getIndexCastMethod(baseSyntaxEntry) + "()");
                this.buildname_impl.append(Def.TAB3 + "String _key" + keyName + " = oid." + SyntaxMapper.getIndexCastMethod(baseSyntaxEntry) + "().toString()" + Def.SEMICOLON);
            } else {
                String enumeratiom = indexNode.getEnumeratedType();
                fcall.append(",\n" + Def.TAB5 + "new " + enumeratiom + "(oid" + i + "." + SyntaxMapper.getIndexCastMethod(baseSyntaxEntry) + "())");
                this.buildname_impl.append(Def.TAB3 + "String _key" + keyName + " = new " + enumeratiom + "(oid." + SyntaxMapper.getIndexCastMethod(baseSyntaxEntry) + "()).toString()" + Def.SEMICOLON);
            }
            if (indexNode.getFixedLength() == -1L || indexNode.getFixedLength() != -1L && snmpSyntax.compareTo("SnmpString") != 0) {
                this.build_impl.append(Def.TAB2 + "val = new " + snmpSyntax + "(");
                this.index_impl.append(Def.TAB2 + "oids[" + String.valueOf(i) + "] = " + snmpSyntax + "." + Def.METH_FROMINDEX + "(index, pos)" + Def.SEMICOLON);
                if (i < nbIndexes - 1) {
                    this.index_impl.append(Def.TAB2 + "pos = " + snmpSyntax + "." + Def.METH_NEXTINDDEX + "(index, pos)" + Def.SEMICOLON);
                }
                this.oid_impl.append(Def.TAB3 + snmpSyntax + "." + Def.METH_APPENDTOOID + "((" + Def.SNMP_OID + ")v.elementAt(" + String.valueOf(i) + "), oid)" + Def.SEMICOLON);
                this.oidval_impl.append(Def.TAB3 + snmpSyntax + "." + Def.METH_APPENDTOOID + "(new " + snmpSyntax + "(a" + keyName + ")." + Def.METH_TOOID + "(), oid)" + Def.SEMICOLON);
            } else {
                String length = String.valueOf(indexNode.getFixedLength());
                this.build_impl.append(Def.TAB2 + "val = new " + snmpSyntax + Def.FIXED + "(" + length + " ,");
                this.index_impl.append(Def.TAB2 + "oids[" + String.valueOf(i) + "] = " + snmpSyntax + Def.FIXED + "." + Def.METH_FROMINDEX + "(" + length + ", index, pos)" + Def.SEMICOLON);
                if (i < nbIndexes - 1) {
                    this.index_impl.append(Def.TAB2 + "pos = " + snmpSyntax + Def.FIXED + "." + Def.METH_NEXTINDDEX + "(" + length + ", index, pos)" + Def.SEMICOLON);
                }
                this.oid_impl.append(Def.TAB3 + snmpSyntax + Def.FIXED + "." + Def.METH_APPENDTOOID + "(" + length + ", (" + Def.SNMP_OID + ")v.elementAt(" + String.valueOf(i) + "), oid)" + Def.SEMICOLON);
                this.oidval_impl.append(Def.TAB3 + snmpSyntax + Def.FIXED + "." + Def.METH_APPENDTOOID + "(" + length + ", new " + snmpSyntax + "(a" + keyName + ")." + Def.METH_TOOID + "(), oid)" + Def.SEMICOLON);
            }
            this.build_impl.append("entry." + Def.GET + keyName + "())" + Def.SEMICOLON);
            this.build_impl.append(Def.TAB2 + "oids[" + String.valueOf(i) + "] = val." + Def.METH_TOOID + "()" + Def.SEMICOLON);
        }
        this.oid_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(ArrayIndexOutOfBoundsException e)" + Def.LBRACE + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + Def.TAB2 + "return oid" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.oidval_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(ArrayIndexOutOfBoundsException e)" + Def.LBRACE + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + Def.TAB2 + "return oid" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.build_impl.append(Def.TAB2 + Def.RETURN + Def.NEW + Def.SNMP_INDEX + "(oids)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.index_impl.append(Def.TAB2 + Def.RETURN + Def.NEW + Def.SNMP_INDEX + "(oids)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        String dot = this.packageName.length() != 0 ? "." : "";
        String buildObjectName = "\"" + this.symboleName + ":name=" + this.packageName + dot + this.entryName + "\"";
        for (int j = 0; j < nbIndexes; ++j) {
            buildObjectName = buildObjectName + " + \"," + indexObjectNames[j] + "=\" + " + "_key" + indexObjectNames[j];
        }
        fcall.append(")" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB3 + "ObjectName objname = null" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB3 + "if (server != null)\n");
        this.create_impl.append(Def.TAB4 + "objname = " + Def.METH_T_BUILDNAME + "( index )" + Def.SEMICOLON);
        this.create_impl.append(fcall.toString());
        this.buildname_impl.append(Def.TAB3 + "return new ObjectName(" + buildObjectName + ")" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB3 + "if (server != null)" + Def.LBRACE);
        this.create_impl.append(Def.TAB4 + "server.registerMBean(entry, objname)" + Def.SEMICOLON + Def.TAB3 + Def.RBRACE);
        this.create_impl.append(Def.TAB3 + "meta." + Def.METH_T_ADD + "(rowOid,objname,entry)" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(" + Def.EXCP_SNMP + " e)" + Def.LBRACE + Def.TAB3 + "throw e" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(ArrayIndexOutOfBoundsException e)" + Def.LBRACE + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGVALUE + ")" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(Exception e)" + Def.LBRACE + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(e.getMessage())" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE);
        this.create_impl.append(Def.TAB + Def.RBRACE + "\n");
        this.buildname_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(ArrayIndexOutOfBoundsException e)" + Def.LBRACE + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGVALUE + ")" + Def.SEMICOLON);
        this.buildname_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(Exception e)" + Def.LBRACE + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(e.getMessage())" + Def.SEMICOLON + Def.TAB2 + Def.RBRACE);
        this.buildname_impl.append(Def.TAB + Def.RBRACE + "\n");
        this.buildBuildOidIndexValHeader(ctxt, indexObjectNames, nbIndexes);
        this.generateEntryFactory(ctxt, indexObjectNames, nbIndexes, this.entryName, this.factory_impl);
    }

    public static String getEntryFactoryName(Context ctxt, String entryName) {
        return "create" + entryName + Def.MBEANSUFFIX;
    }

    public static String getEntryFactoryResult(Context ctxt, String entryName) {
        return "Object";
    }

    public static String getEntryInterfaceName(Context ctxt, String entryName) {
        return entryName + Def.MBEANSUFFIX;
    }

    private void generateFactoryComments(Context ctxt, String[] indexNames, int indexCount, String entryName, String implName, StringBuffer result) {
        result.append("\n" + Def.TAB + "/**");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.abstract.bean", entryName));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text1.bean"));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text2.bean"));
        result.append("\n" + Def.TAB + " * ");
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.return1.bean"));
        result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.return2.bean", entryName));
        result.append("\n" + Def.TAB + " * ");
        if (this.isStandard()) {
            result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
            result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", implName));
            result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
        } else {
            result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
            result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", implName));
            result.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
        }
        result.append("\n" + Def.TAB + " */\n");
    }

    private void generateEntryFactory(Context ctxt, String[] indexNames, int indexCount, String entryName, StringBuffer result) {
        int i;
        String stdbeanclass = TableBeanGenerator.getEntryInterfaceName(ctxt, entryName);
        this.generateFactoryComments(ctxt, indexNames, indexCount, entryName, stdbeanclass, result);
        result.append("\n" + Def.TAB + Def.PUBLIC + TableBeanGenerator.getEntryFactoryResult(ctxt, entryName) + " " + TableBeanGenerator.getEntryFactoryName(ctxt, entryName) + "(" + Def.SNMP_SUBREQ + " req,\n");
        result.append(Def.TAB4 + Def.SNMP_OID + " rowOid, " + "int depth, ObjectName entryObjName,\n");
        result.append(Def.TAB4 + Def.SNMP_TABLE + " meta");
        int j = 1;
        for (i = 0; i < indexCount; ++i) {
            String typeName = ctxt.getJavaSyntax(indexNames[i]);
            if (j % 3 == 0) {
                result.append(",\n" + Def.TAB4);
            } else {
                result.append(", ");
            }
            result.append(typeName + " a" + indexNames[i]);
        }
        result.append(")\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + " " + Def.LBRACE);
        if (this.isStandard()) {
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", stdbeanclass));
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
            result.append("\n" + Def.TAB2 + "//\n");
        } else {
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", stdbeanclass));
            result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
            result.append("\n" + Def.TAB2 + "//\n");
        }
        result.append(Def.TAB2 + entryName + " entry = new " + entryName + "(theMib)" + Def.SEMICOLON);
        for (i = 0; i < indexCount; ++i) {
            result.append(Def.TAB2 + "entry." + indexNames[i] + " = a" + indexNames[i] + Def.SEMICOLON);
        }
        result.append(Def.TAB2 + Def.RETURN + "entry" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    private void getV2IndexFromEntry(Context ctxt, ASTObjectTypeDefinitionV2 definition, MibNode ref) throws IOException {
        ASTIndexParts indexParts = (ASTIndexParts)definition.getIndex();
        if (indexParts.type == 11) {
            String reference = indexParts.getAugmentIdentifier();
            MibNode indexNode = this.mib.getModuleHandler().findNodeWithName(reference);
            if (indexNode == null) {
                Trace.error(MessageHandler.getMessage("generate.error.table.index", reference, this.realName));
                throw new IOException();
            }
            this.getIndexFromEntry(ctxt, indexNode);
            return;
        }
        ASTIndexTypesV2 v2Index = (ASTIndexTypesV2)indexParts.jjtGetChild(0);
        this.processIndexes(ctxt, v2Index, ref);
    }

    private void processEntry() throws IOException {
        Hashtable children = this.node.getChildren();
        if (children.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", this.realName));
            throw new IOException();
        }
        Enumeration a = children.elements();
        this.entryNode = (MibNode)a.nextElement();
        this.beanGen = new EntryGenerator(this.manager, this.entryNode, this.context);
        this.beanIfGen = new EntryIfGenerator(this.manager, this.entryNode, this.context);
        Enumeration e = this.entryNode.getChildren().elements();
        while (e.hasMoreElements()) {
            MibNode aNode = (MibNode)e.nextElement();
            this.beanGen.handleNode(aNode);
            this.beanIfGen.handleNode(aNode);
        }
        this.entryName = this.beanGen.getSnmpClassName();
    }

    protected void updateEntryWithExternalIndex() throws IOException {
        Enumeration e = this.node.getExternalIndex().elements();
        while (e.hasMoreElements()) {
            MibNode aNode = (MibNode)e.nextElement();
            this.beanGen.handleNode(aNode);
            this.beanIfGen.handleNode(aNode);
        }
        this.beanGen.endOfGroup();
        this.beanIfGen.endOfGroup();
    }

    protected void buildBuildIndexHeader() throws IOException {
        this.build_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.index", this.entryName) + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_INDEX + " " + Def.BUILD + Def.SNMP_INDEX + "(" + this.entryName + Def.MBEANSUFFIX + " entry)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
    }

    protected void buildBuildOidIndexValHeader(Context ctxt, String[] indexNames, int indexCount) {
        boolean j = true;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < indexCount; ++i) {
            String typeName = ctxt.getJavaSyntax(indexNames[i]);
            result.append(typeName + "a" + indexNames[i]);
            if (i == indexCount - 1) continue;
            result.append(", ");
        }
        this.oidval_impl.insert(0, Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.index", this.entryName) + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_OID + " " + Def.METH_T_BUILDOIDVAL + "(" + result.toString() + ")\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + " " + Def.LBRACE + Def.TAB2 + Def.SNMP_OID + " oid = new " + Def.SNMP_OID + "()" + Def.SEMICOLON);
    }

    protected void buildBuildOidIndexHeader() throws IOException {
        this.index_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.index", this.entryName) + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_INDEX + " " + Def.BUILD + Def.SNMP_INDEX + "(long[] index, int start)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
    }

    protected void buildBuildIndexOidHeader() throws IOException {
        this.oid_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.index", this.entryName) + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_OID + " " + Def.METH_T_BUILDOID + "(" + Def.SNMP_INDEX + " index)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE + Def.TAB2 + Def.SNMP_OID + " oid = new " + Def.SNMP_OID + "()" + Def.SEMICOLON);
    }

    protected void buildConstructorHeader() throws IOException {
        this.constructor1.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.noRegistration") + "\n" + Def.TAB + " */\n");
        this.constructor1.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib)" + Def.LBRACE);
        this.constructor2.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.registration") + "\n" + Def.TAB + " */\n");
        this.constructor2.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib, MBeanServer server)" + Def.LBRACE);
        this.constructor1.append(Def.TAB2 + "super(myMib)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.constructor2.append(Def.TAB2 + "this(myMib)" + Def.SEMICOLON + Def.TAB2 + "this.server = server" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.var_list.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.server") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PROTECTED + "MBeanServer server" + Def.SEMICOLON);
    }

    protected void buildCreateHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_CREATE, Def.SNMP_TABLE_SUPPORT, this.create_impl);
        this.create_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_CREATE + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid,\n" + Def.TAB4 + " int depth, " + Def.SNMP_TABLE + " meta)\n");
        this.create_impl.append(Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.create_impl.append(Def.TAB2 + Def.FINAL + Def.SNMP_INDEX + " index = " + Def.BUILD + Def.SNMP_INDEX + "(rowOid)" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB2 + Def.FINAL + "Vector v = index.getComponents()" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB2 + Def.SNMP_OID + " oid" + Def.SEMICOLON);
        this.create_impl.append(Def.TAB2 + "try " + Def.LBRACE);
    }

    protected void buildBuildNameHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_BUILDNAME, Def.SNMP_TABLE_SUPPORT, this.buildname_impl);
        this.buildname_impl.append("\n" + Def.TAB + Def.PUBLIC + "ObjectName " + Def.METH_T_BUILDNAME + "(" + Def.SNMP_INDEX + " index)\n");
        this.buildname_impl.append(Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.buildname_impl.append(Def.TAB2 + "Vector v = index.getComponents()" + Def.SEMICOLON);
        this.buildname_impl.append(Def.TAB2 + Def.SNMP_OID + " oid" + Def.SEMICOLON);
        this.buildname_impl.append(Def.TAB2 + "try " + Def.LBRACE);
    }
}

