/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.BeanIfGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableBeanIfGenerator
extends BeanIfGenerator
implements Serializable {
    protected MibNode node;
    protected StringBuffer table_impl = new StringBuffer();

    public static String buildTableBeanIfName(String pre, String name) {
        return pre + Def.TABLEPREFIX + name + Def.MBEANSUFFIX;
    }

    public TableBeanIfGenerator(ResourceManager mgr, String pkgName, String prefix, String dir, MibNode table, ASTMib aMib, Context ctxt) throws IOException {
        super(mgr, table, ctxt);
        this.node = table;
        this.varName = this.node.getSymbolName();
        this.symboleName = TableBeanIfGenerator.buildTableBeanIfName(prefix, this.varName);
        Trace.info(MessageHandler.getMessage("generate.info.if", this.varName));
        this.out = this.openFile(this.symboleName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.processTable();
        this.write(this.table_impl.toString());
        this.write("\n" + Def.RBRACE);
        this.closeIO();
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbeanif.comment.desc", Def.TABLEPREFIX + this.varName) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.INTERFACE + this.symboleName + Def.EXTEND + Def.SNMP_TABLE + Def.MBEANSUFFIX + Def.LBRACE + "\n");
    }

    private void processTable() throws IOException {
        String entryName = this.getTableEntryName();
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_ADD + "(" + entryName + " entry)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.SEMICOLON + "\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_REM + "(" + entryName + " x)" + Def.SEMICOLON + "\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + entryName + "[] " + Def.GET_ENTRIES + "()" + Def.SEMICOLON + "\n");
    }

    private String getTableEntryName() throws IOException {
        Hashtable children = this.node.getChildren();
        if (children.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", this.node.getRealSymbolName()));
            throw new IOException();
        }
        Enumeration a = children.elements();
        MibNode entryNode = (MibNode)a.nextElement();
        String varName = entryNode.getSymbolName();
        if (varName == null) {
            varName = this.getClassName(entryNode.getComputedOid());
        }
        String symboleName = this.prefix + varName;
        return symboleName;
    }
}

