/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.babudb.config.PluginConfig;
import org.xtreemfs.babudb.log.DiskLogger;
import org.xtreemfs.babudb.replication.control.FleaseHolder;
import org.xtreemfs.babudb.replication.policy.Policy;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.flease.FleaseConfig;
import org.xtreemfs.foundation.logging.Logging;

public class ReplicationConfig
extends PluginConfig {
    private static final String POLICY_PACKAGE = "org.xtreemfs.babudb.replication.policy.";
    protected final BabuDBConfig babuDBConfig;
    protected InetSocketAddress address;
    protected SSLOptions sslOptions;
    protected Set<InetSocketAddress> participants;
    protected int localTimeRenew;
    protected final FleaseConfig fleaseConfig;
    protected String policyName;
    protected final Policy replicationPolicy;
    public static final int FLEASE_LEASE_TIMEOUT_MS = 60000;
    public static final int FLEASE_DMAX_MS = 1000;
    public static final int FLEASE_MESSAGE_TO_MS = 500;
    public static final int FLEASE_RETRIES = 3;
    public static final int REQUEST_TIMEOUT = 1000;
    public static final int CONNECTION_TIMEOUT = 300000;
    public static final int DELAY_TO_WAIT_FOR_LEASE_MS = 1000;
    protected int syncN;
    protected int chunkSize;
    private static final int DEFAULT_MAX_CHUNK_SIZE = 0x500000;
    protected String backupDir;
    protected boolean redirect = false;
    public static final int PROXY_MAX_RETRIES = 15;
    public static final int PROXY_RETRY_DELAY = 10000;

    public ReplicationConfig(Properties prop, BabuDBConfig babuConf) throws IOException {
        super(prop);
        this.babuDBConfig = babuConf;
        this.read();
        this.fleaseConfig = this.createFleaseConfig();
        try {
            this.replicationPolicy = (Policy)Policy.class.getClassLoader().loadClass(POLICY_PACKAGE + this.policyName).newInstance();
        }
        catch (Exception e) {
            throw new IOException("ReplicationPolicy could not be instantiated, because: " + e.getMessage());
        }
    }

    private FleaseConfig createFleaseConfig() {
        return new FleaseConfig(60000, 1000, 500, this.address, FleaseHolder.getIdentity(this.address), 3);
    }

    public ReplicationConfig(String filename, BabuDBConfig babuConf) throws IOException {
        super(filename);
        this.babuDBConfig = babuConf;
        this.read();
        this.fleaseConfig = this.createFleaseConfig();
        try {
            this.replicationPolicy = (Policy)Policy.class.getClassLoader().loadClass(POLICY_PACKAGE + this.policyName).newInstance();
        }
        catch (Exception e) {
            throw new IOException("ReplicationPolicy could not be instantiated, because: " + e.getMessage());
        }
    }

    public ReplicationConfig(Set<InetSocketAddress> participants, int localTimeRenew, SSLOptions sslOptions, int syncN, String tempDir, BabuDBConfig babuConf, boolean redirect) throws IOException {
        this.babuDBConfig = babuConf;
        this.participants = new HashSet<InetSocketAddress>();
        this.localTimeRenew = localTimeRenew;
        this.redirect = redirect;
        this.sslOptions = sslOptions;
        this.syncN = syncN;
        this.chunkSize = 0x500000;
        this.backupDir = tempDir;
        this.fleaseConfig = this.createFleaseConfig();
        this.parseParticipants();
        this.checkArgs();
        try {
            this.replicationPolicy = (Policy)Policy.class.getClassLoader().loadClass(POLICY_PACKAGE + this.policyName).newInstance();
        }
        catch (Exception e) {
            throw new IOException("ReplicationPolicy could not be instantiated, because: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseParticipants() {
        HashSet<InetSocketAddress> finalParticipants = new HashSet<InetSocketAddress>();
        for (InetSocketAddress participant : this.participants) {
            if (this.address == null) {
                Socket s = new Socket();
                try {
                    s.setReuseAddress(true);
                    s.bind(participant);
                    this.address = participant;
                    continue;
                }
                catch (Exception e) {
                    finalParticipants.add(participant);
                    continue;
                }
                finally {
                    try {
                        s.close();
                    }
                    catch (IOException e) {}
                    continue;
                }
            }
            if (this.address.equals(participant)) continue;
            finalParticipants.add(participant);
        }
        this.participants = finalParticipants;
    }

    private void read() throws IOException {
        InetSocketAddress addrs;
        String tempDir = this.readRequiredString("babudb.repl.backupDir");
        this.backupDir = tempDir.endsWith("/") || tempDir.endsWith("\\") ? tempDir : (tempDir.contains("/") ? tempDir + "/" : (tempDir.contains("\\") ? tempDir + "\\" : tempDir + File.separator));
        this.localTimeRenew = this.readOptionalInt("babudb.localTimeRenew", 0);
        this.redirect = this.readOptionalBoolean("babudb.repl.redirectIsVisible", false);
        if (this.readOptionalBoolean("babudb.ssl.enabled", false)) {
            this.sslOptions = new SSLOptions((InputStream)new FileInputStream(this.readRequiredString("babudb.ssl.service_creds")), this.readRequiredString("babudb.ssl.service_creds.pw"), this.readRequiredString("babudb.ssl.service_creds.container"), (InputStream)new FileInputStream(this.readRequiredString("babudb.ssl.trusted_certs")), this.readRequiredString("babudb.ssl.trusted_certs.pw"), this.readRequiredString("babudb.ssl.trusted_certs.container"), this.readRequiredBoolean("babudb.ssl.authenticationWithoutEncryption"), false, null);
        }
        this.chunkSize = this.readOptionalInt("babudb.repl.chunkSize", 0x500000);
        this.syncN = this.readOptionalInt("babudb.repl.sync.n", 0);
        this.participants = new HashSet<InetSocketAddress>();
        this.address = this.readOptionalInetSocketAddr("babudb.repl.localhost", "babudb.repl.localport", null);
        int number = 0;
        while ((addrs = this.readOptionalInetSocketAddr("babudb.repl.participant." + number, "babudb.repl.participant." + number + ".port", null)) != null) {
            this.participants.add(addrs);
            ++number;
        }
        this.parseParticipants();
        this.policyName = this.readOptionalString("babudb.repl.policy", "MasterOnly");
        this.checkArgs();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.address;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public InetAddress getAddress() {
        return this.address.getAddress();
    }

    public SSLOptions getSSLOptions() {
        return this.sslOptions;
    }

    public Set<InetSocketAddress> getParticipants() {
        return this.participants;
    }

    public int getLocalTimeRenew() {
        return this.localTimeRenew;
    }

    public boolean redirectIsVisible() {
        return this.redirect;
    }

    public int getSyncN() {
        return this.syncN;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public String getTempDir() {
        return this.backupDir;
    }

    public FleaseConfig getFleaseConfig() {
        return this.fleaseConfig;
    }

    public BabuDBConfig getBabuDBConfig() {
        return this.babuDBConfig;
    }

    public Policy getReplicationPolicy() {
        return this.replicationPolicy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("############# Replication CONFIGURATION #############\n");
        buf.append("#             local address: " + this.address.toString() + "\n");
        if (this.sslOptions != null) {
            buf.append("#         ssl options: " + this.sslOptions.toString() + "\n");
        }
        int i = 0;
        for (InetSocketAddress participant : this.participants) {
            buf.append("#                participant " + i++ + ": " + participant.toString() + "\n");
        }
        buf.append("#        sync N: " + this.syncN + "\n");
        buf.append("#        policy: " + this.policyName + "\n");
        buf.append("#        local time renew: " + this.localTimeRenew + "\n");
        buf.append("#        temporary directory: " + this.backupDir + "\n");
        buf.append("#        chunk size: " + this.chunkSize + "\n");
        return buf.toString();
    }

    private void checkArgs() {
        File base = new File(this.babuDBConfig.getBaseDir());
        File log = new File(this.babuDBConfig.getDbLogDir());
        int numberOfReplicas = this.participants.size() + 1;
        if (this.babuDBConfig.getSyncMode() == DiskLogger.SyncMode.ASYNC) {
            throw new IllegalArgumentException("Replication will not work properly if BabuDB instances run in ASYNC mode. Please change the SyncMode of your BabuDB setup e.g., to FSYNCDATA.");
        }
        if (log.equals(base)) {
            throw new IllegalArgumentException("It is not permitted by the replication plugin to store log and base files within the same directory. Please move eitherlog (" + this.babuDBConfig.getDbLogDir() + ") or base (" + this.babuDBConfig.getBaseDir() + ").");
        }
        for (File tmp = new File(this.backupDir); tmp != null; tmp = tmp.getParentFile()) {
            if (!tmp.equals(base) && !tmp.equals(log)) continue;
            throw new IllegalArgumentException("The backup-directory (" + this.backupDir + ") must not be a sub-directory of the dbLog-directory (" + this.babuDBConfig.getDbLogDir() + ") or the base-directory (" + this.babuDBConfig.getBaseDir() + ").");
        }
        if (this.address == null) {
            throw new IllegalArgumentException("None of the given participants described the local node or the configured port is used by another application.");
        }
        if (this.policyName != null && this.policyName != "") {
            try {
                Policy.class.getClassLoader().loadClass(POLICY_PACKAGE + this.policyName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Policy with name '" + this.policyName + "' could not be found at classpath.");
            }
        } else {
            throw new IllegalArgumentException("It is not possible to use replication without replication policy. The policy has at least to be set to default (MasterOnly).");
        }
        if (this.syncN < 0 || this.syncN > numberOfReplicas) {
            throw new IllegalArgumentException("Wrong Sync-N. It has to be at least 0 and #of participants (" + numberOfReplicas + ") at the maximum.");
        }
        if (this.policyName == "WriteRestriction" && this.syncN != numberOfReplicas) {
            Logging.logMessage((int)6, null, (String)"If you set the policy to 'WriteRestriction', clients will be able to read stale data unless babudb.repl.sync.n equals the number of replicas (currently set to: %d).", (Object[])new Object[]{numberOfReplicas});
        }
        if (this.policyName == "MasterOnly" && this.syncN < (numberOfReplicas + 1) / 2) {
            throw new IllegalArgumentException("The requested N-sync-mode (N=" + this.syncN + ") may cause " + "inconsistent behavior, because at least a majority of replicas has to be updated." + " As there are " + numberOfReplicas + " replicas, the babudb.repl.sync.n parameter has to be set at least to: " + (numberOfReplicas + 1) / 2 + " Alternatively, use another policy then 'MasterOnly' which do not provide strong consistenty.");
        }
    }
}

