/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.pbrpc;

import com.google.protobuf.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.xtreemfs.babudb.pbrpc.Common;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class RemoteAccessServiceClient {
    private RPCNIOSocketClient client;
    private InetSocketAddress defaultServer;

    public RemoteAccessServiceClient(RPCNIOSocketClient client, InetSocketAddress defaultServer) {
        this.client = client;
        this.defaultServer = defaultServer;
    }

    public RPCResponse<GlobalTypes.Database> makePersistent(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.Database.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 1, (Message)input, data, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.Database> makePersistent(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, ReusableBuffer data) throws IOException {
        return this.makePersistent(server, authHeader, userCreds, null, data);
    }

    public RPCResponse<GlobalTypes.Database> getDatabaseByName(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.DatabaseName input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.Database.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 2, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.Database> getDatabaseByName(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String database_name) throws IOException {
        GlobalTypes.DatabaseName msg = GlobalTypes.DatabaseName.newBuilder().setDatabaseName(database_name).build();
        return this.getDatabaseByName(server, authHeader, userCreds, msg);
    }

    public RPCResponse<GlobalTypes.Database> getDatabaseById(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.DatabaseId input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.Database.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 3, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.Database> getDatabaseById(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, int database_id) throws IOException {
        GlobalTypes.DatabaseId msg = GlobalTypes.DatabaseId.newBuilder().setDatabaseId(database_id).build();
        return this.getDatabaseById(server, authHeader, userCreds, msg);
    }

    public RPCResponse<GlobalTypes.Databases> getDatabases(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.Databases.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 4, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.Databases> getDatabases(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.getDatabases(server, authHeader, userCreds, null);
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> lookup(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.Lookup input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 5, (Message)input, data, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> lookup(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String database_name, int index_id, ReusableBuffer data) throws IOException {
        GlobalTypes.Lookup msg = GlobalTypes.Lookup.newBuilder().setDatabaseName(database_name).setIndexId(index_id).build();
        return this.lookup(server, authHeader, userCreds, msg, data);
    }

    public RPCResponse<GlobalTypes.EntryMap> plookup(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.Lookup input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.EntryMap.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 6, (Message)input, data, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.EntryMap> plookup(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String database_name, int index_id, ReusableBuffer data) throws IOException {
        GlobalTypes.Lookup msg = GlobalTypes.Lookup.newBuilder().setDatabaseName(database_name).setIndexId(index_id).build();
        return this.plookup(server, authHeader, userCreds, msg, data);
    }

    public RPCResponse<GlobalTypes.EntryMap> plookupReverse(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.Lookup input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.EntryMap.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 7, (Message)input, data, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.EntryMap> plookupReverse(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String database_name, int index_id, ReusableBuffer data) throws IOException {
        GlobalTypes.Lookup msg = GlobalTypes.Lookup.newBuilder().setDatabaseName(database_name).setIndexId(index_id).build();
        return this.plookupReverse(server, authHeader, userCreds, msg, data);
    }

    public RPCResponse<GlobalTypes.EntryMap> rlookup(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.RangeLookup input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.EntryMap.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 8, (Message)input, data, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.EntryMap> rlookup(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String database_name, int index_id, int from_length, ReusableBuffer data) throws IOException {
        GlobalTypes.RangeLookup msg = GlobalTypes.RangeLookup.newBuilder().setDatabaseName(database_name).setIndexId(index_id).setFromLength(from_length).build();
        return this.rlookup(server, authHeader, userCreds, msg, data);
    }

    public RPCResponse<GlobalTypes.EntryMap> rlookupReverse(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.RangeLookup input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.EntryMap.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 9, (Message)input, data, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.EntryMap> rlookupReverse(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String database_name, int index_id, int from_length, ReusableBuffer data) throws IOException {
        GlobalTypes.RangeLookup msg = GlobalTypes.RangeLookup.newBuilder().setDatabaseName(database_name).setIndexId(index_id).setFromLength(from_length).build();
        return this.rlookupReverse(server, authHeader, userCreds, msg, data);
    }

    public boolean clientIsAlive() {
        return this.client.isAlive();
    }
}

