/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.pbrpc;

import com.google.protobuf.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.xtreemfs.babudb.pbrpc.Common;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class ReplicationServiceClient {
    private RPCNIOSocketClient client;
    private InetSocketAddress defaultServer;

    public ReplicationServiceClient(RPCNIOSocketClient client, InetSocketAddress defaultServer) {
        this.client = client;
        this.defaultServer = defaultServer;
    }

    public RPCResponse<GlobalTypes.LSN> state(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.LSN.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 1, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.LSN> state(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.state(server, authHeader, userCreds, null);
    }

    public RPCResponse<GlobalTypes.DBFileMetaDatas> load(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.LSN input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.DBFileMetaDatas.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 2, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.DBFileMetaDatas> load(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, int view_id, long sequence_no) throws IOException {
        GlobalTypes.LSN msg = GlobalTypes.LSN.newBuilder().setViewId(view_id).setSequenceNo(sequence_no).build();
        return this.load(server, authHeader, userCreds, msg);
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> chunk(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.Chunk input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 3, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> chunk(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String file_name, long start, long end) throws IOException {
        GlobalTypes.Chunk msg = GlobalTypes.Chunk.newBuilder().setFileName(file_name).setStart(start).setEnd(end).build();
        return this.chunk(server, authHeader, userCreds, msg);
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> flease(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.FLease input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 4, (Message)input, data, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> flease(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String host, int port, ReusableBuffer data) throws IOException {
        GlobalTypes.FLease msg = GlobalTypes.FLease.newBuilder().setHost(host).setPort(port).build();
        return this.flease(server, authHeader, userCreds, msg, data);
    }

    public RPCResponse<GlobalTypes.Timestamp> localTime(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.Timestamp.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 5, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.Timestamp> localTime(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.localTime(server, authHeader, userCreds, null);
    }

    public RPCResponse<GlobalTypes.LogEntries> replica(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.LSNRange input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.LogEntries.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 6, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.LogEntries> replica(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.LSN start, GlobalTypes.LSN end) throws IOException {
        GlobalTypes.LSNRange msg = GlobalTypes.LSNRange.newBuilder().setStart(start).setEnd(end).build();
        return this.replica(server, authHeader, userCreds, msg);
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> heartbeat(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.HeartbeatMessage input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 7, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> heartbeat(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, int port, GlobalTypes.LSN lsn) throws IOException {
        GlobalTypes.HeartbeatMessage msg = GlobalTypes.HeartbeatMessage.newBuilder().setPort(port).setLsn(lsn).build();
        return this.heartbeat(server, authHeader, userCreds, msg);
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> replicate(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.LSN input, ReusableBuffer data) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 8, (Message)input, data, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> replicate(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, int view_id, long sequence_no, ReusableBuffer data) throws IOException {
        GlobalTypes.LSN msg = GlobalTypes.LSN.newBuilder().setViewId(view_id).setSequenceNo(sequence_no).build();
        return this.replicate(server, authHeader, userCreds, msg, data);
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> synchronize(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.HeartbeatMessage input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 9, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.ErrorCodeResponse> synchronize(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, int port, GlobalTypes.LSN lsn) throws IOException {
        GlobalTypes.HeartbeatMessage msg = GlobalTypes.HeartbeatMessage.newBuilder().setPort(port).setLsn(lsn).build();
        return this.synchronize(server, authHeader, userCreds, msg);
    }

    public RPCResponse<GlobalTypes.LSN> volatileState(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse response = new RPCResponse((Message)GlobalTypes.LSN.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 20001, 10, (Message)input, null, response, false);
        return response;
    }

    public RPCResponse<GlobalTypes.LSN> volatileState(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.volatileState(server, authHeader, userCreds, null);
    }

    public boolean clientIsAlive() {
        return this.client.isAlive();
    }
}

