/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication;

import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.CheckpointerInternal;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.proxy.DatabaseManagerProxy;
import org.xtreemfs.babudb.replication.proxy.DatabaseProxy;
import org.xtreemfs.babudb.replication.proxy.TransactionManagerProxy;
import org.xtreemfs.foundation.logging.Logging;

public class BabuDBInterface {
    private final BabuDBInternal dbs;
    private final TransactionManagerInternal localTxnMan;
    private DatabaseManagerProxy dbMan;

    public BabuDBInterface(BabuDBInternal babuDB) {
        this.localTxnMan = babuDB.getTransactionManager();
        this.dbs = babuDB;
    }

    public void init(DatabaseManagerProxy dbMan) {
        this.dbMan = dbMan;
    }

    public void appendToLocalPersistenceManager(LogEntry entry, DatabaseRequestListener<Object> listener) throws BabuDBException {
        Logging.logMessage((int)7, (Object)this, (String)"Appending entry to logger: %s", (Object[])new Object[]{new String(entry.getPayload().array())});
        BabuDBRequestResultImpl future = new BabuDBRequestResultImpl(this.dbs.getResponseManager());
        this.localTxnMan.makePersistent(entry.getPayload(), future);
        future.registerListener(listener);
    }

    public LSN getState() {
        return this.localTxnMan.getLatestOnDiskLSN();
    }

    public Object getCheckpointerLock() {
        return this.getChckPtr();
    }

    public Object getDBModificationLock() {
        return this.dbs.getDatabaseManager().getDBModificationLock();
    }

    public void waitForCheckpoint() throws InterruptedException {
        this.getChckPtr().waitForCheckpoint();
    }

    public void stopBabuDB() {
        this.dbs.stop();
    }

    public LSN startBabuDB() throws BabuDBException {
        return this.dbs.restart();
    }

    public LSN checkpoint() throws BabuDBException {
        return this.getChckPtr().checkpoint(true);
    }

    public Map<String, DatabaseProxy> getDatabases() {
        return this.dbMan.getDatabasesInternalNonblocking();
    }

    public DatabaseProxy getDatabase(String dbName) throws BabuDBException {
        return this.dbMan.getDatabaseNonblocking(dbName);
    }

    public DatabaseProxy getDatabase(int dbId) throws BabuDBException {
        return this.dbMan.getDatabaseNonblocking(dbId);
    }

    private CheckpointerInternal getChckPtr() {
        return this.dbs.getCheckpointer();
    }

    public Collection<LSMDatabase.DBFileMetaData> getAllSnapshotFiles() {
        Vector<LSMDatabase.DBFileMetaData> result = new Vector<LSMDatabase.DBFileMetaData>();
        for (DatabaseInternal db : this.dbMan.getLocalDatabaseList()) {
            result.addAll(db.getLSMDB().getLastestSnapshotFiles());
        }
        return result;
    }

    public TransactionManagerProxy getTransactionManager() {
        return (TransactionManagerProxy)this.dbs.getTransactionManager();
    }

    public BabuDBRequestResultImpl<Object> createRequestFuture() {
        return new BabuDBRequestResultImpl(this.dbs.getResponseManager());
    }
}

