/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication;

import java.io.IOException;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.plugin.PluginMain;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.config.DependencyConfig;
import org.xtreemfs.babudb.config.ReplicationConfig;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.ReplicationManager;
import org.xtreemfs.babudb.replication.proxy.BabuDBProxy;
import org.xtreemfs.babudb.replication.transmission.FileIO;
import org.xtreemfs.foundation.logging.Logging;

public class Main
extends PluginMain {
    public BabuDBInternal start(BabuDBInternal babuDB, String configPath) throws BabuDBException {
        ReplicationManager replMan;
        ReplicationConfig configuration;
        try {
            configuration = new ReplicationConfig(configPath, babuDB.getConfig());
        }
        catch (IOException ioe) {
            throw new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, "Replication configuration is broken.", ioe.getCause());
        }
        try {
            new FileIO(configuration).replayBackupFiles();
        }
        catch (IOException io) {
            Logging.logMessage((int)3, (Object)((Object)this), (String)"Could not retrieve the slave backup files, because: ", (Object[])new Object[]{io.getMessage()});
        }
        BabuDBInterface dbInterface = new BabuDBInterface(babuDB);
        try {
            replMan = new ReplicationManager(configuration, dbInterface);
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                Logging.logError((int)3, (Object)((Object)this), (Throwable)e);
            }
            throw new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, e.getMessage(), e.getCause());
        }
        return new BabuDBProxy(babuDB, replMan, configuration.getReplicationPolicy(), dbInterface);
    }

    public String compatibleBabuDBVersion() {
        return PluginMain.buildCompatibleVersionString((int)0, (int)5, (int)4, (int)0, (int)5, (int)9);
    }

    public String[] getDependencies(String configPath) throws IOException {
        return new DependencyConfig(configPath).getDependencyPaths();
    }
}

