/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.babudb.config.ReplicationConfig;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.TopLayer;
import org.xtreemfs.babudb.replication.control.ControlLayer;
import org.xtreemfs.babudb.replication.proxy.DatabaseManagerProxy;
import org.xtreemfs.babudb.replication.proxy.ProxyAccessClient;
import org.xtreemfs.babudb.replication.service.ServiceLayer;
import org.xtreemfs.babudb.replication.service.accounting.ReplicateResponse;
import org.xtreemfs.babudb.replication.transmission.TransmissionLayer;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;

public class ReplicationManager
implements LifeCycleListener {
    public static final String VERSION = "1.1";
    private static final String RUNTIME_STATE_MASTER = "replication.control.master";
    private static final String RUNTIME_STATE_ADDRESS = "replication.control.address";
    private final TopLayer controlLayer;
    private final ServiceLayer serviceLayer;
    private final TransmissionLayer transmissionLayer;
    private final boolean redirectIsVisible;

    public ReplicationManager(ReplicationConfig conf, BabuDBInterface dbs) throws Exception {
        this.redirectIsVisible = conf.redirectIsVisible();
        TimeSync.initializeLocal((int)conf.getLocalTimeRenew()).setLifeCycleListener((LifeCycleListener)this);
        this.transmissionLayer = new TransmissionLayer(conf);
        this.serviceLayer = new ServiceLayer(conf, dbs, this.transmissionLayer);
        ControlLayer cl = new ControlLayer(this.serviceLayer, conf);
        this.controlLayer = cl;
        this.serviceLayer.init(this.controlLayer);
        this.transmissionLayer.setLifeCycleListener(this);
        this.serviceLayer.setLifeCycleListener(this);
        this.controlLayer.setLifeCycleListener(this);
    }

    public void init() throws InterruptedException {
        this.transmissionLayer.start();
        this.serviceLayer.start(this.controlLayer);
        this.controlLayer.start();
        this.controlLayer.waitForInitialFailover();
    }

    public InetSocketAddress getMaster(int timeout) throws InterruptedException {
        return this.controlLayer.getLeaseHolder(timeout);
    }

    public Object getRuntimeState(String property) {
        if (RUNTIME_STATE_MASTER.equals(property)) {
            try {
                return this.controlLayer.getLeaseHolder(-1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (RUNTIME_STATE_ADDRESS.equals(property)) {
            return this.controlLayer.getThisAddress();
        }
        return null;
    }

    public Map<String, Object> getRuntimeState() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(RUNTIME_STATE_MASTER, this.controlLayer.getLeaseHolder(-1));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        map.put(RUNTIME_STATE_ADDRESS, this.controlLayer.getThisAddress());
        return map;
    }

    public final boolean redirectIsVisible() {
        return this.redirectIsVisible;
    }

    public boolean isItMe(InetSocketAddress address) {
        return this.controlLayer.getThisAddress().equals(address);
    }

    public ReplicateResponse replicate(LogEntry le) {
        Logging.logMessage((int)7, (Object)this, (String)"Performing requests: replicate...", (Object[])new Object[0]);
        return this.serviceLayer.replicate(le);
    }

    public void subscribeListener(ReplicateResponse response) {
        this.serviceLayer.subscribeListener(response);
    }

    public void shutdown() throws Exception {
        this.controlLayer.shutdown();
        this.serviceLayer.shutdown();
        this.transmissionLayer.shutdown();
    }

    public ProxyAccessClient getProxyClient(DatabaseManagerProxy dbManProxy) {
        return this.transmissionLayer.getProxyClient(dbManProxy);
    }

    public void crashPerformed(Throwable exc) {
        Logging.logMessage((int)2, (Object)this, (String)"An essential replication component has crashed, because %s.", (Object[])new Object[]{exc.getMessage()});
        Logging.logError((int)2, (Object)this, (Throwable)exc);
        this.controlLayer.asyncShutdown();
        this.serviceLayer.asyncShutdown();
        this.transmissionLayer.asyncShutdown();
        throw new RuntimeException(exc);
    }

    public void shutdownPerformed() {
    }

    public void startupPerformed() {
    }
}

