/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.control;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.babudb.config.ReplicationConfig;
import org.xtreemfs.babudb.log.SyncListener;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.LockableService;
import org.xtreemfs.babudb.replication.TopLayer;
import org.xtreemfs.babudb.replication.control.FleaseHolder;
import org.xtreemfs.babudb.replication.control.FleaseMessageSender;
import org.xtreemfs.babudb.replication.control.TimeDriftDetector;
import org.xtreemfs.babudb.replication.service.ServiceToControlInterface;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.buffer.ASCIIString;
import org.xtreemfs.foundation.flease.FleaseMessageSenderInterface;
import org.xtreemfs.foundation.flease.FleaseStage;
import org.xtreemfs.foundation.flease.FleaseStatusListener;
import org.xtreemfs.foundation.flease.FleaseViewChangeListenerInterface;
import org.xtreemfs.foundation.flease.comm.FleaseMessage;
import org.xtreemfs.foundation.logging.Logging;

public class ControlLayer
extends TopLayer {
    private static final ASCIIString REPLICATION_CELL = new ASCIIString("replication");
    private final FleaseStage fleaseStage;
    private final List<InetSocketAddress> fleaseParticipants;
    private final TimeDriftDetector timeDriftDetector;
    private final ServiceToControlInterface serviceInterface;
    private final InetSocketAddress thisAddress;
    private final FleaseHolder leaseHolder;
    private final FailoverTaskRunner failoverTaskRunner;
    private LockableService replicationInterface;
    private final AtomicBoolean initialFailoverObserved = new AtomicBoolean(false);
    private volatile boolean failoverInProgress = true;

    public ControlLayer(ServiceToControlInterface serviceLayer, ReplicationConfig config) throws IOException {
        this.timeDriftDetector = new TimeDriftDetector(this, serviceLayer.getParticipantOverview().getConditionClients(), config.getFleaseConfig().getDMax());
        this.thisAddress = config.getInetSocketAddress();
        this.failoverTaskRunner = new FailoverTaskRunner();
        this.serviceInterface = serviceLayer;
        this.leaseHolder = new FleaseHolder(REPLICATION_CELL, this);
        File bDir = new File(config.getBabuDBConfig().getBaseDir());
        if (!bDir.exists()) {
            bDir.mkdirs();
        }
        this.fleaseParticipants = new LinkedList<InetSocketAddress>(config.getParticipants());
        this.fleaseStage = new FleaseStage(config.getFleaseConfig(), config.getBabuDBConfig().getBaseDir(), (FleaseMessageSenderInterface)new FleaseMessageSender(serviceLayer.getParticipantOverview(), config.getInetSocketAddress()), false, new FleaseViewChangeListenerInterface(){

            public void viewIdChangeEvent(ASCIIString cellId, int viewId) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }, (FleaseStatusListener)this.leaseHolder, null);
    }

    @Override
    public void lockReplication() throws InterruptedException {
        this.replicationInterface.lock();
    }

    @Override
    public void unlockReplication() {
        this.replicationInterface.unlock();
    }

    @Override
    public InetSocketAddress getLeaseHolder(int timeout) throws InterruptedException {
        return this.leaseHolder.getLeaseHolderAddress(timeout);
    }

    @Override
    public InetSocketAddress getThisAddress() {
        return this.thisAddress;
    }

    @Override
    public void start() {
        this.timeDriftDetector.start();
        this.failoverTaskRunner.start();
        this.fleaseStage.start();
        try {
            this.fleaseStage.waitForStartup();
        }
        catch (Throwable e) {
            this.listener.crashPerformed(e);
        }
        this.joinFlease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForInitialFailover() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.initialFailoverObserved;
        synchronized (atomicBoolean) {
            if (!this.initialFailoverObserved.get()) {
                this.initialFailoverObserved.wait();
                if (!this.initialFailoverObserved.get()) {
                    throw new InterruptedException("Waiting for the initial failover was interrupted.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.exitFlease();
        this.timeDriftDetector.shutdown();
        this.fleaseStage.shutdown();
        try {
            this.fleaseStage.waitForShutdown();
        }
        catch (Throwable e) {
            this.listener.crashPerformed(e);
        }
        this.failoverTaskRunner.shutdown();
        AtomicBoolean atomicBoolean = this.initialFailoverObserved;
        synchronized (atomicBoolean) {
            this.initialFailoverObserved.notify();
        }
    }

    @Override
    public void _setLifeCycleListener(LifeCycleListener listener) {
        this.failoverTaskRunner.setLifeCycleListener(listener);
        this.timeDriftDetector.setLifeCycleListener(listener);
        this.fleaseStage.setLifeCycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncShutdown() {
        this.exitFlease();
        this.failoverTaskRunner.shutdown();
        this.timeDriftDetector.shutdown();
        this.fleaseStage.shutdown();
        AtomicBoolean atomicBoolean = this.initialFailoverObserved;
        synchronized (atomicBoolean) {
            this.initialFailoverObserved.notify();
        }
    }

    @Override
    public void driftDetected(String driftedParticipants) {
        Logging.logMessage((int)4, (Logging.Category)Logging.Category.replication, (Object)this, (String)"Clock skew between replicas is too high. This can result in inconsistent replicas. Please make sure that the local clocks are regularly synchronized e.g., by running a NTP daemon on each machine. Details: %s", (Object[])new Object[]{driftedParticipants});
    }

    @Override
    public void receive(FleaseMessage message) {
        this.fleaseStage.receiveMessage(message);
    }

    @Override
    public void registerReplicationControl(LockableService service) {
        this.replicationInterface = service;
    }

    @Override
    public void updateLeaseHolder(InetSocketAddress newLeaseHolder) {
        this.failoverInProgress = true;
        this.failoverTaskRunner.queueFailoverRequest(newLeaseHolder);
    }

    @Override
    public boolean isFailoverInProgress() {
        return this.failoverInProgress;
    }

    private void joinFlease() {
        this.fleaseStage.openCell(REPLICATION_CELL, this.fleaseParticipants, false);
    }

    private void exitFlease() {
        this.fleaseStage.closeCell(REPLICATION_CELL, true);
    }

    private final class FailoverTaskRunner
    extends LifeCycleThread {
        private final AtomicReference<InetSocketAddress> failoverRequest;
        private boolean quit;
        private InetSocketAddress currentLeaseHolder;

        private FailoverTaskRunner() {
            super("FailOverT@" + ControlLayer.this.thisAddress.getPort());
            this.failoverRequest = new AtomicReference<Object>(null);
            this.quit = true;
            this.currentLeaseHolder = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void queueFailoverRequest(InetSocketAddress address) {
            AtomicReference<InetSocketAddress> atomicReference = this.failoverRequest;
            synchronized (atomicReference) {
                if (this.failoverRequest.compareAndSet(null, address)) {
                    Logging.logMessage((int)6, (Object)((Object)this), (String)"Server %s is initiating failover with new master candidate %s.", (Object[])new Object[]{ControlLayer.this.thisAddress.toString(), address.toString()});
                    this.failoverRequest.notify();
                }
            }
        }

        public synchronized void start() {
            super.start();
        }

        public void shutdown() {
            this.quit = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block17: {
                this.quit = false;
                this.notifyStarted();
                InetSocketAddress newLeaseHolder = null;
                try {
                    while (!this.quit) {
                        Serializable serializable = this.failoverRequest;
                        synchronized (serializable) {
                            if (this.failoverRequest.get() == null) {
                                this.failoverRequest.wait();
                            }
                            newLeaseHolder = this.failoverRequest.getAndSet(null);
                        }
                        try {
                            if (!newLeaseHolder.equals(this.currentLeaseHolder)) {
                                if (ControlLayer.this.thisAddress.equals(this.currentLeaseHolder)) {
                                    this.becomeSlave(newLeaseHolder);
                                } else if (ControlLayer.this.thisAddress.equals(newLeaseHolder)) {
                                    this.becomeMaster();
                                }
                            }
                            if (this.currentLeaseHolder == null) {
                                serializable = ControlLayer.this.initialFailoverObserved;
                                synchronized (serializable) {
                                    ControlLayer.this.initialFailoverObserved.set(true);
                                    ControlLayer.this.initialFailoverObserved.notify();
                                }
                            }
                            this.currentLeaseHolder = newLeaseHolder;
                            ControlLayer.this.failoverInProgress = false;
                        }
                        catch (Exception e) {
                            if (this.quit) continue;
                            Logging.logMessage((int)4, (Object)((Object)this), (String)"Processing a failover did not succeed, because: ", (Object[])new Object[]{e.getMessage()});
                            Logging.logError((int)4, (Object)((Object)this), (Throwable)e);
                            ControlLayer.this.leaseHolder.reset();
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (this.quit) break block17;
                    this.notifyCrashed(e);
                }
            }
            this.notifyStopped();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void becomeMaster() throws Exception {
            Logging.logMessage((int)7, (Object)((Object)this), (String)"Becoming the replication master.", (Object[])new Object[0]);
            final AtomicBoolean finished = new AtomicBoolean(false);
            final AtomicReference<Object> exception = new AtomicReference<Object>(null);
            ControlLayer.this.serviceInterface.synchronize(new SyncListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void synced(LSN lsn) {
                    Logging.logMessage((int)7, (Object)this, (String)"Master failover succeeded @LSN(%s).", (Object[])new Object[]{lsn.toString()});
                    ControlLayer.this.serviceInterface.reset();
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        if (finished.compareAndSet(false, true)) {
                            finished.notify();
                        } else assert (false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(Exception ex) {
                    Logging.logMessage((int)4, (Object)this, (String)"Master failover did not succeed! Reseting the local lease and waiting for a new impulse from FLease. Reason: %s", (Object[])new Object[]{ex.getMessage()});
                    Logging.logError((int)7, (Object)this, (Throwable)ex);
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        if (finished.compareAndSet(false, true)) {
                            exception.set(ex);
                            finished.notify();
                        } else assert (false);
                    }
                }
            }, ControlLayer.this.thisAddress.getPort());
            AtomicBoolean atomicBoolean = finished;
            synchronized (atomicBoolean) {
                while (!finished.get()) {
                    finished.wait();
                }
                if (exception.get() != null) {
                    throw (Exception)exception.get();
                }
            }
            Logging.logMessage((int)6, (Object)((Object)this), (String)"Failover succeeded! %s has become the new master.", (Object[])new Object[]{ControlLayer.this.thisAddress.toString()});
        }

        private void becomeSlave(InetSocketAddress masterAddress) throws InterruptedException {
            ControlLayer.this.serviceInterface.reset();
            Logging.logMessage((int)6, (Object)((Object)this), (String)"Becoming a slave for %s.", (Object[])new Object[]{masterAddress.toString()});
        }
    }
}

