/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.control;

import java.net.InetSocketAddress;
import org.xtreemfs.babudb.replication.control.FleaseEventListener;
import org.xtreemfs.foundation.buffer.ASCIIString;
import org.xtreemfs.foundation.flease.Flease;
import org.xtreemfs.foundation.flease.FleaseStatusListener;
import org.xtreemfs.foundation.flease.proposer.FleaseException;
import org.xtreemfs.foundation.logging.Logging;

public class FleaseHolder
implements FleaseStatusListener {
    private final FleaseEventListener listener;
    private Flease lease = null;

    FleaseHolder(ASCIIString cellId, FleaseEventListener listener) {
        this.listener = listener;
    }

    synchronized InetSocketAddress getLeaseHolderAddress(int timeout) throws InterruptedException {
        if (!(this.lease != null && this.lease.isValid() || timeout < 0)) {
            this.wait(timeout);
        }
        return this.lease != null && this.lease.isValid() ? FleaseHolder.getAddress(this.lease.getLeaseHolder()) : null;
    }

    synchronized void reset() {
        this.lease = Flease.EMPTY_LEASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaseFailed(ASCIIString cellId, FleaseException error) {
        Logging.logMessage((int)4, (Object)this, (String)"Flease was not able to become the current lease holder in %s because: %s ", (Object[])new Object[]{cellId.toString(), error.getMessage()});
        FleaseHolder fleaseHolder = this;
        synchronized (fleaseHolder) {
            this.lease = Flease.EMPTY_LEASE;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusChanged(ASCIIString cellId, Flease newLease) {
        Logging.logMessage((int)7, (Object)this, (String)"Received new Lease (%s).", (Object[])new Object[]{newLease.toString()});
        ASCIIString newLeaseHolder = newLease.getLeaseHolder();
        if (newLease.isValid()) {
            Flease oldLease = null;
            FleaseHolder fleaseHolder = this;
            synchronized (fleaseHolder) {
                oldLease = this.lease;
                this.lease = newLease;
                this.notifyAll();
            }
            if (oldLease == null || !newLeaseHolder.equals((Object)oldLease.getLeaseHolder())) {
                this.listener.updateLeaseHolder(FleaseHolder.getAddress(newLeaseHolder));
            }
        }
    }

    public static final String getIdentity(InetSocketAddress address) {
        String host = address.getAddress().getHostAddress();
        assert (host != null) : "Address was not resolved before!";
        return host + ":" + address.getPort();
    }

    public static final InetSocketAddress getAddress(ASCIIString identity) {
        String[] adr = identity.toString().split(":");
        assert (adr.length == 2);
        return new InetSocketAddress(adr[0], Integer.parseInt(adr[1]));
    }
}

