/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.control;

import java.net.InetSocketAddress;
import org.xtreemfs.babudb.replication.service.accounting.ParticipantsOverview;
import org.xtreemfs.babudb.replication.service.accounting.ParticipantsStates;
import org.xtreemfs.babudb.replication.service.clients.ClientResponseFuture;
import org.xtreemfs.babudb.replication.service.clients.ConditionClient;
import org.xtreemfs.foundation.flease.FleaseMessageSenderInterface;
import org.xtreemfs.foundation.flease.comm.FleaseMessage;
import org.xtreemfs.foundation.logging.Logging;

class FleaseMessageSender
implements FleaseMessageSenderInterface {
    private final ParticipantsOverview states;
    private final InetSocketAddress sender;

    FleaseMessageSender(ParticipantsOverview states, InetSocketAddress senderAddress) {
        this.states = states;
        this.sender = senderAddress;
    }

    public void sendMessage(final FleaseMessage message, final InetSocketAddress recipient) {
        assert (recipient != null && message != null);
        try {
            ConditionClient c = this.states.getByAddress(recipient);
            assert (c != null) : "could not retrieve client for " + recipient.toString();
            message.setSender(this.sender);
            Logging.logMessage((int)7, (Object)this, (String)"Sending '%s' from '%s' to '%s' ... ", (Object[])new Object[]{message.toString(), this.sender.toString(), recipient.toString()});
            c.flease(message).registerListener(new ClientResponseFuture.ClientResponseAvailableListener<Object>(){

                @Override
                public void requestFailed(Exception e) {
                    Logging.logMessage((int)6, (Object)this, (String)"%s could not be sent to '%s', because %s.", (Object[])new Object[]{message.toString(), recipient.toString(), e.getMessage()});
                    if (e.getMessage() == null) {
                        Logging.logError((int)6, (Object)this, (Throwable)e);
                    }
                }

                @Override
                public void responseAvailable(Object r) {
                }
            });
        }
        catch (ParticipantsStates.UnknownParticipantException e) {
            Logging.logMessage((int)1, (Object)this, (String)"FLease could not send a message (%s) to %s, because %s.", (Object[])new Object[]{message.toString(), recipient.toString(), e.getMessage()});
        }
    }
}

