/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.control;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.xtreemfs.babudb.replication.service.clients.ConditionClient;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;

class TimeDriftDetector {
    private static final int MAX_RTT = 1000;
    private final TimeDriftListener listener;
    private final List<ConditionClient> participants;
    private final Timer timer;
    private final int maxDrift;
    private final long DELAY_BETWEEN_CHECKS;
    private volatile LifeCycleListener lifeCyclelistener = null;

    TimeDriftDetector(TimeDriftListener listener, List<ConditionClient> clients, int dMax) {
        this.listener = listener;
        this.participants = clients;
        this.timer = new Timer("TimeDriftDetector", true);
        this.DELAY_BETWEEN_CHECKS = Math.max(60000, this.participants.size() * 1000);
        this.maxDrift = dMax;
    }

    void setLifeCycleListener(LifeCycleListener listener) {
        assert (listener != null);
        this.lifeCyclelistener = listener;
    }

    void start() {
        this.timer.schedule((TimerTask)new CheckTask(), 0L, this.DELAY_BETWEEN_CHECKS);
        if (this.lifeCyclelistener != null) {
            this.lifeCyclelistener.startupPerformed();
        }
    }

    void shutdown() {
        this.timer.cancel();
        if (this.lifeCyclelistener != null) {
            this.lifeCyclelistener.shutdownPerformed();
        }
    }

    private final class CheckTask
    extends TimerTask {
        private CheckTask() {
        }

        @Override
        public void run() {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss:SSS yyyy zzz");
            String humanReadableDriftedParticipants = "";
            int numDriftedClients = 0;
            for (ConditionClient client : TimeDriftDetector.this.participants) {
                try {
                    long start = TimeSync.getGlobalTime();
                    long cTime = client.time().get();
                    long end = TimeSync.getGlobalTime();
                    int rtt = (int)(end - start);
                    if (rtt > 1000) {
                        Logging.logMessage((int)6, (Logging.Category)Logging.Category.misc, (Object)this, (String)"Ignored time drift detection message since the probed replica (%s) took too long to respond (%d ms)", (Object[])new Object[]{client.getDefaultServerAddress().toString(), rtt});
                        continue;
                    }
                    long estimatedRemoteTime = cTime + (long)(rtt / 2);
                    long drift = Math.abs(end - estimatedRemoteTime);
                    if (drift <= (long)TimeDriftDetector.this.maxDrift) continue;
                    calendar.setTimeInMillis(cTime);
                    String formattedCTime = format.format(calendar.getTime());
                    calendar.setTimeInMillis(start);
                    String formattedStartTime = format.format(calendar.getTime());
                    calendar.setTimeInMillis(end);
                    String formattedEndTime = format.format(calendar.getTime());
                    humanReadableDriftedParticipants = humanReadableDriftedParticipants + "Saw a drift of at least " + drift + " ms as participant '" + client.getDefaultServerAddress().toString() + "' reported system time '" + formattedCTime + "' between local time '" + formattedStartTime + "' and '" + formattedEndTime + "'. ";
                    if (++numDriftedClients <= 1 && numDriftedClients != TimeDriftDetector.this.participants.size()) continue;
                    TimeDriftDetector.this.listener.driftDetected(humanReadableDriftedParticipants);
                    return;
                }
                catch (Throwable e) {
                    Logging.logMessage((int)7, (Object)TimeDriftDetector.this.timer, (String)"Local time of '%s' could not be fetched.", (Object[])new Object[]{client.toString()});
                }
            }
        }
    }

    static interface TimeDriftListener {
        public void driftDetected(String var1);
    }
}

