/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.xtreemfs.babudb.api.StaticInitialization;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.CheckpointerInternal;
import org.xtreemfs.babudb.api.dev.DatabaseManagerInternal;
import org.xtreemfs.babudb.api.dev.ResponseManagerInternal;
import org.xtreemfs.babudb.api.dev.SnapshotManagerInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.babudb.lsmdb.DBConfig;
import org.xtreemfs.babudb.lsmdb.LSMDBWorker;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.ReplicationManager;
import org.xtreemfs.babudb.replication.policy.Policy;
import org.xtreemfs.babudb.replication.proxy.DatabaseManagerProxy;
import org.xtreemfs.babudb.replication.proxy.ListenerWrapper;
import org.xtreemfs.babudb.replication.proxy.ProxyAccessClient;
import org.xtreemfs.babudb.replication.proxy.TransactionManagerProxy;
import org.xtreemfs.foundation.LifeCycleThread;

public class BabuDBProxy
implements BabuDBInternal {
    private final BabuDBInternal localBabuDB;
    private final TransactionManagerProxy txnManProxy;
    private final DatabaseManagerInternal dbManProxy;
    private final ReplicationManager replMan;
    private final ProxyAccessClient client;
    private final RequestRerunner requestRerunner = new RequestRerunner();

    public BabuDBProxy(BabuDBInternal localDB, ReplicationManager replMan, Policy replicationPolicy, BabuDBInterface dbInt) {
        assert (localDB != null);
        this.localBabuDB = localDB;
        this.replMan = replMan;
        this.txnManProxy = new TransactionManagerProxy(replMan, localDB.getTransactionManager(), replicationPolicy, this);
        DatabaseManagerProxy dbMan = new DatabaseManagerProxy(localDB.getDatabaseManager(), replicationPolicy, replMan, this, this.txnManProxy, localDB.getResponseManager());
        dbInt.init(dbMan);
        this.client = replMan.getProxyClient(dbMan);
        this.dbManProxy = dbMan;
    }

    public CheckpointerInternal getCheckpointer() {
        return this.localBabuDB.getCheckpointer();
    }

    public DatabaseManagerInternal getDatabaseManager() {
        return this.dbManProxy;
    }

    public SnapshotManagerInternal getSnapshotManager() {
        return this.localBabuDB.getSnapshotManager();
    }

    public void shutdown() throws BabuDBException {
        this.shutdown(true);
    }

    public void shutdown(boolean graceful) throws BabuDBException {
        try {
            this.requestRerunner.shutdown();
            this.replMan.shutdown();
        }
        catch (Exception e) {
            throw new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, e.getMessage());
        }
        finally {
            this.localBabuDB.shutdown(graceful);
        }
    }

    public TransactionManagerInternal getTransactionManager() {
        return this.txnManProxy;
    }

    public void init(StaticInitialization staticInit) throws BabuDBException {
        try {
            this.localBabuDB.init(staticInit);
            this.localBabuDB.replaceTransactionManager((TransactionManagerInternal)this.txnManProxy);
            this.replMan.init();
        }
        catch (InterruptedException e) {
            throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, e.getMessage());
        }
    }

    public void addPluginThread(LifeCycleThread plugin) {
        this.localBabuDB.addPluginThread(plugin);
    }

    public DBConfig getDBConfigFile() {
        throw new UnsupportedOperationException("Manually influencing the DBConfig is forbidden by the replication plugin.");
    }

    public BabuDBConfig getConfig() {
        return this.localBabuDB.getConfig();
    }

    public LSMDBWorker getWorker(int dbId) {
        return this.localBabuDB.getWorker(dbId);
    }

    public int getWorkerCount() {
        return this.localBabuDB.getWorkerCount();
    }

    public void stop() {
        throw new UnsupportedOperationException("Manually stopping the local BabuDB instance is forbidden by the replication plugin.");
    }

    public LSN restart() throws BabuDBException {
        throw new UnsupportedOperationException("Manually restarting the local BabuDB instance is forbidden by the replication plugin.");
    }

    public void replaceTransactionManager(TransactionManagerInternal txnMan) {
        throw new UnsupportedOperationException("Manually changing the persistence manager of the local BabuDB instance is forbidden by the replication plugin.");
    }

    public void startupPerformed() {
        this.localBabuDB.startupPerformed();
    }

    public void shutdownPerformed() {
        this.localBabuDB.shutdownPerformed();
    }

    public void crashPerformed(Throwable cause) {
        this.localBabuDB.crashPerformed(cause);
    }

    public ProxyAccessClient getClient() {
        return this.client;
    }

    RequestRerunner getRequestRerunner() {
        return this.requestRerunner;
    }

    public ResponseManagerInternal getResponseManager() {
        return this.localBabuDB.getResponseManager();
    }

    public Object getRuntimeState(String propertyName) {
        if (!propertyName.startsWith("replication")) {
            return this.localBabuDB.getRuntimeState(propertyName);
        }
        return this.replMan.getRuntimeState(propertyName);
    }

    public Map<String, Object> getRuntimeState() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.putAll(this.localBabuDB.getRuntimeState());
        info.putAll(this.replMan.getRuntimeState());
        return info;
    }

    static final class RequestRerunner {
        private final Timer timer = new Timer("RequestRerunner", true);

        RequestRerunner() {
        }

        <T> void scheduleRequestRerun(ListenerWrapper<T> listener) {
            this.timer.schedule(new RequestTask<T>(listener), new Date(System.currentTimeMillis() + 10000L));
        }

        void shutdown() {
            this.timer.cancel();
        }

        private final class RequestTask<T>
        extends TimerTask {
            private final ListenerWrapper<T> listener;

            RequestTask(ListenerWrapper<T> listener) {
                this.listener = listener;
            }

            @Override
            public void run() {
                this.listener.tryAgain();
            }
        }
    }
}

