/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.dev.DatabaseManagerInternal;
import org.xtreemfs.babudb.api.dev.ResponseManagerInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.api.transaction.Transaction;
import org.xtreemfs.babudb.api.transaction.TransactionListener;
import org.xtreemfs.babudb.replication.ReplicationManager;
import org.xtreemfs.babudb.replication.policy.Policy;
import org.xtreemfs.babudb.replication.proxy.BabuDBProxy;
import org.xtreemfs.babudb.replication.proxy.DatabaseProxy;
import org.xtreemfs.babudb.replication.proxy.ProxyAccessClient;
import org.xtreemfs.babudb.replication.transmission.ErrorCode;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.foundation.logging.Logging;

public class DatabaseManagerProxy
implements DatabaseManagerInternal {
    private final DatabaseManagerInternal localDBMan;
    private final Policy replicationPolicy;
    private final ReplicationManager replicationManager;
    private final BabuDBProxy babuDBProxy;
    private final TransactionManagerInternal txnManProxy;
    private final ResponseManagerInternal responseManager;

    public DatabaseManagerProxy(DatabaseManagerInternal localDBMan, Policy policy, ReplicationManager replMan, BabuDBProxy babuDBProxy, TransactionManagerInternal persMan, ResponseManagerInternal respMan) {
        assert (localDBMan != null && !(localDBMan instanceof DatabaseManagerProxy));
        this.txnManProxy = persMan;
        this.localDBMan = localDBMan;
        this.replicationPolicy = policy;
        this.replicationManager = replMan;
        this.babuDBProxy = babuDBProxy;
        this.responseManager = respMan;
    }

    public DatabaseInternal getDatabase(String dbName) throws BabuDBException {
        BabuDBException be = null;
        int tries = 0;
        while (tries++ < 15) {
            InetSocketAddress master = this.getServerToPerformAt(0);
            if (master == null) {
                return new DatabaseProxy(this.localDBMan.getDatabase(dbName), this);
            }
            try {
                int dbId = this.babuDBProxy.getClient().getDatabase(dbName, master).get();
                return new DatabaseProxy(dbName, dbId, this);
            }
            catch (ReplicationClientAdapter.ErrorCodeException ece) {
                BabuDBException.ErrorCode code = ErrorCode.mapTransmissionError(ece.getCode());
                be = new BabuDBException(code, ece.getMessage());
                if (code != BabuDBException.ErrorCode.REPLICATION_FAILURE) {
                    throw be;
                }
            }
            catch (Exception e) {
                be = new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, e.getMessage());
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, ie.getMessage());
            }
        }
        throw be;
    }

    public DatabaseProxy getDatabaseNonblocking(String dbName) throws BabuDBException {
        InetSocketAddress master = this.getServerToPerformAt(-1);
        if (master == null) {
            return new DatabaseProxy(this.localDBMan.getDatabase(dbName), this);
        }
        try {
            int dbId = this.babuDBProxy.getClient().getDatabase(dbName, master).get();
            return new DatabaseProxy(dbName, dbId, this);
        }
        catch (ReplicationClientAdapter.ErrorCodeException ece) {
            throw new BabuDBException(ErrorCode.mapTransmissionError(ece.getCode()), ece.getMessage());
        }
        catch (Exception e) {
            throw new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, e.getMessage());
        }
    }

    public Map<String, DatabaseInternal> getDatabasesInternal() {
        Exception ex = null;
        int tries = 0;
        while (tries++ < 15) {
            try {
                InetSocketAddress master = this.getServerToPerformAt(0);
                HashMap<String, DatabaseInternal> r = new HashMap<String, DatabaseInternal>();
                if (master == null) {
                    for (Map.Entry e : this.localDBMan.getDatabasesInternal().entrySet()) {
                        r.put((String)e.getKey(), new DatabaseProxy((DatabaseInternal)e.getValue(), this));
                    }
                } else {
                    for (Map.Entry<String, Integer> e : this.babuDBProxy.getClient().getDatabases(master).get().entrySet()) {
                        r.put(e.getKey(), new DatabaseProxy(e.getKey(), e.getValue(), this));
                    }
                }
                return r;
            }
            catch (Exception exc) {
                ex = exc;
            }
        }
        Logging.logError((int)3, (Object)this, ex);
        return new HashMap<String, DatabaseInternal>();
    }

    public Map<String, DatabaseProxy> getDatabasesInternalNonblocking() {
        try {
            InetSocketAddress master = this.getServerToPerformAt(-1);
            HashMap<String, DatabaseProxy> r = new HashMap<String, DatabaseProxy>();
            if (master == null) {
                for (Map.Entry e : this.localDBMan.getDatabasesInternal().entrySet()) {
                    r.put((String)e.getKey(), new DatabaseProxy((DatabaseInternal)e.getValue(), this));
                }
            } else {
                for (Map.Entry<String, Integer> e : this.babuDBProxy.getClient().getDatabases(master).get().entrySet()) {
                    r.put(e.getKey(), new DatabaseProxy(e.getKey(), e.getValue(), this));
                }
            }
            return r;
        }
        catch (Exception e) {
            Logging.logError((int)3, (Object)this, (Throwable)e);
            return new HashMap<String, DatabaseProxy>();
        }
    }

    public Map<String, Database> getDatabases() {
        return new HashMap<String, DatabaseInternal>(this.getDatabasesInternal());
    }

    public DatabaseInternal createDatabase(String databaseName, int numIndices) throws BabuDBException {
        return this.createDatabase(databaseName, numIndices, null);
    }

    public DatabaseInternal createDatabase(String databaseName, int numIndices, ByteRangeComparator[] comparators) throws BabuDBException {
        DatabaseInternal result = this.localDBMan.createDatabase(databaseName, numIndices, comparators);
        if (result instanceof DatabaseProxy) {
            return result;
        }
        return new DatabaseProxy(result, this);
    }

    public void deleteDatabase(String databaseName) throws BabuDBException {
        this.localDBMan.deleteDatabase(databaseName);
    }

    public void copyDatabase(String sourceDB, String destDB) throws BabuDBException {
        this.localDBMan.copyDatabase(sourceDB, destDB);
    }

    public void dumpAllDatabases(String destPath) throws BabuDBException, IOException, InterruptedException {
        this.localDBMan.dumpAllDatabases(destPath);
    }

    private InetSocketAddress getServerToPerformAt(int timeout) throws BabuDBException {
        InetSocketAddress master;
        try {
            master = this.replicationManager.getMaster(timeout);
        }
        catch (InterruptedException e) {
            throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "Waiting for a lease holder was interrupted.", (Throwable)e);
        }
        if (this.replicationManager.isItMe(master) || !this.replicationPolicy.dbModificationIsMasterRestricted()) {
            return null;
        }
        if (this.replicationManager.redirectIsVisible()) {
            throw new BabuDBException(BabuDBException.ErrorCode.REDIRECT, master.toString());
        }
        return master;
    }

    DatabaseInternal getLocalDatabase(String name) throws BabuDBException {
        return this.localDBMan.getDatabase(name);
    }

    ProxyAccessClient getClient() {
        return this.babuDBProxy.getClient();
    }

    TransactionManagerInternal getTransactionManager() {
        return this.txnManProxy;
    }

    ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    BabuDBProxy.RequestRerunner getRequestRerunner() {
        return this.babuDBProxy.getRequestRerunner();
    }

    public Collection<DatabaseInternal> getDatabaseList() {
        return this.getDatabasesInternal().values();
    }

    public Collection<DatabaseInternal> getLocalDatabaseList() {
        return this.localDBMan.getDatabasesInternal().values();
    }

    public Object getDBModificationLock() {
        return this.localDBMan.getDBModificationLock();
    }

    public void reset() throws BabuDBException {
        this.localDBMan.reset();
    }

    public void shutdown() throws BabuDBException {
        this.localDBMan.shutdown();
    }

    public DatabaseInternal getDatabase(int dbId) throws BabuDBException {
        BabuDBException be = null;
        int tries = 0;
        while (tries++ < 15) {
            InetSocketAddress master = this.getServerToPerformAt(0);
            if (master == null) {
                return new DatabaseProxy(this.localDBMan.getDatabase(dbId), this);
            }
            try {
                String dbName = this.babuDBProxy.getClient().getDatabase(dbId, master).get();
                return new DatabaseProxy(dbName, dbId, this);
            }
            catch (ReplicationClientAdapter.ErrorCodeException ece) {
                BabuDBException.ErrorCode code = ErrorCode.mapTransmissionError(ece.getCode());
                be = new BabuDBException(code, ece.getMessage());
                if (code == BabuDBException.ErrorCode.REPLICATION_FAILURE) continue;
                throw be;
            }
            catch (Exception e) {
                be = new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, e.getMessage());
            }
        }
        throw be;
    }

    public DatabaseProxy getDatabaseNonblocking(int dbId) throws BabuDBException {
        InetSocketAddress master = this.getServerToPerformAt(-1);
        if (master == null) {
            return new DatabaseProxy(this.localDBMan.getDatabase(dbId), this);
        }
        try {
            String dbName = this.babuDBProxy.getClient().getDatabase(dbId, master).get();
            return new DatabaseProxy(dbName, dbId, this);
        }
        catch (ReplicationClientAdapter.ErrorCodeException ece) {
            throw new BabuDBException(ErrorCode.mapTransmissionError(ece.getCode()), ece.getMessage());
        }
        catch (Exception e) {
            throw new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, e.getMessage());
        }
    }

    public int getNextDBId() {
        try {
            if (this.getServerToPerformAt(0) == null) {
                return this.localDBMan.getNextDBId();
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Manually influencing the DatabaseMangager of a 'not master' server is not supported by the replication plugin.");
    }

    public void setNextDBId(int id) {
        try {
            if (this.getServerToPerformAt(0) == null) {
                this.localDBMan.setNextDBId(id);
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Manually influencing the DatabaseMangager of a 'not master' server is not supported by the replication plugin.");
    }

    public Map<String, ByteRangeComparator> getComparatorInstances() {
        try {
            if (this.getServerToPerformAt(0) == null) {
                return this.localDBMan.getComparatorInstances();
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Manually influencing the DatabaseMangager of a 'not master' server is not supported by the replication plugin.");
    }

    public void putDatabase(DatabaseInternal database) {
        try {
            if (this.getServerToPerformAt(0) == null) {
                this.localDBMan.putDatabase(database);
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Manually influencing the DatabaseMangager of a 'not master' server is not supported by the replication plugin.");
    }

    public Set<Integer> getAllDatabaseIds() {
        try {
            if (this.getServerToPerformAt(0) == null) {
                return this.localDBMan.getAllDatabaseIds();
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Manually influencing the DatabaseMangager of a 'not master' server is not supported by the replication plugin.");
    }

    public void removeDatabaseById(int id) {
        try {
            if (this.getServerToPerformAt(0) == null) {
                this.localDBMan.removeDatabaseById(id);
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Manually influencing the DatabaseMangager of a 'not master' server is not supported by the replication plugin.");
    }

    public void executeTransaction(Transaction txn) throws BabuDBException {
        this.localDBMan.executeTransaction(txn);
    }

    public void addTransactionListener(TransactionListener listener) {
        this.localDBMan.addTransactionListener(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.localDBMan.removeTransactionListener(listener);
    }

    public TransactionInternal createTransaction() {
        return this.localDBMan.createTransaction();
    }

    public void executeTransaction(TransactionInternal txn) throws BabuDBException {
        this.localDBMan.executeTransaction(txn);
    }

    public Policy getReplicationPolicy() {
        return this.replicationPolicy;
    }

    public ResponseManagerInternal getResponseManager() {
        return this.responseManager;
    }

    public Object getRuntimeState(String property) {
        return this.localDBMan.getRuntimeState(property);
    }

    public Map<String, Object> getRuntimeState() {
        return this.localDBMan.getRuntimeState();
    }
}

