/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy;

import java.net.InetSocketAddress;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.DatabaseInsertGroup;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.database.DatabaseRequestResult;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.database.UserDefinedLookup;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.lsmdb.BabuDBInsertGroup;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.replication.proxy.DatabaseManagerProxy;
import org.xtreemfs.babudb.replication.proxy.ListenerWrapper;
import org.xtreemfs.babudb.replication.transmission.ErrorCode;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class DatabaseProxy
implements DatabaseInternal {
    private final DatabaseManagerProxy dbMan;
    private final String name;
    private final int id;
    private DatabaseInternal localDB;

    public DatabaseProxy(DatabaseInternal localDatabase, DatabaseManagerProxy dbManProxy) {
        assert (localDatabase != null && !(localDatabase instanceof DatabaseProxy));
        this.localDB = localDatabase;
        this.name = this.localDB.getName();
        this.id = this.localDB.getLSMDB().getDatabaseId();
        this.dbMan = dbManProxy;
    }

    public DatabaseProxy(String dbName, int dbId, DatabaseManagerProxy dbManProxy) {
        this.name = dbName;
        this.id = dbId;
        this.localDB = null;
        this.dbMan = dbManProxy;
    }

    public DatabaseRequestResult<byte[]> lookup(final int indexId, final byte[] key, final Object context) {
        assert (key != null);
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        new ListenerWrapper<byte[]>(result, new ListenerWrapper.RequestOperation<byte[]>(){

            @Override
            public void execute(ListenerWrapper<byte[]> listener) {
                InetSocketAddress master = null;
                try {
                    master = DatabaseProxy.this.getServerToPerformAt(0);
                    if (master == null) {
                        DatabaseProxy.this.localDB.lookup(indexId, key, context).registerListener(listener);
                    } else {
                        DatabaseProxy.this.dbMan.getClient().lookup(DatabaseProxy.this.name, indexId, ReusableBuffer.wrap((byte[])key), master).registerListener(listener);
                    }
                }
                catch (BabuDBException e) {
                    listener.failed((Exception)((Object)e));
                }
            }
        }, this.dbMan.getRequestRerunner());
        return result;
    }

    public DatabaseRequestResult<byte[]> lookupNonblocking(int indexId, byte[] key, Object context) {
        assert (key != null);
        InetSocketAddress master = null;
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        try {
            master = this.getServerToPerformAt(-1);
            if (master == null) {
                return this.localDB.lookup(indexId, key, context);
            }
        }
        catch (BabuDBException e) {
            result.failed(e);
            return result;
        }
        this.dbMan.getClient().lookup(this.name, indexId, ReusableBuffer.wrap((byte[])key), master).registerListener(new ListenerWrapper(result));
        return result;
    }

    public DatabaseRequestResult<ResultSet<byte[], byte[]>> prefixLookup(final int indexId, final byte[] key, final Object context) {
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        new ListenerWrapper<ResultSet<byte[], byte[]>>(result, new ListenerWrapper.RequestOperation<ResultSet<byte[], byte[]>>(){

            @Override
            public void execute(ListenerWrapper<ResultSet<byte[], byte[]>> listener) {
                InetSocketAddress master = null;
                try {
                    master = DatabaseProxy.this.getServerToPerformAt(0);
                    if (master == null) {
                        DatabaseProxy.this.localDB.prefixLookup(indexId, key, context).registerListener(listener);
                    } else {
                        DatabaseProxy.this.dbMan.getClient().prefixLookup(DatabaseProxy.this.name, indexId, ReusableBuffer.wrap((byte[])key), master).registerListener(listener);
                    }
                }
                catch (BabuDBException e) {
                    listener.failed((Exception)((Object)e));
                }
            }
        }, this.dbMan.getRequestRerunner());
        return result;
    }

    public DatabaseRequestResult<ResultSet<byte[], byte[]>> prefixLookupNonblocking(int indexId, byte[] key, Object context) {
        InetSocketAddress master = null;
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        try {
            master = this.getServerToPerformAt(-1);
            if (master == null) {
                return this.localDB.prefixLookup(indexId, key, context);
            }
        }
        catch (BabuDBException e) {
            result.failed(e);
            return result;
        }
        this.dbMan.getClient().prefixLookup(this.name, indexId, ReusableBuffer.wrap((byte[])key), master).registerListener(new ListenerWrapper(result));
        return result;
    }

    public DatabaseRequestResult<ResultSet<byte[], byte[]>> reversePrefixLookup(final int indexId, final byte[] key, final Object context) {
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        new ListenerWrapper<ResultSet<byte[], byte[]>>(result, new ListenerWrapper.RequestOperation<ResultSet<byte[], byte[]>>(){

            @Override
            public void execute(ListenerWrapper<ResultSet<byte[], byte[]>> listener) {
                InetSocketAddress master = null;
                try {
                    master = DatabaseProxy.this.getServerToPerformAt(0);
                    if (master == null) {
                        DatabaseProxy.this.localDB.reversePrefixLookup(indexId, key, context).registerListener(listener);
                    } else {
                        DatabaseProxy.this.dbMan.getClient().prefixLookupR(DatabaseProxy.this.name, indexId, ReusableBuffer.wrap((byte[])key), master).registerListener(listener);
                    }
                }
                catch (BabuDBException e) {
                    listener.failed((Exception)((Object)e));
                }
            }
        }, this.dbMan.getRequestRerunner());
        return result;
    }

    public DatabaseRequestResult<ResultSet<byte[], byte[]>> reversePrefixLookupNonblocking(int indexId, byte[] key, Object context) {
        InetSocketAddress master = null;
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        try {
            master = this.getServerToPerformAt(-1);
            if (master == null) {
                return this.localDB.reversePrefixLookup(indexId, key, context);
            }
        }
        catch (BabuDBException e) {
            result.failed(e);
            return result;
        }
        this.dbMan.getClient().prefixLookupR(this.name, indexId, ReusableBuffer.wrap((byte[])key), master).registerListener(new ListenerWrapper(result));
        return result;
    }

    public DatabaseRequestResult<ResultSet<byte[], byte[]>> rangeLookup(final int indexId, final byte[] from, final byte[] to, final Object context) {
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        new ListenerWrapper<ResultSet<byte[], byte[]>>(result, new ListenerWrapper.RequestOperation<ResultSet<byte[], byte[]>>(){

            @Override
            public void execute(ListenerWrapper<ResultSet<byte[], byte[]>> listener) {
                InetSocketAddress master = null;
                try {
                    master = DatabaseProxy.this.getServerToPerformAt(0);
                    if (master == null) {
                        DatabaseProxy.this.localDB.rangeLookup(indexId, from, to, context).registerListener(listener);
                    } else {
                        DatabaseProxy.this.dbMan.getClient().rangeLookup(DatabaseProxy.this.name, indexId, ReusableBuffer.wrap((byte[])from), ReusableBuffer.wrap((byte[])to), master).registerListener(listener);
                    }
                }
                catch (BabuDBException e) {
                    listener.failed((Exception)((Object)e));
                }
            }
        }, this.dbMan.getRequestRerunner());
        return result;
    }

    public DatabaseRequestResult<ResultSet<byte[], byte[]>> rangeLookupNonblocking(int indexId, byte[] from, byte[] to, Object context) {
        InetSocketAddress master = null;
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        try {
            master = this.getServerToPerformAt(-1);
            if (master == null) {
                return this.localDB.rangeLookup(indexId, from, to, context);
            }
        }
        catch (BabuDBException e) {
            result.failed(e);
            return result;
        }
        this.dbMan.getClient().rangeLookup(this.name, indexId, ReusableBuffer.wrap((byte[])from), ReusableBuffer.wrap((byte[])to), master).registerListener(new ListenerWrapper(result));
        return result;
    }

    public DatabaseRequestResult<ResultSet<byte[], byte[]>> reverseRangeLookup(final int indexId, final byte[] from, final byte[] to, final Object context) {
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        new ListenerWrapper<ResultSet<byte[], byte[]>>(result, new ListenerWrapper.RequestOperation<ResultSet<byte[], byte[]>>(){

            @Override
            public void execute(ListenerWrapper<ResultSet<byte[], byte[]>> listener) {
                InetSocketAddress master = null;
                try {
                    master = DatabaseProxy.this.getServerToPerformAt(0);
                    if (master == null) {
                        DatabaseProxy.this.localDB.reverseRangeLookup(indexId, from, to, context).registerListener(listener);
                    } else {
                        DatabaseProxy.this.dbMan.getClient().rangeLookupR(DatabaseProxy.this.name, indexId, ReusableBuffer.wrap((byte[])from), ReusableBuffer.wrap((byte[])to), master).registerListener(listener);
                    }
                }
                catch (BabuDBException e) {
                    listener.failed((Exception)((Object)e));
                }
            }
        }, this.dbMan.getRequestRerunner());
        return result;
    }

    public DatabaseRequestResult<ResultSet<byte[], byte[]>> reverseRangeLookupNonblocking(int indexId, byte[] from, byte[] to, Object context) {
        InetSocketAddress master = null;
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        try {
            master = this.getServerToPerformAt(-1);
            if (master == null) {
                return this.localDB.reverseRangeLookup(indexId, from, to, context);
            }
        }
        catch (BabuDBException e) {
            result.failed(e);
            return result;
        }
        this.dbMan.getClient().rangeLookupR(this.name, indexId, ReusableBuffer.wrap((byte[])from), ReusableBuffer.wrap((byte[])to), master).registerListener(new ListenerWrapper(result));
        return result;
    }

    public DatabaseRequestResult<Object> userDefinedLookup(UserDefinedLookup udl, final Object context) {
        InetSocketAddress master = null;
        try {
            master = this.getServerToPerformAt(0);
            if (master == null) {
                return this.localDB.userDefinedLookup(udl, context);
            }
        }
        catch (BabuDBException e) {
            return new DatabaseRequestResult<Object>(){

                public void registerListener(DatabaseRequestListener<Object> listener) {
                    listener.failed(e, context);
                }

                public Object get() throws BabuDBException {
                    throw e;
                }
            };
        }
        throw new UnsupportedOperationException("This operation is not supported by the replication-plugin yet.");
    }

    public void shutdown() throws BabuDBException {
        if (this.localDB != null) {
            this.localDB.shutdown();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public BabuDBInsertGroup createInsertGroup() {
        return BabuDBInsertGroup.createInsertGroup((int)this.id);
    }

    public ByteRangeComparator[] getComparators() {
        InetSocketAddress master = null;
        try {
            master = this.getServerToPerformAt(0);
            if (master == null) {
                return this.localDB.getComparators();
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("This operation is not supported by the replication-plugin yet.");
    }

    public DatabaseRequestResult<Object> singleInsert(int indexId, byte[] key, byte[] value, Object context) {
        BabuDBInsertGroup irg = this.createInsertGroup();
        irg.addInsert(indexId, key, value);
        return this.insert((DatabaseInsertGroup)irg, context);
    }

    public DatabaseRequestResult<Object> insert(DatabaseInsertGroup irg, Object context) {
        return this.insert((BabuDBInsertGroup)irg, context);
    }

    public DatabaseRequestResult<Object> insert(BabuDBInsertGroup irg, Object context) {
        BabuDBRequestResultImpl result = new BabuDBRequestResultImpl(context, this.dbMan.getResponseManager());
        try {
            this.dbMan.getTransactionManager().makePersistent(this.dbMan.createTransaction().insertRecordGroup(this.getName(), irg.getRecord()), result);
        }
        catch (BabuDBException e) {
            result.failed(e);
        }
        return result;
    }

    private InetSocketAddress getServerToPerformAt(int timeout) throws BabuDBException {
        InetSocketAddress master;
        try {
            master = this.dbMan.getReplicationManager().getMaster(timeout);
        }
        catch (InterruptedException e) {
            throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "Waiting for a lease holder was interrupted.", (Throwable)e);
        }
        boolean isMaster = this.dbMan.getReplicationManager().isItMe(master);
        if (isMaster || !this.dbMan.getReplicationPolicy().lookUpIsMasterRestricted()) {
            if (isMaster || !this.dbMan.getReplicationPolicy().dbModificationIsMasterRestricted()) {
                this.localDB = this.dbMan.getLocalDatabase(this.name);
            } else {
                try {
                    this.dbMan.getClient().getDatabase(this.name, master).get();
                    this.localDB = this.dbMan.getLocalDatabase(this.name);
                }
                catch (BabuDBException e) {
                    return master;
                }
                catch (ReplicationClientAdapter.ErrorCodeException e) {
                    throw new BabuDBException(ErrorCode.mapTransmissionError(e.getCode()), e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }
        if (this.dbMan.getReplicationManager().redirectIsVisible()) {
            throw new BabuDBException(BabuDBException.ErrorCode.REDIRECT, master.toString());
        }
        return master;
    }

    public LSMDatabase getLSMDB() {
        try {
            if (this.getServerToPerformAt(0) == null) {
                return this.localDB.getLSMDB();
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
    }

    public void proceedWriteSnapshot(int[] snapIds, String directory, SnapshotConfig cfg) throws BabuDBException {
        boolean permission = false;
        try {
            if (this.getServerToPerformAt(0) == null) {
                permission = true;
            }
        }
        catch (BabuDBException be) {
            // empty catch block
        }
        if (!permission) {
            throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
        }
        this.localDB.proceedWriteSnapshot(snapIds, directory, cfg);
    }

    public void setLSMDB(LSMDatabase lsmDatabase) {
        try {
            if (this.getServerToPerformAt(0) == null) {
                this.localDB.setLSMDB(lsmDatabase);
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
    }

    public void proceedWriteSnapshot(int viewId, long sequenceNo, int[] snapIds) throws BabuDBException {
        boolean permission = false;
        try {
            if (this.getServerToPerformAt(0) == null) {
                permission = true;
            }
        }
        catch (BabuDBException be) {
            // empty catch block
        }
        if (!permission) {
            throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
        }
        this.localDB.proceedWriteSnapshot(viewId, sequenceNo, snapIds);
    }

    public void proceedCleanupSnapshot(int viewId, long sequenceNo) throws BabuDBException {
        boolean permission = false;
        try {
            if (this.getServerToPerformAt(0) == null) {
                permission = true;
            }
        }
        catch (BabuDBException be) {
            // empty catch block
        }
        if (!permission) {
            throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
        }
        this.localDB.proceedCleanupSnapshot(viewId, sequenceNo);
    }

    public int[] proceedCreateSnapshot() {
        try {
            if (this.getServerToPerformAt(0) == null) {
                return this.localDB.proceedCreateSnapshot();
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
    }

    public void dumpSnapshot(String baseDir) throws BabuDBException {
        boolean permission = false;
        try {
            if (this.getServerToPerformAt(0) == null) {
                permission = true;
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        if (!permission) {
            throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
        }
        this.localDB.dumpSnapshot(baseDir);
    }

    public void proceedSnapshot(String destDB) throws BabuDBException, InterruptedException {
        boolean permission = false;
        try {
            if (this.getServerToPerformAt(0) == null) {
                permission = true;
            }
        }
        catch (BabuDBException babuDBException) {
            // empty catch block
        }
        if (!permission) {
            throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
        }
        this.localDB.proceedSnapshot(destDB);
    }

    public byte[] directLookup(int indexId, int snapId, byte[] key) throws BabuDBException {
        boolean permission = false;
        try {
            if (this.getServerToPerformAt(0) == null) {
                permission = true;
            }
        }
        catch (BabuDBException be) {
            // empty catch block
        }
        if (permission) {
            return this.localDB.directLookup(indexId, snapId, key);
        }
        throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
    }

    public ResultSet<byte[], byte[]> directPrefixLookup(int indexId, int snapId, byte[] key, boolean ascending) throws BabuDBException {
        boolean permission = false;
        try {
            if (this.getServerToPerformAt(0) == null) {
                permission = true;
            }
        }
        catch (BabuDBException be) {
            // empty catch block
        }
        if (permission) {
            return this.localDB.directPrefixLookup(indexId, snapId, key, ascending);
        }
        throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
    }

    public ResultSet<byte[], byte[]> directRangeLookup(int indexId, int snapId, byte[] from, byte[] to, boolean ascending) throws BabuDBException {
        boolean permission = false;
        try {
            if (this.getServerToPerformAt(0) == null) {
                permission = true;
            }
        }
        catch (BabuDBException be) {
            // empty catch block
        }
        if (permission) {
            return this.localDB.directRangeLookup(indexId, snapId, from, to, ascending);
        }
        throw new UnsupportedOperationException("Internally manipulating a Database of a 'not master' server is not supported by the replication plugin.");
    }
}

