/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy;

import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.log.SyncListener;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.proxy.BabuDBProxy;
import org.xtreemfs.babudb.replication.service.clients.ClientResponseFuture;
import org.xtreemfs.babudb.replication.transmission.ErrorCode;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

final class ListenerWrapper<T>
implements ClientResponseFuture.ClientResponseAvailableListener<T>,
SyncListener,
DatabaseRequestListener<T> {
    private final BabuDBRequestResultImpl<T> requestFuture;
    private final T result;
    private int tries = 0;
    private final RequestOperation<T> request;
    private final BabuDBProxy.RequestRerunner rerunner;
    private final ReusableBuffer payload;

    public ListenerWrapper(BabuDBRequestResultImpl<T> requestFuture) {
        this(requestFuture, null);
    }

    public ListenerWrapper(BabuDBRequestResultImpl<T> requestFuture, RequestOperation<T> request, BabuDBProxy.RequestRerunner rerunner) {
        this(requestFuture, null, request, rerunner, null);
    }

    public ListenerWrapper(BabuDBRequestResultImpl<T> requestFuture, RequestOperation<T> request, BabuDBProxy.RequestRerunner rerunner, ReusableBuffer payload) {
        this(requestFuture, null, request, rerunner, payload);
    }

    public ListenerWrapper(BabuDBRequestResultImpl<T> requestFuture, T result) {
        this(requestFuture, result, null, null, null);
    }

    public ListenerWrapper(BabuDBRequestResultImpl<T> requestFuture, T result, RequestOperation<T> request, BabuDBProxy.RequestRerunner rerunner, ReusableBuffer payload) {
        this.requestFuture = requestFuture;
        this.result = result;
        this.rerunner = rerunner;
        this.request = request;
        this.payload = payload;
        if (request != null) {
            this.tryAgain();
        }
    }

    void tryAgain() {
        this.request.execute(this);
    }

    @Override
    public void responseAvailable(T r) {
        if (this.payload != null) {
            BufferPool.free((ReusableBuffer)this.payload);
        }
        this.requestFuture.finished(r);
    }

    @Override
    public void requestFailed(Exception e) {
        Logging.logMessage((int)6, (Object)this, (String)"Client request failed, because %s.", (Object[])new Object[]{e.getMessage()});
        Logging.logError((int)7, (Object)this, (Throwable)e);
        if (e instanceof ReplicationClientAdapter.ErrorCodeException) {
            BabuDBException.ErrorCode code = ErrorCode.mapTransmissionError(((ReplicationClientAdapter.ErrorCodeException)e).getCode());
            if (code == BabuDBException.ErrorCode.REPLICATION_FAILURE) {
                this.checkForRetry(new BabuDBException(code, e.getMessage()));
            } else {
                if (this.payload != null) {
                    BufferPool.free((ReusableBuffer)this.payload);
                }
                this.requestFuture.failed(new BabuDBException(code, e.getMessage()));
            }
        } else {
            this.checkForRetry(new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, e.getMessage()));
        }
    }

    public void synced(LSN lsn) {
        if (this.payload != null) {
            BufferPool.free((ReusableBuffer)this.payload);
        }
        this.requestFuture.finished(this.result, lsn);
    }

    public void failed(Exception e) {
        Logging.logMessage((int)6, (Object)this, (String)"Sync request failed, because %s.", (Object[])new Object[]{e.getMessage()});
        Logging.logError((int)7, (Object)this, (Throwable)e);
        this.checkForRetry(new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, e.getMessage()));
    }

    public void failed(BabuDBException e, Object context) {
        Logging.logMessage((int)6, (Object)this, (String)"Local request failed, because %s.", (Object[])new Object[]{e.getMessage()});
        Logging.logError((int)7, (Object)this, (Throwable)e);
        if (this.payload != null) {
            BufferPool.free((ReusableBuffer)this.payload);
        }
        this.requestFuture.failed(e);
    }

    public void finished(T r, Object context) {
        if (this.payload != null) {
            BufferPool.free((ReusableBuffer)this.payload);
        }
        this.requestFuture.finished(r);
    }

    private final void checkForRetry(BabuDBException e) {
        if (this.request != null && this.tries++ < 15) {
            this.rerunner.scheduleRequestRerun(this);
        } else {
            if (this.payload != null) {
                BufferPool.free((ReusableBuffer)this.payload);
            }
            this.requestFuture.failed(e);
        }
    }

    static interface RequestOperation<T> {
        public void execute(ListenerWrapper<T> var1);
    }
}

