/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy;

import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.control.ControlLayerInterface;
import org.xtreemfs.babudb.replication.proxy.operations.GetDatabaseByIdOperation;
import org.xtreemfs.babudb.replication.proxy.operations.GetDatabaseByNameOperation;
import org.xtreemfs.babudb.replication.proxy.operations.GetDatabasesOperation;
import org.xtreemfs.babudb.replication.proxy.operations.LookupOperation;
import org.xtreemfs.babudb.replication.proxy.operations.MakePersistentOperation;
import org.xtreemfs.babudb.replication.proxy.operations.PrefixLookupOperation;
import org.xtreemfs.babudb.replication.proxy.operations.PrefixLookupReverseOperation;
import org.xtreemfs.babudb.replication.proxy.operations.RangeLookupOperation;
import org.xtreemfs.babudb.replication.proxy.operations.RangeLookupReverseOperation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.RequestHandler;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;

public class ProxyRequestHandler
extends RequestHandler {
    private final ControlLayerInterface control;

    public ProxyRequestHandler(BabuDBInterface dbs, int maxQ, ControlLayerInterface control) {
        super(maxQ);
        this.control = control;
        Operation op = new MakePersistentOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
        op = new GetDatabaseByNameOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
        op = new GetDatabaseByIdOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
        op = new GetDatabasesOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
        op = new LookupOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
        op = new PrefixLookupOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
        op = new PrefixLookupReverseOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
        op = new RangeLookupOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
        op = new RangeLookupReverseOperation(dbs);
        this.operations.put(op.getProcedureId(), op);
    }

    @Override
    public void handleRequest(RPCServerRequest rq) {
        if (!this.control.isFailoverInProgress()) {
            super.handleRequest(rq);
        } else {
            rq.sendError(RPC.RPCHeader.ErrorResponse.newBuilder().setErrorMessage("Currently there is a failover in progress. Please try again later.").setErrorType(RPC.ErrorType.REDIRECT).setPosixErrno(RPC.POSIXErrno.POSIX_ERROR_NONE).build());
        }
    }

    @Override
    public int getInterfaceID() {
        return 10001;
    }
}

