/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.dev.transaction.InMemoryProcessing;
import org.xtreemfs.babudb.api.dev.transaction.TransactionInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.transaction.TransactionListener;
import org.xtreemfs.babudb.log.DiskLogger;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.ReplicationManager;
import org.xtreemfs.babudb.replication.policy.Policy;
import org.xtreemfs.babudb.replication.proxy.BabuDBProxy;
import org.xtreemfs.babudb.replication.proxy.ListenerWrapper;
import org.xtreemfs.babudb.replication.service.accounting.ReplicateResponse;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class TransactionManagerProxy
extends TransactionManagerInternal {
    private final ReplicationManager replMan;
    private final TransactionManagerInternal localTxnMan;
    private final Policy replicationPolicy;
    private final BabuDBProxy babuDBProxy;

    public TransactionManagerProxy(ReplicationManager replMan, TransactionManagerInternal localTxnMan, Policy replicationPolicy, BabuDBProxy babuDBProxy) {
        assert (!(localTxnMan instanceof TransactionManagerProxy));
        this.babuDBProxy = babuDBProxy;
        this.replicationPolicy = replicationPolicy;
        this.replMan = replMan;
        this.localTxnMan = localTxnMan;
        for (Map.Entry e : localTxnMan.getProcessingLogic().entrySet()) {
            this.registerInMemoryProcessing((Byte)e.getKey(), (InMemoryProcessing)e.getValue());
        }
    }

    public void makePersistent(TransactionInternal txn, ReusableBuffer serialized, BabuDBRequestResultImpl<Object> future) throws BabuDBException {
        assert (serialized != null);
        try {
            InetSocketAddress master = this.getServerToPerformAt(txn.aggregateOperationTypes(), 0);
            if (master == null) {
                this.executeLocallyAndReplicate(txn, serialized, future);
            } else {
                this.redirectToMaster(serialized, master, future);
            }
        }
        catch (BabuDBException be) {
            BufferPool.free((ReusableBuffer)serialized);
            throw be;
        }
    }

    public void makePersistentNonBlocking(ReusableBuffer serialized, BabuDBRequestResultImpl<Object> future) throws BabuDBException {
        assert (serialized != null);
        try {
            TransactionInternal txn = TransactionInternal.deserialize((ReusableBuffer)serialized);
            serialized.flip();
            InetSocketAddress master = this.getServerToPerformAt(txn.aggregateOperationTypes(), -1);
            if (master == null) {
                this.executeLocallyAndReplicate(txn, serialized, future);
            } else {
                this.redirectToMaster(serialized, master, future);
            }
        }
        catch (BabuDBException be) {
            BufferPool.free((ReusableBuffer)serialized);
            throw be;
        }
        catch (IOException e) {
            if (serialized != null) {
                BufferPool.free((ReusableBuffer)serialized);
            }
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private void executeLocallyAndReplicate(TransactionInternal txn, final ReusableBuffer payload, final BabuDBRequestResultImpl<Object> future) throws BabuDBException {
        final BabuDBRequestResultImpl localFuture = new BabuDBRequestResultImpl(this.babuDBProxy.getResponseManager());
        this.localTxnMan.makePersistent(txn, payload.createViewBuffer(), localFuture);
        localFuture.registerListener((DatabaseRequestListener)new DatabaseRequestListener<Object>(){

            public void finished(Object result, Object context) {
                LSN assignedByDiskLogger = localFuture.getAssignedLSN();
                LogEntry le = new LogEntry(payload, new ListenerWrapper<Object>(future, result), 6);
                le.assignId(assignedByDiskLogger.getViewId(), assignedByDiskLogger.getSequenceNo());
                ReplicateResponse rp = TransactionManagerProxy.this.replMan.replicate(le);
                if (!rp.hasFailed()) {
                    TransactionManagerProxy.this.replMan.subscribeListener(rp);
                }
                le.free();
            }

            public void failed(BabuDBException error, Object context) {
                future.failed(error);
            }
        });
    }

    private void redirectToMaster(final ReusableBuffer load, final InetSocketAddress master, BabuDBRequestResultImpl<Object> future) {
        new ListenerWrapper<Object>(future, new ListenerWrapper.RequestOperation<Object>(){

            @Override
            public void execute(ListenerWrapper<Object> listener) {
                TransactionManagerProxy.this.babuDBProxy.getClient().makePersistent(master, load.createViewBuffer()).registerListener(listener);
            }
        }, this.babuDBProxy.getRequestRerunner(), load);
    }

    private InetSocketAddress getServerToPerformAt(byte aggregatedType, int timeout) throws BabuDBException {
        InetSocketAddress master;
        try {
            master = this.replMan.getMaster(timeout);
        }
        catch (InterruptedException e) {
            throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "Waiting for a lease holder was interrupted.", (Throwable)e);
        }
        if (this.replMan.isItMe(master) || TransactionInternal.containsOperationType((byte)aggregatedType, (byte)0) && !this.replicationPolicy.insertIsMasterRestricted() || (TransactionInternal.containsOperationType((byte)aggregatedType, (byte)1) || TransactionInternal.containsOperationType((byte)aggregatedType, (byte)5)) && !this.replicationPolicy.snapshotManipultationIsMasterRestricted() || (TransactionInternal.containsOperationType((byte)aggregatedType, (byte)2) || TransactionInternal.containsOperationType((byte)aggregatedType, (byte)3) || TransactionInternal.containsOperationType((byte)aggregatedType, (byte)4)) && !this.replicationPolicy.dbModificationIsMasterRestricted()) {
            return null;
        }
        if (this.replMan.redirectIsVisible()) {
            throw new BabuDBException(BabuDBException.ErrorCode.REDIRECT, master.toString());
        }
        return master;
    }

    public void lockService() throws InterruptedException {
        this.localTxnMan.lockService();
    }

    public void unlockService() {
        this.localTxnMan.unlockService();
    }

    public void setLogger(DiskLogger logger) {
        this.localTxnMan.setLogger(logger);
    }

    public LSN getLatestOnDiskLSN() {
        return this.localTxnMan.getLatestOnDiskLSN();
    }

    public void init(LSN initial) {
        this.localTxnMan.init(initial);
    }

    public void replayTransaction(TransactionInternal txn) throws BabuDBException {
        this.localTxnMan.replayTransaction(txn);
    }

    public void addTransactionListener(TransactionListener listener) {
        this.localTxnMan.addTransactionListener(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.localTxnMan.removeTransactionListener(listener);
    }
}

