/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.transmission.ErrorCode;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.logging.Logging;

public class GetDatabaseByIdOperation
extends Operation {
    private final BabuDBInterface dbs;

    public GetDatabaseByIdOperation(BabuDBInterface dbs) {
        this.dbs = dbs;
    }

    @Override
    public int getProcedureId() {
        return 3;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.DatabaseId.getDefaultInstance();
    }

    @Override
    public void processRequest(Request rq) {
        int dbId = ((GlobalTypes.DatabaseId)rq.getRequestMessage()).getDatabaseId();
        Logging.logMessage((int)7, (Object)this, (String)"GetDatabaseByIdOperation: dbId %d.", (Object[])new Object[]{dbId});
        try {
            rq.sendSuccess((Message)GlobalTypes.Database.newBuilder().setDatabaseName(this.dbs.getDatabase(dbId).getName()).setDatabaseId(dbId).build());
        }
        catch (BabuDBException e) {
            rq.sendSuccess((Message)GlobalTypes.Database.newBuilder().setErrorCode(ErrorCode.mapUserError(e)).setDatabaseId(dbId).setDatabaseName("\u0000").build());
        }
    }
}

