/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.transmission.ErrorCode;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.logging.Logging;

public class GetDatabaseByNameOperation
extends Operation {
    private final BabuDBInterface dbs;

    public GetDatabaseByNameOperation(BabuDBInterface dbs) {
        this.dbs = dbs;
    }

    @Override
    public int getProcedureId() {
        return 2;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.DatabaseName.getDefaultInstance();
    }

    @Override
    public void processRequest(Request rq) {
        String dbName = ((GlobalTypes.DatabaseName)rq.getRequestMessage()).getDatabaseName();
        Logging.logMessage((int)7, (Object)this, (String)"GetDatabaseByNameOperation: dbId %s.", (Object[])new Object[]{dbName});
        try {
            rq.sendSuccess((Message)GlobalTypes.Database.newBuilder().setDatabaseName(dbName).setDatabaseId(this.dbs.getDatabase(dbName).getID()).build());
        }
        catch (BabuDBException e) {
            rq.sendSuccess((Message)GlobalTypes.Database.newBuilder().setErrorCode(ErrorCode.mapUserError(e)).setDatabaseId(-1).setDatabaseName(dbName).build());
        }
    }
}

