/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy.operations;

import com.google.protobuf.Message;
import java.util.Map;
import org.xtreemfs.babudb.pbrpc.Common;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.proxy.DatabaseProxy;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.logging.Logging;

public class GetDatabasesOperation
extends Operation {
    private final BabuDBInterface dbs;

    public GetDatabasesOperation(BabuDBInterface dbs) {
        this.dbs = dbs;
    }

    @Override
    public int getProcedureId() {
        return 4;
    }

    @Override
    public Message getDefaultRequest() {
        return Common.emptyRequest.getDefaultInstance();
    }

    @Override
    public void processRequest(Request rq) {
        Logging.logMessage((int)7, (Object)this, (String)"GetDatabasesOperation.", (Object[])new Object[0]);
        GlobalTypes.Databases.Builder rBuilder = GlobalTypes.Databases.newBuilder();
        Map<String, DatabaseProxy> databases = this.dbs.getDatabases();
        for (Map.Entry<String, DatabaseProxy> e : databases.entrySet()) {
            rBuilder.addDatabase(GlobalTypes.Database.newBuilder().setDatabaseName(e.getKey()).setDatabaseId(e.getValue().getLSMDB().getDatabaseId()).build());
        }
        rq.sendSuccess((Message)rBuilder.build());
    }
}

