/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.transmission.ErrorCode;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class LookupOperation
extends Operation {
    private final BabuDBInterface dbs;

    public LookupOperation(BabuDBInterface dbs) {
        this.dbs = dbs;
    }

    @Override
    public int getProcedureId() {
        return 5;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.Lookup.getDefaultInstance();
    }

    @Override
    public void processRequest(final Request rq) {
        GlobalTypes.Lookup req = (GlobalTypes.Lookup)rq.getRequestMessage();
        byte[] key = rq.getData().array();
        Logging.logMessage((int)7, (Object)this, (String)"LookupOperation:db %s, index %d, key %s.", (Object[])new Object[]{req.getDatabaseName(), req.getIndexId(), new String(key)});
        try {
            this.dbs.getDatabase(req.getDatabaseName()).lookupNonblocking(req.getIndexId(), key, null).registerListener((DatabaseRequestListener)new DatabaseRequestListener<byte[]>(){

                public void finished(byte[] result, Object context) {
                    rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance(), result == null ? null : ReusableBuffer.wrap((byte[])result));
                }

                public void failed(BabuDBException error, Object context) {
                    rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.newBuilder().setErrorCode(ErrorCode.mapUserError(error)).build());
                }
            });
        }
        catch (BabuDBException e) {
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.newBuilder().setErrorCode(ErrorCode.mapUserError(e)).build());
        }
    }
}

