/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy.operations;

import com.google.protobuf.Message;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.pbrpc.Common;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.transmission.ErrorCode;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.logging.Logging;

public class MakePersistentOperation
extends Operation {
    private final BabuDBInterface dbs;

    public MakePersistentOperation(BabuDBInterface dbs) {
        this.dbs = dbs;
    }

    @Override
    public int getProcedureId() {
        return 1;
    }

    @Override
    public Message getDefaultRequest() {
        return Common.emptyRequest.getDefaultInstance();
    }

    @Override
    public void processRequest(final Request rq) {
        Logging.logMessage((int)7, (Object)this, (String)"MakePersistentOperation", (Object[])new Object[0]);
        try {
            BabuDBRequestResultImpl<Object> result = this.dbs.createRequestFuture();
            this.dbs.getTransactionManager().makePersistentNonBlocking(rq.getData().createViewBuffer(), result);
            result.registerListener((DatabaseRequestListener)new DatabaseRequestListener<Object>(){

                public void finished(Object result, Object context) {
                    int dbId = -1;
                    String dbName = "\u0000";
                    if (result instanceof Object[] && ((Object[])result).length > 0 && ((Object[])result)[0] != null && ((Object[])result)[0] instanceof DatabaseInternal) {
                        DatabaseInternal dbInternal = (DatabaseInternal)((Object[])result)[0];
                        dbId = dbInternal.getLSMDB().getDatabaseId();
                        dbName = dbInternal.getName();
                    }
                    rq.sendSuccess((Message)GlobalTypes.Database.newBuilder().setDatabaseId(dbId).setDatabaseName(dbName).build());
                }

                public void failed(BabuDBException error, Object context) {
                    rq.sendSuccess((Message)GlobalTypes.Database.newBuilder().setErrorCode(ErrorCode.mapUserError(error)).setDatabaseId(-1).setDatabaseName("\u0000").build());
                }
            });
        }
        catch (BabuDBException error) {
            rq.sendSuccess((Message)GlobalTypes.Database.newBuilder().setErrorCode(ErrorCode.mapUserError(error)).setDatabaseId(-1).setDatabaseName("\u0000").build());
        }
    }
}

