/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.proxy.operations;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Map;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.transmission.ErrorCode;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class PrefixLookupOperation
extends Operation {
    private final BabuDBInterface dbs;

    public PrefixLookupOperation(BabuDBInterface dbs) {
        this.dbs = dbs;
    }

    @Override
    public int getProcedureId() {
        return 6;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.Lookup.getDefaultInstance();
    }

    @Override
    public void processRequest(final Request rq) {
        GlobalTypes.Lookup req = (GlobalTypes.Lookup)rq.getRequestMessage();
        ReusableBuffer data = rq.getData();
        byte[] key = data != null ? data.array() : null;
        Logging.logMessage((int)7, (Object)this, (String)"PrefixLookupOperation:db %s, index %d, key %s.", (Object[])new Object[]{req.getDatabaseName(), req.getIndexId(), key == null ? "null" : new String(key)});
        try {
            this.dbs.getDatabase(req.getDatabaseName()).prefixLookupNonblocking(req.getIndexId(), key, null).registerListener((DatabaseRequestListener)new DatabaseRequestListener<ResultSet<byte[], byte[]>>(){

                public void finished(ResultSet<byte[], byte[]> result, Object context) {
                    GlobalTypes.EntryMap.Builder r = GlobalTypes.EntryMap.newBuilder();
                    int size = 0;
                    ArrayList<Map.Entry> tmp = new ArrayList<Map.Entry>();
                    while (result.hasNext()) {
                        Map.Entry entry = (Map.Entry)result.next();
                        size += ((byte[])entry.getKey()).length + ((byte[])entry.getValue()).length;
                        tmp.add(entry);
                    }
                    result.free();
                    ReusableBuffer data = BufferPool.allocate((int)size);
                    for (Map.Entry entry : tmp) {
                        r.addLength(((byte[])entry.getKey()).length);
                        r.addLength(((byte[])entry.getValue()).length);
                        data.put((byte[])entry.getKey());
                        data.put((byte[])entry.getValue());
                    }
                    data.flip();
                    rq.sendSuccess((Message)r.build(), data);
                }

                public void failed(BabuDBException error, Object context) {
                    rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.newBuilder().setErrorCode(ErrorCode.mapUserError(error)).build());
                }
            });
        }
        catch (BabuDBException e) {
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.newBuilder().setErrorCode(ErrorCode.mapUserError(e)).build());
        }
    }
}

