/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.service.Pacemaker;
import org.xtreemfs.babudb.replication.service.accounting.ParticipantsOverview;
import org.xtreemfs.babudb.replication.service.clients.ClientResponseFuture;
import org.xtreemfs.babudb.replication.service.clients.ConditionClient;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.logging.Logging;

public class HeartbeatThread
extends LifeCycleThread
implements Pacemaker {
    public static final long MAX_DELAY_BETWEEN_HEARTBEATS = 5000L;
    private final ParticipantsOverview pOverview;
    private LSN latestLSN;
    private boolean hasInfarct = false;
    private volatile boolean quit = false;
    private final int localPort;
    private final ConcurrentMap<ConditionClient, Long> unavailableSlaves;

    public HeartbeatThread(ParticipantsOverview pOverview, int localPort) {
        super("HeartbeatThread");
        this.pOverview = pOverview;
        this.localPort = localPort;
        this.unavailableSlaves = new ConcurrentHashMap<ConditionClient, Long>();
    }

    @Override
    public synchronized void updateLSN(LSN lsn) {
        if (this.latestLSN.compareTo(lsn) < 0) {
            this.latestLSN = lsn;
            this.notify();
        }
    }

    public void start() {
        throw new UnsupportedOperationException("Use start(LSN initial) instead!");
    }

    public void start(LSN initial) {
        this.latestLSN = initial;
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block6: {
            this.quit = false;
            this.notifyStarted();
            try {
                while (!this.quit) {
                    this.processHeartbeat();
                    HeartbeatThread heartbeatThread = this;
                    synchronized (heartbeatThread) {
                        this.wait(5000L);
                        while (this.hasInfarct) {
                            this.wait();
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (this.quit) break block6;
                this.notifyCrashed(e);
            }
        }
        this.notifyStopped();
    }

    public boolean markSlaveAsAvailable(ConditionClient c) {
        return this.unavailableSlaves.remove(c) != null;
    }

    public boolean markSlaveAsUnavailable(ConditionClient c) {
        return this.unavailableSlaves.putIfAbsent(c, 0L) == null;
    }

    private void processHeartbeat() {
        for (final ConditionClient c : this.pOverview.getConditionClients()) {
            c.heartbeat(this.latestLSN, this.localPort).registerListener(new ClientResponseFuture.ClientResponseAvailableListener<Object>(){

                @Override
                public void responseAvailable(Object r) {
                    if (HeartbeatThread.this.markSlaveAsAvailable(c)) {
                        Logging.logMessage((int)6, (Object)this, (String)"Heartbeat was successfully sent to %s after previous failures.", (Object[])new Object[]{c.toString()});
                    } else {
                        Logging.logMessage((int)7, (Object)this, (String)"Heartbeat successfully send.", (Object[])new Object[0]);
                    }
                }

                @Override
                public void requestFailed(Exception e) {
                    if (HeartbeatThread.this.markSlaveAsUnavailable(c)) {
                        Logging.logMessage((int)6, (Object)this, (String)"Heartbeat could not be sent to %s, because %s. Further messages of these type will not be logged until the slave can be contacted again.", (Object[])new Object[]{c.toString(), e.getMessage()});
                    } else {
                        Logging.logMessage((int)7, (Object)this, (String)"Heartbeat could not be sent to %s, because %s", (Object[])new Object[]{c.toString(), e.getMessage()});
                    }
                    Logging.logError((int)7, (Object)this, (Throwable)e);
                }
            });
        }
    }

    @Override
    public synchronized void infarction() {
        this.hasInfarct = true;
    }

    @Override
    public synchronized boolean hasInfarct() {
        return this.hasInfarct;
    }

    @Override
    public synchronized void reanimate() {
        if (this.hasInfarct) {
            this.hasInfarct = false;
            this.unavailableSlaves.clear();
            this.notify();
        }
    }

    public void shutdown() {
        this.quit = true;
        this.interrupt();
    }
}

