/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service;

import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.control.ControlLayerInterface;
import org.xtreemfs.babudb.replication.service.RequestManagement;
import org.xtreemfs.babudb.replication.service.accounting.StatesManipulation;
import org.xtreemfs.babudb.replication.service.operations.ChunkOperation;
import org.xtreemfs.babudb.replication.service.operations.FleaseOperation;
import org.xtreemfs.babudb.replication.service.operations.HeartbeatOperation;
import org.xtreemfs.babudb.replication.service.operations.LoadOperation;
import org.xtreemfs.babudb.replication.service.operations.LocalTimeOperation;
import org.xtreemfs.babudb.replication.service.operations.ReplicaOperation;
import org.xtreemfs.babudb.replication.service.operations.ReplicateOperation;
import org.xtreemfs.babudb.replication.service.operations.StateOperation;
import org.xtreemfs.babudb.replication.service.operations.SynchronizeOperation;
import org.xtreemfs.babudb.replication.service.operations.VolatileStateOperation;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.RequestHandler;

public class ReplicationRequestHandler
extends RequestHandler {
    public ReplicationRequestHandler(StatesManipulation pStates, ControlLayerInterface ctrlLayer, BabuDBInterface babuDBI, RequestManagement reqMan, AtomicReference<LSN> lastOnView, int maxChunkSize, FileIOInterface fileIO, int maxQ) {
        super(maxQ);
        Operation op = new LocalTimeOperation();
        this.operations.put(op.getProcedureId(), op);
        op = new FleaseOperation(ctrlLayer);
        this.operations.put(op.getProcedureId(), op);
        op = new StateOperation(babuDBI, ctrlLayer);
        this.operations.put(op.getProcedureId(), op);
        op = new VolatileStateOperation(babuDBI);
        this.operations.put(op.getProcedureId(), op);
        op = new HeartbeatOperation(pStates);
        this.operations.put(op.getProcedureId(), op);
        op = new SynchronizeOperation(reqMan, ctrlLayer);
        this.operations.put(op.getProcedureId(), op);
        op = new ReplicateOperation(reqMan);
        this.operations.put(op.getProcedureId(), op);
        op = new ReplicaOperation(lastOnView, babuDBI, fileIO);
        this.operations.put(op.getProcedureId(), op);
        op = new LoadOperation(lastOnView, maxChunkSize, babuDBI, fileIO);
        this.operations.put(op.getProcedureId(), op);
        op = new ChunkOperation();
        this.operations.put(op.getProcedureId(), op);
    }

    @Override
    public int getInterfaceID() {
        return 20001;
    }
}

