/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.log.SyncListener;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.LockableService;
import org.xtreemfs.babudb.replication.control.ControlLayerInterface;
import org.xtreemfs.babudb.replication.service.Pacemaker;
import org.xtreemfs.babudb.replication.service.RequestManagement;
import org.xtreemfs.babudb.replication.service.SlaveView;
import org.xtreemfs.babudb.replication.service.StageRequest;
import org.xtreemfs.babudb.replication.service.logic.BasicLogic;
import org.xtreemfs.babudb.replication.service.logic.LoadLogic;
import org.xtreemfs.babudb.replication.service.logic.Logic;
import org.xtreemfs.babudb.replication.service.logic.RequestLogic;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.logging.Logging;

public class ReplicationStage
extends LifeCycleThread
implements RequestManagement,
LockableService {
    private static final int RETRY_DELAY_MS = 500;
    public final AtomicReference<LSN> lastOnView;
    private Queue<StageRequest> q = new PriorityQueue<StageRequest>();
    private volatile boolean quit;
    private final int MAX_Q;
    private boolean locked = false;
    private final Map<Logic.LogicID, Logic> logics;
    private SyncListener syncListener = null;
    private final Pacemaker pacemaker;
    private final BabuDBInterface babudb;
    private StageCondition operatingCondition = StageCondition.DEFAULT;

    public ReplicationStage(int max_q, Pacemaker pacemaker, SlaveView slaveView, FileIOInterface fileIO, BabuDBInterface babuInterface, AtomicReference<LSN> lastOnView, int maxChunkSize) {
        super("ReplicationStage");
        this.babudb = babuInterface;
        this.lastOnView = lastOnView;
        this.pacemaker = pacemaker;
        this.MAX_Q = max_q;
        this.logics = new HashMap<Logic.LogicID, Logic>();
        Logic lg = new BasicLogic(babuInterface, slaveView, fileIO, lastOnView, pacemaker);
        this.logics.put(lg.getId(), lg);
        lg = new RequestLogic(babuInterface, slaveView, fileIO, lastOnView);
        this.logics.put(lg.getId(), lg);
        lg = new LoadLogic(babuInterface, slaveView, fileIO, maxChunkSize, lastOnView);
        this.logics.put(lg.getId(), lg);
    }

    public synchronized void start() {
        this.quit = false;
        super.start();
    }

    public synchronized void shutdown() {
        this.quit = true;
        this.interrupt();
    }

    @Override
    public synchronized void enqueueOperation(Object[] args) throws BusyServerException {
        if (this.MAX_Q != 0 && this.q.size() + 1 > this.MAX_Q || this.quit) {
            throw new BusyServerException(this.getName() + ": Operation could not be performed.");
        }
        this.q.add(new StageRequest(args));
        if (this.q.size() == 1) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int tries = 0;
        this.notifyStarted();
        while (!this.quit) {
            try {
                StageCondition currentCondition;
                if (tries != 0) {
                    Thread.sleep(500 * tries);
                }
                StageRequest rq = null;
                ReplicationStage replicationStage = this;
                synchronized (replicationStage) {
                    while (this.operatingCondition.equals(StageCondition.DEFAULT) && this.q.isEmpty() || this.locked && this.operatingCondition.equals(StageCondition.LOCKED)) {
                        if (this.syncListener != null) {
                            this.syncListener.synced(this.babudb.getState());
                            this.syncListener = null;
                        }
                        this.wait();
                    }
                    currentCondition = this.operatingCondition;
                    if (this.locked && currentCondition.equals(StageCondition.DEFAULT)) {
                        currentCondition = StageCondition.LOCKED;
                        Thread.sleep(500L);
                    } else if (currentCondition.equals(StageCondition.DEFAULT)) {
                        rq = this.q.poll();
                        assert (rq != null);
                    }
                }
                currentCondition = this.process(currentCondition, rq);
                replicationStage = this;
                synchronized (replicationStage) {
                    if (!currentCondition.equals(StageCondition.LOCKED) && !currentCondition.equals(StageCondition.DEFAULT) && currentCondition.equals(this.operatingCondition)) {
                        if (++tries < 3) {
                            if (this.syncListener != null) {
                                this.syncListener.failed((Exception)((Object)new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, "Synchronization was canceled after 3 retries.")));
                                this.syncListener = null;
                            }
                            this.clearQueue();
                            this.operatingCondition = StageCondition.DEFAULT;
                        }
                    } else {
                        tries = 0;
                        this.operatingCondition = currentCondition;
                    }
                }
            }
            catch (InterruptedException ie) {
                if (this.quit) continue;
                this.clearQueue();
                this.notifyCrashed(ie);
                return;
            }
        }
        this.clearQueue();
        this.notifyStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StageCondition process(StageCondition current, StageRequest rq) throws InterruptedException {
        StageCondition result;
        if (current.equals(StageCondition.LOCKED)) {
            result = current;
        } else if (current.equals(StageCondition.DEFAULT)) {
            assert (rq != null);
            if (this.pacemaker.hasInfarct()) {
                this.pacemaker.updateLSN(this.babudb.getState());
                this.pacemaker.reanimate();
            }
            if (!(result = this.logics.get((Object)Logic.LogicID.BASIC).run(rq)).equals(StageCondition.DEFAULT)) {
                ReplicationStage replicationStage = this;
                synchronized (replicationStage) {
                    this.q.add(rq);
                }
            }
        } else {
            assert (rq == null);
            this.pacemaker.infarction();
            result = this.logics.get((Object)current.logicID).run(current);
        }
        return result;
    }

    public synchronized void manualLoad(SyncListener syncListener, LSN end) {
        LSN start = this.babudb.getState();
        if (start.equals((Object)end)) {
            syncListener.synced(end);
        } else {
            if (this.syncListener != null) {
                this.syncListener.failed((Exception)new InterruptedException("Listener was replaced due a new synchronization-request."));
            }
            this.syncListener = syncListener;
            StageCondition old = this.operatingCondition;
            this.operatingCondition = start.compareTo(end) < 0 ? new StageCondition(end) : new StageCondition(Logic.LogicID.LOAD, end);
            if (old.equals(StageCondition.DEFAULT) && this.q.isEmpty() || this.locked && old.equals(StageCondition.LOCKED)) {
                this.notify();
            }
        }
    }

    @Override
    public void createStableState(final LSN lastLSNOnView, final InetSocketAddress master, final ControlLayerInterface control) throws InterruptedException {
        if (this.lastOnView.get().equals((Object)lastLSNOnView)) {
            try {
                if (lastLSNOnView.getSequenceNo() != 0L) {
                    this.lastOnView.set(this.babudb.checkpoint());
                    this.pacemaker.updateLSN(this.babudb.getState());
                }
            }
            catch (BabuDBException e) {
                assert (e.getErrorCode() == BabuDBException.ErrorCode.INTERRUPTED);
                this.notifyCrashed(e);
            }
        } else {
            this.manualLoad(new SyncListener(){

                public void synced(LSN lsn) {
                    try {
                        if (lastLSNOnView.getSequenceNo() != 0L) {
                            ReplicationStage.this.lastOnView.set(ReplicationStage.this.babudb.checkpoint());
                            ReplicationStage.this.pacemaker.updateLSN(ReplicationStage.this.babudb.getState());
                        }
                    }
                    catch (BabuDBException e) {
                        assert (e.getErrorCode() == BabuDBException.ErrorCode.INTERRUPTED);
                        ReplicationStage.this.notifyCrashed(e);
                    }
                }

                public void failed(Exception ex) {
                    Logging.logMessage((int)4, (Object)this, (String)"Service could not establish a stable state as requested by the master (%s) @LSN(%s), because %s.", (Object[])new Object[]{master.toString(), lastLSNOnView.toString(), ex.toString()});
                    Logging.logError((int)6, (Object)this, (Throwable)ex);
                    if (!(ex instanceof InterruptedException)) {
                        try {
                            if (master.equals(control.getLeaseHolder(1))) {
                                ReplicationStage.this.createStableState(lastLSNOnView, master, control);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }, lastLSNOnView);
        }
    }

    @Override
    public synchronized void lock() throws InterruptedException {
        if (!this.locked) {
            this.locked = true;
            this.logics.get((Object)Logic.LogicID.BASIC).waitForSteadyState();
        }
    }

    @Override
    public synchronized void unlock() {
        if (this.locked) {
            this.locked = false;
            if (this.operatingCondition.equals(StageCondition.LOCKED)) {
                this.operatingCondition = StageCondition.DEFAULT;
                this.notify();
            }
        }
    }

    private void clearQueue() {
        StageRequest rq = this.q.poll();
        while (rq != null) {
            rq.free();
            rq = this.q.poll();
        }
    }

    public static final class StageCondition {
        public static final StageCondition DEFAULT = new StageCondition(Logic.LogicID.BASIC, null);
        public static final StageCondition LOAD_LOOPHOLE = new StageCondition(Logic.LogicID.LOAD, null);
        public static final StageCondition LOCKED = null;
        public final LSN end;
        public final Logic.LogicID logicID;

        public StageCondition(LSN end) {
            this(Logic.LogicID.REQUEST, end);
        }

        public StageCondition(Logic.LogicID logicID, LSN end) {
            assert (logicID != null);
            this.logicID = logicID;
            this.end = end;
        }
    }

    public static final class BusyServerException
    extends Exception {
        private static final long serialVersionUID = 2823332601654877350L;

        public BusyServerException(String string) {
            super("Participant is too busy at the moment: " + string);
        }
    }
}

