/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.config.ReplicationConfig;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.log.SyncListener;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.FleaseMessageReceiver;
import org.xtreemfs.babudb.replication.Layer;
import org.xtreemfs.babudb.replication.control.ControlLayerInterface;
import org.xtreemfs.babudb.replication.proxy.ProxyRequestHandler;
import org.xtreemfs.babudb.replication.service.HeartbeatThread;
import org.xtreemfs.babudb.replication.service.ReplicationRequestHandler;
import org.xtreemfs.babudb.replication.service.ReplicationStage;
import org.xtreemfs.babudb.replication.service.ServiceToControlInterface;
import org.xtreemfs.babudb.replication.service.SlaveView;
import org.xtreemfs.babudb.replication.service.accounting.LatestLSNUpdateListener;
import org.xtreemfs.babudb.replication.service.accounting.ParticipantsOverview;
import org.xtreemfs.babudb.replication.service.accounting.ParticipantsStates;
import org.xtreemfs.babudb.replication.service.accounting.ReplicateResponse;
import org.xtreemfs.babudb.replication.service.clients.ClientInterface;
import org.xtreemfs.babudb.replication.service.clients.ClientResponseFuture;
import org.xtreemfs.babudb.replication.service.clients.ConditionClient;
import org.xtreemfs.babudb.replication.service.clients.MasterClient;
import org.xtreemfs.babudb.replication.service.clients.SlaveClient;
import org.xtreemfs.babudb.replication.transmission.TransmissionToServiceInterface;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class ServiceLayer
extends Layer
implements ServiceToControlInterface,
SlaveView {
    private final ParticipantsStates participantsStates;
    private final HeartbeatThread heartbeatThread;
    private final ReplicationStage replicationStage;
    private final AtomicReference<LSN> lastOnView = new AtomicReference();
    private final BabuDBInterface babuDB;
    private final TransmissionToServiceInterface transmissionInterface;
    private final AtomicReference<CRC32> checksum = new AtomicReference<CRC32>(new CRC32());
    private final ReplicationConfig config;

    public ServiceLayer(ReplicationConfig config, BabuDBInterface babuDB, TransmissionToServiceInterface transLayer) throws IOException {
        this.config = config;
        this.transmissionInterface = transLayer;
        this.babuDB = babuDB;
        try {
            this.participantsStates = new ParticipantsStates(config.getSyncN(), config.getParticipants(), transLayer);
        }
        catch (ParticipantsStates.UnknownParticipantException e) {
            throw new IOException("The address of at least one participant could not have been resolved, because: " + e.getMessage());
        }
        this.heartbeatThread = new HeartbeatThread(this.participantsStates, config.getPort());
        this.replicationStage = new ReplicationStage(config.getBabuDBConfig().getMaxQueueLength(), this.heartbeatThread, this, transLayer.getFileIOInterface(), babuDB, this.lastOnView, config.getChunkSize());
    }

    public <T extends ControlLayerInterface & FleaseMessageReceiver> void init(T receiver) {
        assert (receiver != null);
        this.transmissionInterface.addRequestHandler(new ProxyRequestHandler(this.babuDB, this.config.getBabuDBConfig().getMaxQueueLength(), receiver));
        this.transmissionInterface.addRequestHandler(new ReplicationRequestHandler(this.participantsStates, receiver, this.babuDB, this.replicationStage, this.lastOnView, this.config.getChunkSize(), this.transmissionInterface.getFileIOInterface(), this.config.getBabuDBConfig().getMaxQueueLength()));
        receiver.registerReplicationControl(this.replicationStage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicateResponse replicate(LogEntry le) {
        List<SlaveClient> slaves;
        this.heartbeatThread.updateLSN(le.getLSN());
        try {
            slaves = this.participantsStates.getAvailableParticipants();
        }
        catch (Exception e) {
            return new ReplicateResponse(le, e);
        }
        final ReplicateResponse result = new ReplicateResponse(le, slaves.size() - this.participantsStates.getLocalSyncN());
        if (slaves.size() == 0) {
            Logging.logMessage((int)7, (Object)this, (String)"There are no slaves available anymore! BabuDB runs if it would be in non-replicated mode.", (Object[])new Object[0]);
        } else {
            ReusableBuffer payload = null;
            AtomicReference<CRC32> atomicReference = this.checksum;
            synchronized (atomicReference) {
                CRC32 csumAlgo = this.checksum.get();
                try {
                    payload = le.serialize((Checksum)csumAlgo);
                }
                finally {
                    csumAlgo.reset();
                }
            }
            for (final SlaveClient slave : slaves) {
                slave.replicate(le.getLSN(), payload.createViewBuffer()).registerListener(new ClientResponseFuture.ClientResponseAvailableListener<Object>(){

                    @Override
                    public void responseAvailable(Object r) {
                        ServiceLayer.this.participantsStates.requestFinished(slave);
                    }

                    @Override
                    public void requestFailed(Exception e) {
                        ServiceLayer.this.participantsStates.markAsDead(slave);
                        result.decrementPermittedFailures();
                        Logging.logMessage((int)6, (Object)this, (String)"'%s' was marked as dead, because %s", (Object[])new Object[]{slave.getDefaultServerAddress().toString(), e.getMessage()});
                        if (e.getMessage() == null) {
                            Logging.logError((int)6, (Object)this, (Throwable)e);
                        }
                    }
                });
            }
            BufferPool.free((ReusableBuffer)payload);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(SyncListener listener, int port) throws BabuDBException, InterruptedException, IOException {
        this.replicationStage.lock();
        LSN localState = this.babuDB.getState();
        this.replicationStage.unlock();
        int localSyncN = this.participantsStates.getLocalSyncN();
        List<ConditionClient> slaves = this.participantsStates.getConditionClients();
        LSN latest = localState;
        if (localSyncN > 0) {
            Map<ClientInterface, LSN> states = this.getStates(slaves, true);
            if (states.size() < localSyncN) {
                throw new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, "Not enough slaves available to synchronize with!");
            }
            LinkedList<LSN> values = new LinkedList<LSN>(states.values());
            Collections.sort(values, Collections.reverseOrder());
            latest = (LSN)values.get(0);
            if (localState.compareTo(latest) < 0) {
                for (Map.Entry<ClientInterface, LSN> entry : states.entrySet()) {
                    if (!entry.getValue().equals((Object)latest)) continue;
                    Logging.logMessage((int)6, (Object)this, (String)"Starting synchronization from '%s' to '%s'.", (Object[])new Object[]{localState.toString(), latest.toString()});
                    final AtomicBoolean ready = new AtomicBoolean(false);
                    final AtomicReference<Object> exception = new AtomicReference<Object>(null);
                    this.replicationStage.manualLoad(new SyncListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void synced(LSN lsn) {
                            Logging.logMessage((int)7, (Object)this, (String)"Synchronization finished @LSN(%s).", (Object[])new Object[]{lsn.toString()});
                            AtomicBoolean atomicBoolean = ready;
                            synchronized (atomicBoolean) {
                                if (ready.compareAndSet(false, true)) {
                                    ready.notify();
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void failed(Exception ex) {
                            exception.set(new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, "Loading a state manually failed, because" + ex.getMessage(), (Throwable)ex));
                            AtomicBoolean atomicBoolean = ready;
                            synchronized (atomicBoolean) {
                                if (ready.compareAndSet(false, true)) {
                                    ready.notify();
                                }
                            }
                        }
                    }, latest);
                    AtomicBoolean atomicBoolean = ready;
                    synchronized (atomicBoolean) {
                        while (!ready.get()) {
                            ready.wait();
                        }
                    }
                    if (exception.get() != null) {
                        throw (BabuDBException)exception.get();
                    }
                    assert (latest.equals((Object)this.babuDB.getState())) : "Synchronization failed: (expected=" + latest.toString() + ") != (acknowledged=" + this.babuDB.getState() + ")";
                    break;
                }
            }
        } else {
            latest = localState;
        }
        LSN beforeCP = latest;
        if (latest.getSequenceNo() > 0L) {
            Logging.logMessage((int)7, (Object)this, (String)"taking a checkpoint", (Object[])new Object[0]);
            beforeCP = this.babuDB.checkpoint();
            this.lastOnView.set(beforeCP);
        }
        Logging.logMessage((int)6, (Object)this, (String)"Agreed to synchronize to %s before the next view.", (Object[])new Object[]{beforeCP.toString()});
        LSN syncState = this.babuDB.getState();
        final ReplicateResponse result = new ReplicateResponse(syncState, listener, slaves.size() - localSyncN);
        this.subscribeListener(result);
        for (ConditionClient slave : slaves) {
            slave.synchronize(beforeCP, port).registerListener(new ClientResponseFuture.ClientResponseAvailableListener<Object>(){

                @Override
                public void responseAvailable(Object r) {
                }

                @Override
                public void requestFailed(Exception e) {
                    result.decrementPermittedFailures();
                }
            });
        }
        Logging.logMessage((int)6, (Object)this, (String)"The next view will start with %s.", (Object[])new Object[]{syncState.toString()});
    }

    @Override
    public MasterClient getSynchronizationPartner(LSN progressAtLeast) {
        List<ConditionClient> servers = this.participantsStates.getConditionClients();
        if (servers.size() > 0) {
            Map<ClientInterface, LSN> states = this.getStates(servers, false);
            for (Map.Entry<ClientInterface, LSN> e : states.entrySet()) {
                if (e.getValue().compareTo(progressAtLeast) < 0) continue;
                return (MasterClient)e.getKey();
            }
        } else {
            return null;
        }
        return (MasterClient)servers.get(0);
    }

    @Override
    public ParticipantsOverview getParticipantOverview() {
        return this.participantsStates;
    }

    @Override
    public void reset() {
        this.participantsStates.reset();
    }

    @Override
    public void _setLifeCycleListener(LifeCycleListener listener) {
        this.heartbeatThread.setLifeCycleListener(listener);
        this.replicationStage.setLifeCycleListener(listener);
    }

    public void start(ControlLayerInterface topLayer) {
        LSN latest = this.babuDB.getState();
        LSN normalized = latest.getSequenceNo() == 0L ? new LSN(0, 0L) : latest;
        Logging.logMessage((int)7, (Object)this, (String)"Setting last on view LSN to '%s', initial was '%s'.", (Object[])new Object[]{normalized, latest});
        this.lastOnView.set(normalized);
        try {
            this.replicationStage.start();
            this.heartbeatThread.start(latest);
            this.heartbeatThread.waitForStartup();
            this.replicationStage.waitForStartup();
        }
        catch (Throwable e) {
            this.listener.crashPerformed(e);
        }
    }

    @Override
    public void asyncShutdown() {
        this.heartbeatThread.shutdown();
        this.replicationStage.shutdown();
    }

    @Override
    public void shutdown() {
        this.heartbeatThread.shutdown();
        this.replicationStage.shutdown();
        try {
            this.heartbeatThread.waitForShutdown();
            this.replicationStage.waitForShutdown();
        }
        catch (Throwable e) {
            this.listener.crashPerformed(e);
        }
    }

    @Override
    public void subscribeListener(LatestLSNUpdateListener rp) {
        this.participantsStates.subscribeListener(rp);
    }

    private Map<ClientInterface, LSN> getStates(List<ConditionClient> clients, boolean hard) {
        HashMap<ClientInterface, LSN> result = new HashMap<ClientInterface, LSN>();
        int numRqs = clients.size();
        if (numRqs == 0) {
            return result;
        }
        ArrayList<ClientResponseFuture<LSN, GlobalTypes.LSN>> rps = new ArrayList<ClientResponseFuture<LSN, GlobalTypes.LSN>>(numRqs);
        if (numRqs > 0) {
            int i;
            for (i = 0; i < numRqs; ++i) {
                if (hard) {
                    rps.add(i, clients.get(i).state());
                    continue;
                }
                rps.add(i, clients.get(i).volatileState());
            }
            for (i = 0; i < numRqs; ++i) {
                try {
                    LSN val = (LSN)((ClientResponseFuture)rps.get(i)).get();
                    result.put(clients.get(i), val);
                    continue;
                }
                catch (Exception e) {
                    Logging.logMessage((int)6, (Object)this, (String)"Could not receive state of '%s', because: %s.", (Object[])new Object[]{clients.get(i), e.getMessage()});
                    if (e.getMessage() != null) continue;
                    Logging.logError((int)6, (Object)this, (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException("Use start(LockableService userService) instead!");
    }
}

