/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.accounting;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.service.accounting.LatestLSNUpdateListener;
import org.xtreemfs.babudb.replication.service.accounting.ParticipantsOverview;
import org.xtreemfs.babudb.replication.service.accounting.StatesManipulation;
import org.xtreemfs.babudb.replication.service.clients.ClientInterface;
import org.xtreemfs.babudb.replication.service.clients.ConditionClient;
import org.xtreemfs.babudb.replication.service.clients.SlaveClient;
import org.xtreemfs.babudb.replication.transmission.client.ClientFactory;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;

public class ParticipantsStates
implements ParticipantsOverview,
StatesManipulation {
    private static final long DELAY_TILL_DEAD = 10000L;
    private static final int MAX_OPEN_REQUESTS_PRO_SERVER = 20;
    private static final long DELAY_TILL_REFUSE = 5000L;
    private final Map<String, State> stateTable = new HashMap<String, State>();
    private final PriorityBlockingQueue<LatestLSNUpdateListener> listeners = new PriorityBlockingQueue();
    private final int syncN;
    private final int participantsCount;
    private int availableSlaves;
    private int deadSlaves;
    private volatile LSN latestCommon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParticipantsStates(int syncN, Set<InetSocketAddress> participants, ClientFactory clientFactory) throws UnknownParticipantException {
        assert (participants != null);
        this.latestCommon = new LSN(0, 0L);
        this.syncN = syncN > 0 ? syncN - 1 : syncN;
        this.participantsCount = this.availableSlaves = participants.size();
        this.deadSlaves = 0;
        Map<String, State> map = this.stateTable;
        synchronized (map) {
            long timeStamp = TimeSync.getGlobalTime();
            for (InetSocketAddress participant : participants) {
                this.stateTable.put(this.getUID(participant), new State(clientFactory.getClient(participant), timeStamp));
            }
            Logging.logMessage((int)7, (Object)this, (String)"Initial configuration:\n%s", (Object[])new Object[]{this.toString()});
        }
    }

    public int getLocalSyncN() {
        return this.syncN;
    }

    public LSN getLatestCommon() {
        return this.latestCommon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SlaveClient> getAvailableParticipants() throws NotEnoughAvailableParticipantsException, InterruptedException {
        LinkedList<SlaveClient> result = new LinkedList<SlaveClient>();
        Map<String, State> map = this.stateTable;
        synchronized (map) {
            while (this.availableSlaves < this.syncN && this.participantsCount - this.deadSlaves >= this.syncN) {
                this.stateTable.wait(5000L);
            }
            long time = TimeSync.getGlobalTime();
            if (this.participantsCount - this.deadSlaves >= this.syncN) {
                for (State s : this.stateTable.values()) {
                    if (s.dead) continue;
                    if (time > s.lastUpdate + 10000L) {
                        Logging.logMessage((int)7, (Object)this, (String)"%s will be marked as dead!\n%s", (Object[])new Object[]{s.client.getDefaultServerAddress().toString(), this.toString()});
                        s.dead = true;
                        s.lastUpdate = 0L;
                        s.openRequests = 0;
                        s.lastAcknowledged = new LSN(0, 0L);
                        --this.availableSlaves;
                        continue;
                    }
                    if (s.openRequests >= 20) continue;
                    ++s.openRequests;
                    if (s.openRequests == 20) {
                        --this.availableSlaves;
                    }
                    result.add(s.client);
                }
            }
            if (result.size() < this.syncN) {
                for (SlaveClient c : result) {
                    try {
                        State s = this.stateTable.get(this.getUID(c.getDefaultServerAddress()));
                        if (s.openRequests == 20) {
                            ++this.availableSlaves;
                        }
                        --s.openRequests;
                    }
                    catch (UnknownParticipantException e) {
                        Logging.logMessage((int)1, (Object)this, (String)"An open request could not have been withdrawn, because it's address could not have been resolved anymore!", (Object[])new Object[0]);
                        Logging.logError((int)3, (Object)this, (Throwable)e);
                    }
                }
                throw new NotEnoughAvailableParticipantsException("With only '" + result.size() + "' are there not enough " + "slaves to perform the request.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeListener(LatestLSNUpdateListener listener) {
        if (this.syncN == 0) {
            this.latestCommon = listener.lsn;
            listener.upToDate();
        } else {
            Map<String, State> map = this.stateTable;
            synchronized (map) {
                if (this.latestCommon.compareTo(listener.lsn) >= 0) {
                    listener.upToDate();
                    return;
                }
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(InetSocketAddress participant, LSN acknowledgedLSN, long receiveTime) throws UnknownParticipantException {
        Logging.logMessage((int)7, (Object)this, (String)"participant %s acknowledged %s", (Object[])new Object[]{participant.toString(), acknowledgedLSN.toString()});
        Map<String, State> map = this.stateTable;
        synchronized (map) {
            State old = this.stateTable.get(this.getUID(participant));
            if (old != null) {
                old.lastUpdate = receiveTime;
                if (old.dead) {
                    --this.deadSlaves;
                    ++this.availableSlaves;
                    old.dead = false;
                    Logging.logMessage((int)7, (Object)this, (String)"%s has been marked as alive!\n%s", (Object[])new Object[]{participant.toString(), this.toString()});
                }
                if (old.lastAcknowledged.compareTo(acknowledgedLSN) < 0) {
                    old.lastAcknowledged = acknowledgedLSN;
                    int count = 0;
                    for (State s : this.stateTable.values()) {
                        if (s.dead || s.lastAcknowledged.compareTo(acknowledgedLSN) < 0 || ++count < this.syncN) continue;
                        this.latestCommon = acknowledgedLSN;
                        break;
                    }
                }
            } else {
                Logging.logMessage((int)3, (Object)this, (String)"'%s' is not registered at this master. Request received: %d", (Object[])new Object[]{participant.toString(), receiveTime});
                throw new UnknownParticipantException("'" + participant.toString() + "' is not registered at this master. " + "Request received: " + receiveTime);
            }
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsDead(ClientInterface slave) {
        Map<String, State> map = this.stateTable;
        synchronized (map) {
            State s;
            try {
                s = this.stateTable.get(this.getUID(slave.getDefaultServerAddress()));
            }
            catch (UnknownParticipantException e) {
                Logging.logMessage((int)1, (Object)this, (String)"Request could not have been marked as failed, because it's address could not have been resolved anymore!", (Object[])new Object[0]);
                Logging.logError((int)3, (Object)this, (Throwable)e);
                return;
            }
            if (!s.dead) {
                Logging.logMessage((int)7, (Object)this, (String)"%s will be marked as dead!\n%s", (Object[])new Object[]{slave.getDefaultServerAddress().toString(), this.toString()});
                s.dead = true;
                s.lastUpdate = 0L;
                s.openRequests = 0;
                s.lastAcknowledged = new LSN(0, 0L);
                ++this.deadSlaves;
                --this.availableSlaves;
                this.stateTable.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFinished(SlaveClient slave) {
        Map<String, State> map = this.stateTable;
        synchronized (map) {
            State s;
            try {
                s = this.stateTable.get(this.getUID(slave.getDefaultServerAddress()));
            }
            catch (UnknownParticipantException e) {
                Logging.logMessage((int)1, (Object)this, (String)"Request could not have been marked as finished, because it's address could not have been resolved anymore!", (Object[])new Object[0]);
                Logging.logError((int)3, (Object)this, (Throwable)e);
                return;
            }
            if (s.openRequests > 0) {
                --s.openRequests;
            }
            if (s.openRequests == 19) {
                ++this.availableSlaves;
                this.stateTable.notify();
            }
        }
    }

    @Override
    public List<ConditionClient> getConditionClients() {
        ArrayList<ConditionClient> result = new ArrayList<ConditionClient>();
        ArrayList<State> states = new ArrayList<State>(this.stateTable.values());
        Collections.sort(states);
        Collections.reverse(states);
        for (State s : states) {
            result.add(s.client);
        }
        return result;
    }

    @Override
    public ConditionClient getByAddress(InetSocketAddress address) throws UnknownParticipantException {
        if (this.stateTable.get(this.getUID(address)) == null) {
            throw new UnknownParticipantException("Server " + address.getHostName() + " is not a valid replication participant.");
        }
        return this.stateTable.get((Object)this.getUID((InetSocketAddress)address)).client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, State> map = this.stateTable;
        synchronized (map) {
            String result = "ParticipantsStates: participants=" + this.participantsCount + " - available=" + this.availableSlaves + "|dead=" + this.deadSlaves + "\n";
            for (Map.Entry<String, State> e : this.stateTable.entrySet()) {
                result = result + e.getKey().toString() + ": " + e.getValue().toString() + "\n";
            }
            return result;
        }
    }

    private void notifyListeners() {
        LatestLSNUpdateListener listener = this.listeners.poll();
        while (listener != null && listener.lsn.compareTo(this.latestCommon) <= 0) {
            listener.upToDate();
            listener = this.listeners.poll();
        }
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashSet lSet = new HashSet();
        this.listeners.drainTo(lSet);
        for (LatestLSNUpdateListener l : lSet) {
            l.failed();
        }
        Map<String, State> map = this.stateTable;
        synchronized (map) {
            long timeStamp = TimeSync.getGlobalTime();
            for (State s : this.stateTable.values()) {
                s.reset(timeStamp);
            }
        }
    }

    private String getUID(InetSocketAddress address) throws UnknownParticipantException {
        InetAddress hostAddress;
        assert (address != null);
        if (address.getAddress() == null) {
            try {
                hostAddress = InetAddress.getByName(address.getHostName());
            }
            catch (UnknownHostException uh) {
                throw new UnknownParticipantException("the address of '" + address.toString() + "' could not have been determined.");
            }
        } else {
            hostAddress = address.getAddress();
        }
        String hostAddressString = hostAddress instanceof Inet4Address ? "::ffff:" + hostAddress.getHostAddress() : hostAddress.getHostAddress();
        return hostAddressString + ":" + address.getPort();
    }

    public static class NotEnoughAvailableParticipantsException
    extends Exception {
        private static final long serialVersionUID = 5521213821006794885L;

        public NotEnoughAvailableParticipantsException(String string) {
            super(string);
        }
    }

    public static class UnknownParticipantException
    extends Exception {
        private static final long serialVersionUID = -2709960657015326930L;

        public UnknownParticipantException(String string) {
            super(string);
        }
    }

    private static final class State
    implements Comparable<State> {
        long lastUpdate;
        boolean dead;
        LSN lastAcknowledged;
        int openRequests;
        final ReplicationClientAdapter client;

        State(ReplicationClientAdapter client, long timeStamp) {
            this.client = client;
            this.reset(timeStamp);
        }

        void reset(long time) {
            this.lastUpdate = time;
            this.dead = false;
            this.lastAcknowledged = new LSN(0, 0L);
            this.openRequests = 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof State && this.client.equals(((State)obj).client);
        }

        @Override
        public int compareTo(State o) {
            return this.lastAcknowledged.compareTo(o.lastAcknowledged);
        }

        public String toString() {
            return (this.dead ? "dead" : "alive") + " since '" + this.lastUpdate + "' with LSN (" + this.lastAcknowledged.toString() + ") and '" + this.openRequests + "' open requests;";
        }
    }
}

