/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.accounting;

import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.log.SyncListener;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.service.accounting.LatestLSNUpdateListener;

public final class ReplicateResponse
extends LatestLSNUpdateListener {
    private boolean finished = false;
    private int permittedFailures;
    private final SyncListener listener;

    public ReplicateResponse(LogEntry le, Exception error) {
        super(le.getLSN());
        this.finished = true;
        this.permittedFailures = -1;
        this.listener = le.getListener();
        this.listener.failed(error);
    }

    public ReplicateResponse(LSN lsn, SyncListener listener, Exception error) {
        super(lsn);
        this.finished = true;
        this.permittedFailures = -1;
        this.listener = listener;
        this.listener.failed(error);
    }

    public ReplicateResponse(LogEntry le, int slavesThatCanFail) {
        super(le.getLSN());
        this.listener = le.getListener();
        this.permittedFailures = slavesThatCanFail;
    }

    public ReplicateResponse(LSN lsn, SyncListener listener, int slavesThatCanFail) {
        super(lsn);
        this.listener = listener;
        this.permittedFailures = slavesThatCanFail;
    }

    public synchronized void decrementPermittedFailures() {
        if (this.permittedFailures == 0 && !this.finished) {
            this.finished = true;
            this.listener.failed((Exception)((Object)new BabuDBException(BabuDBException.ErrorCode.REPLICATION_FAILURE, "LogEntry could not be replicated!")));
        }
        --this.permittedFailures;
    }

    public synchronized boolean hasFailed() {
        return this.finished && this.permittedFailures < 0;
    }

    @Override
    public synchronized void upToDate() {
        if (!this.finished) {
            this.finished = true;
            this.listener.synced(this.lsn);
        }
    }

    @Override
    public synchronized void failed() {
        if (!this.finished) {
            this.finished = true;
            this.listener.failed(new Exception("Replication of LogEntry (" + this.lsn.toString() + ") failed!"));
        }
    }
}

