/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.clients;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;

public abstract class ClientResponseFuture<T, M extends Message> {
    private ClientResponseAvailableListener<T> listener = null;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private T result = null;
    private Exception error = null;

    public ClientResponseFuture(RPCResponse<M> rp) {
        rp.registerListener(new RPCResponseAvailableListener<M>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void responseAvailable(RPCResponse<M> rp) {
                AtomicBoolean atomicBoolean = ClientResponseFuture.this.finished;
                synchronized (atomicBoolean) {
                    if (ClientResponseFuture.this.finished.compareAndSet(false, true)) {
                        try {
                            ClientResponseFuture.this.result = ClientResponseFuture.this.resolve(rp.get(), rp.getData());
                            if (ClientResponseFuture.this.listener != null) {
                                ClientResponseFuture.this.listener.responseAvailable(ClientResponseFuture.this.result);
                            }
                        }
                        catch (Exception e) {
                            ClientResponseFuture.this.error = e;
                            if (ClientResponseFuture.this.listener != null) {
                                ClientResponseFuture.this.listener.requestFailed(ClientResponseFuture.this.error);
                            }
                        }
                        finally {
                            rp.freeBuffers();
                        }
                    }
                    ClientResponseFuture.this.finished.notifyAll();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get() throws Exception {
        AtomicBoolean atomicBoolean = this.finished;
        synchronized (atomicBoolean) {
            if (!this.finished.get()) {
                this.finished.wait();
            }
            if (this.error != null) {
                throw this.error;
            }
            return this.result;
        }
    }

    public abstract T resolve(M var1, ReusableBuffer var2) throws ReplicationClientAdapter.ErrorCodeException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerListener(ClientResponseAvailableListener<T> listener) {
        AtomicBoolean atomicBoolean = this.finished;
        synchronized (atomicBoolean) {
            if (this.finished.get()) {
                if (this.error == null) {
                    listener.responseAvailable(this.result);
                } else {
                    listener.requestFailed(this.error);
                }
            } else {
                this.listener = listener;
            }
        }
    }

    public static interface ClientResponseAvailableListener<U> {
        public void responseAvailable(U var1);

        public void requestFailed(Exception var1);
    }
}

