/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.logic;

import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.service.Pacemaker;
import org.xtreemfs.babudb.replication.service.ReplicationStage;
import org.xtreemfs.babudb.replication.service.SlaveView;
import org.xtreemfs.babudb.replication.service.StageRequest;
import org.xtreemfs.babudb.replication.service.logic.Logic;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.foundation.logging.Logging;

public class BasicLogic
extends Logic {
    private final Pacemaker pacemaker;

    public BasicLogic(BabuDBInterface babuDB, SlaveView slaveView, FileIOInterface fileIO, AtomicReference<LSN> lastOnView, Pacemaker pacemaker) {
        super(babuDB, slaveView, fileIO, lastOnView);
        this.pacemaker = pacemaker;
    }

    @Override
    public Logic.LogicID getId() {
        return Logic.LogicID.BASIC;
    }

    @Override
    public ReplicationStage.StageCondition run(final StageRequest rq) {
        final LSN lsn = rq.getLSN();
        Logging.logMessage((int)7, (Object)this, (String)"Replicate requested: %s", (Object[])new Object[]{lsn.toString()});
        LSN actual = this.getState();
        LSN expected = new LSN(actual.getViewId(), actual.getSequenceNo() + 1L);
        if (lsn.compareTo(actual) <= 0) {
            rq.free();
            Logging.logMessage((int)7, (Object)this, (String)"BASIC: Entry LSN(%s) dropped @LSN(%s).", (Object[])new Object[]{lsn.toString(), actual.toString()});
            return ReplicationStage.StageCondition.DEFAULT;
        }
        if (!lsn.equals((Object)expected)) {
            Logging.logMessage((int)7, (Object)this, (String)"BASIC: Entries until LSN(%s) missing @LSN(%s).", (Object[])new Object[]{lsn.toString(), actual.toString()});
            return new ReplicationStage.StageCondition(new LSN(lsn.getViewId(), lsn.getSequenceNo() - 1L));
        }
        try {
            this.babuDB.appendToLocalPersistenceManager(((LogEntry)rq.getArgs()[1]).clone(), new DatabaseRequestListener<Object>(){

                public void finished(Object result, Object context) {
                    BasicLogic.this.pacemaker.updateLSN(lsn);
                    BasicLogic.this.updateLastAcknowledgedEntry(lsn);
                    rq.free();
                }

                public void failed(BabuDBException error, Object context) {
                    Logging.logMessage((int)1, (Object)this, (String)"Log might be corrupted! A restart may be required!", (Object[])new Object[0]);
                    Logging.logError((int)3, (Object)this, (Throwable)error);
                    BasicLogic.this.updateLastAsyncInsertedEntry(null);
                    rq.free();
                }
            });
            this.updateLastAsyncInsertedEntry(lsn);
            Logging.logMessage((int)7, (Object)this, (String)"BASIC: Entry LSN(%s) replicated.", (Object[])new Object[]{lsn.toString()});
            return ReplicationStage.StageCondition.DEFAULT;
        }
        catch (BabuDBException e) {
            Logging.logMessage((int)7, (Object)this, (String)"BASIC: Entry LSN(%s) replication failed: LOAD required.", (Object[])new Object[]{lsn.toString()});
            return ReplicationStage.StageCondition.LOAD_LOOPHOLE;
        }
    }

    @Override
    public ReplicationStage.StageCondition run(ReplicationStage.StageCondition condition) {
        throw new UnsupportedOperationException();
    }
}

