/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.logic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.service.ReplicationStage;
import org.xtreemfs.babudb.replication.service.SlaveView;
import org.xtreemfs.babudb.replication.service.StageRequest;
import org.xtreemfs.babudb.replication.service.clients.ClientResponseFuture;
import org.xtreemfs.babudb.replication.service.clients.MasterClient;
import org.xtreemfs.babudb.replication.service.logic.Logic;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class LoadLogic
extends Logic {
    private final int maxChunkSize;

    public LoadLogic(BabuDBInterface babuDB, SlaveView slaveView, FileIOInterface fileIO, int maxChunkSize, AtomicReference<LSN> lastOnView) {
        super(babuDB, slaveView, fileIO, lastOnView);
        this.maxChunkSize = maxChunkSize;
    }

    @Override
    public Logic.LogicID getId() {
        return Logic.LogicID.LOAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationStage.StageCondition run(ReplicationStage.StageCondition condition) throws InterruptedException {
        assert (condition.logicID == Logic.LogicID.LOAD) : "PROGRAMATICAL ERROR!";
        LSN actual = this.getState();
        LSN until = condition.end == null ? new LSN(actual.getViewId() + 1, 0L) : condition.end;
        MasterClient master = this.slaveView.getSynchronizationPartner(until);
        Logging.logMessage((int)6, (Object)this, (String)"LOAD: Loading DB since %s from %s.", (Object[])new Object[]{actual.toString(), master.getDefaultServerAddress().toString()});
        DBFileMetaDataSet result = null;
        try {
            result = master.load(actual).get();
        }
        catch (Exception e) {
            Logging.logMessage((int)7, (Object)this, (String)"LOAD: metadata could not be retrieved from Master (%s).", (Object[])new Object[]{master.toString()});
            Logging.logError((int)7, (Object)this, (Throwable)e);
            return condition;
        }
        if (result.size() == 0) {
            try {
                LSN lov = this.babuDB.checkpoint();
                this.lastOnView.set(lov);
                Logging.logMessage((int)7, (Object)this, (String)"LOAD: Logfile switched at LSN %s.", (Object[])new Object[]{lov.toString()});
                return this.finish(until);
            }
            catch (BabuDBException e) {
                Logging.logMessage((int)4, (Object)this, (String)"LOAD: Taking a checkpoint failed.", (Object[])new Object[0]);
                Logging.logError((int)4, (Object)this, (Throwable)e);
                return condition;
            }
        }
        this.babuDB.stopBabuDB();
        try {
            this.fileIO.backupFiles();
        }
        catch (IOException e) {
            Logging.logMessage((int)4, (Object)this, (String)"LOAD: File-backup failed.", (Object[])new Object[0]);
            Logging.logError((int)4, (Object)this, (Throwable)e);
            if (Thread.interrupted()) {
                try {
                    this.babuDB.startBabuDB();
                }
                catch (BabuDBException e1) {
                    Logging.logError((int)3, (Object)this, (Throwable)e1);
                }
            }
            return condition;
        }
        final AtomicInteger openChunks = new AtomicInteger(result.size());
        LSN lsn = null;
        for (LSMDatabase.DBFileMetaData fileData : result) {
            long fileSize;
            final String fileName = fileData.file;
            String parentName = new File(fileName).getParentFile().getName();
            if (LSMDatabase.isSnapshotFilename((String)parentName)) {
                if (lsn == null) {
                    lsn = LSMDatabase.getSnapshotLSNbyFilename((String)parentName);
                } else if (!lsn.equals((Object)LSMDatabase.getSnapshotLSNbyFilename((String)parentName))) {
                    Logging.logMessage((int)7, (Object)this, (String)"LOAD: Indexfiles had ambiguous LSNs: %s", (Object[])new Object[]{"LOAD will be retried."});
                    return condition;
                }
            }
            if ((fileSize = fileData.size) <= 0L) {
                Logging.logMessage((int)7, (Object)this, (String)"LOAD: Empty file received -> retry.", (Object[])new Object[0]);
                return condition;
            }
            assert ((long)this.maxChunkSize > 0L) : "Empty chunks are not allowed: " + fileName;
            AtomicInteger atomicInteger = openChunks;
            synchronized (atomicInteger) {
                if (openChunks.get() != -1) {
                    openChunks.addAndGet((int)(fileSize / (long)this.maxChunkSize));
                }
            }
            long begin = 0L;
            for (long end = (long)this.maxChunkSize; end < fileSize + (long)this.maxChunkSize; end += (long)this.maxChunkSize) {
                final long pos1 = begin;
                final long size = end > fileSize ? fileSize : end;
                begin = end;
                master.chunk(fileName, pos1, size).registerListener(new ClientResponseFuture.ClientResponseAvailableListener<ReusableBuffer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void responseAvailable(ReusableBuffer buffer) {
                        AtomicInteger atomicInteger = openChunks;
                        synchronized (atomicInteger) {
                            AbstractInterruptibleChannel fChannel = null;
                            try {
                                if (openChunks.get() < 0) {
                                    throw new IOException();
                                }
                                if (buffer.remaining() == 0) {
                                    Logging.logMessage((int)4, (Object)this, (String)"LOAD: CHUNK ERROR: Empty buffer received!", (Object[])new Object[0]);
                                    throw new IOException("CHUNK ERROR: Empty buffer received!");
                                }
                                File f = LoadLogic.this.fileIO.getFile(fileName);
                                Logging.logMessage((int)7, (Object)this, (String)"LOAD: SAVING %s to %s.", (Object[])new Object[]{fileName, f.getPath()});
                                assert (f.exists()) : "File '" + fileName + "' was not created properly.";
                                fChannel = new FileOutputStream(f).getChannel();
                                ((FileChannel)fChannel).write(buffer.getBuffer(), pos1);
                            }
                            catch (IOException e) {
                                Logging.logMessage((int)4, (Object)this, (String)"LOAD: Chunk request (%s,%d,%d) failed: %s", (Object[])new Object[]{fileName, pos1, size, e.getMessage()});
                                openChunks.set(-1);
                                openChunks.notify();
                                return;
                            }
                            finally {
                                if (fChannel != null) {
                                    try {
                                        fChannel.close();
                                    }
                                    catch (IOException e) {
                                        Logging.logError((int)3, (Object)this, (Throwable)e);
                                    }
                                }
                                if (buffer != null) {
                                    BufferPool.free((ReusableBuffer)buffer);
                                }
                            }
                            if (openChunks.get() != -1 && openChunks.decrementAndGet() == 0) {
                                openChunks.notify();
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void requestFailed(Exception e) {
                        if (e instanceof ReplicationClientAdapter.ErrorCodeException) {
                            ReplicationClientAdapter.ErrorCodeException err = (ReplicationClientAdapter.ErrorCodeException)e;
                            Logging.logMessage((int)4, (Object)this, (String)"LOAD: Chunk request (%s,%d,%d) failed: (%d) %s", (Object[])new Object[]{fileName, pos1, size, err.getCode()});
                        } else {
                            Logging.logMessage((int)4, (Object)this, (String)"LOAD: Chunk request (%s,%d,%d) failed: %s", (Object[])new Object[]{fileName, pos1, size, e.getMessage()});
                        }
                        AtomicInteger atomicInteger = openChunks;
                        synchronized (atomicInteger) {
                            openChunks.set(-1);
                            openChunks.notify();
                        }
                    }
                });
            }
        }
        AtomicInteger i$ = openChunks;
        synchronized (i$) {
            if (openChunks.get() > 0) {
                openChunks.wait();
            }
        }
        if (openChunks.get() == -1) {
            Logging.logMessage((int)7, (Object)this, (String)"LOAD: At least one chunk could not have been inserted.", (Object[])new Object[0]);
            return condition;
        }
        try {
            this.babuDB.startBabuDB();
            this.fileIO.removeBackupFiles();
            assert (!actual.equals((Object)this.babuDB.getState())) : "Loading the database had no effect!";
            return this.finish(until);
        }
        catch (BabuDBException e) {
            Logging.logMessage((int)4, (Object)this, (String)"LOAD: Loading failed, because the reloading the DBS failed due: %s", (Object[])new Object[]{e.getMessage()});
            return condition;
        }
    }

    @Override
    public ReplicationStage.StageCondition run(StageRequest rq) {
        throw new UnsupportedOperationException("PROGRAMATICAL ERROR!");
    }

    public static final class DBFileMetaDataSet
    extends ArrayList<LSMDatabase.DBFileMetaData> {
        private static final long serialVersionUID = -6430317150111369328L;
        final int chunkSize;

        public DBFileMetaDataSet(int chunkSize, Collection<LSMDatabase.DBFileMetaData> c) {
            super(c);
            this.chunkSize = chunkSize;
        }
    }
}

