/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.logic;

import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.service.ReplicationStage;
import org.xtreemfs.babudb.replication.service.SlaveView;
import org.xtreemfs.babudb.replication.service.StageRequest;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.foundation.logging.Logging;

public abstract class Logic {
    protected final BabuDBInterface babuDB;
    protected final FileIOInterface fileIO;
    protected final SlaveView slaveView;
    protected final AtomicReference<LSN> lastOnView;
    private final AtomicReference<LSN> lastAsyncInserted = new AtomicReference<LSN>(new LSN(0, 0L));
    private LSN acknowledged = new LSN(0, 0L);

    Logic(BabuDBInterface babuDB, SlaveView slaveView, FileIOInterface fileIO, AtomicReference<LSN> lastOnView) {
        this.slaveView = slaveView;
        this.fileIO = fileIO;
        this.babuDB = babuDB;
        this.lastOnView = lastOnView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastAsyncInsertedEntry(LSN lsn) {
        AtomicReference<LSN> atomicReference = this.lastAsyncInserted;
        synchronized (atomicReference) {
            if (this.lastAsyncInserted.get() != null) {
                this.lastAsyncInserted.set(lsn);
                if (lsn == null) {
                    this.lastAsyncInserted.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastAcknowledgedEntry(LSN lsn) {
        AtomicReference<LSN> atomicReference = this.lastAsyncInserted;
        synchronized (atomicReference) {
            if (this.acknowledged.compareTo(lsn) < 0) {
                this.acknowledged = lsn;
                this.lastAsyncInserted.notify();
            }
        }
    }

    public LSN getState() {
        LSN written = this.babuDB.getState();
        LSN async = this.lastAsyncInserted.get();
        return async == null || async.compareTo(written) <= 0 ? written : async;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSteadyState() throws InterruptedException {
        AtomicReference<LSN> atomicReference = this.lastAsyncInserted;
        synchronized (atomicReference) {
            LSN async = this.lastAsyncInserted.get();
            while (async != null && async.compareTo(this.acknowledged) > 0) {
                this.lastAsyncInserted.wait();
                async = this.lastAsyncInserted.get();
            }
        }
    }

    public abstract LogicID getId();

    public abstract ReplicationStage.StageCondition run(StageRequest var1);

    public abstract ReplicationStage.StageCondition run(ReplicationStage.StageCondition var1) throws InterruptedException;

    protected ReplicationStage.StageCondition finish(LSN end) {
        return this.finish(end, false);
    }

    protected ReplicationStage.StageCondition finish(LSN end, boolean load) {
        LSN actual = this.getState();
        if (end != null && actual.compareTo(end) < 0) {
            if (load) {
                Logging.logMessage((int)7, (Object)this, (String)"LOAD to LSN(%s) @ LSN(%s).", (Object[])new Object[]{end.toString(), actual.toString()});
                return new ReplicationStage.StageCondition(LogicID.LOAD, end);
            }
            Logging.logMessage((int)7, (Object)this, (String)"REQUEST to LSN(%s) @ LSN(%s).", (Object[])new Object[]{end.toString(), actual.toString()});
            return new ReplicationStage.StageCondition(end);
        }
        Logging.logMessage((int)7, (Object)this, (String)"Back to basic @ LSN(%s).", (Object[])new Object[]{actual.toString()});
        this.lastAsyncInserted.set(new LSN(0, 0L));
        return ReplicationStage.StageCondition.DEFAULT;
    }

    public static enum LogicID {
        BASIC,
        REQUEST,
        LOAD;

    }
}

