/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.logic;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.xtreemfs.babudb.api.database.DatabaseRequestListener;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.log.LogEntryException;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.replication.BabuDBInterface;
import org.xtreemfs.babudb.replication.service.ReplicationStage;
import org.xtreemfs.babudb.replication.service.SlaveView;
import org.xtreemfs.babudb.replication.service.StageRequest;
import org.xtreemfs.babudb.replication.service.clients.MasterClient;
import org.xtreemfs.babudb.replication.service.logic.Logic;
import org.xtreemfs.babudb.replication.transmission.FileIOInterface;
import org.xtreemfs.babudb.replication.transmission.client.ReplicationClientAdapter;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class RequestLogic
extends Logic {
    private final Checksum checksum = new CRC32();

    public RequestLogic(BabuDBInterface babuDB, SlaveView slaveView, FileIOInterface fileIO, AtomicReference<LSN> lastOnView) {
        super(babuDB, slaveView, fileIO, lastOnView);
    }

    @Override
    public Logic.LogicID getId() {
        return Logic.LogicID.REQUEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationStage.StageCondition run(ReplicationStage.StageCondition condition) throws InterruptedException {
        assert (condition.logicID == Logic.LogicID.REQUEST) : "PROGRAMATICAL ERROR!";
        LSN from = this.getState();
        LSN until = condition.end;
        Logging.logMessage((int)6, (Object)this, (String)"REQUEST: Replica-range is missing: from %s to %s", (Object[])new Object[]{from.toString(), until.toString()});
        ReusableBuffer[] logEntries = null;
        MasterClient master = this.slaveView.getSynchronizationPartner(until);
        Logging.logMessage((int)6, (Object)this, (String)"REQUEST: Replica-Range will be retrieved from %s.", (Object[])new Object[]{master.getDefaultServerAddress()});
        try {
            logEntries = master.replica(from, until).get();
            if (logEntries.length == 0) {
                LSN lov = this.babuDB.checkpoint();
                this.lastOnView.set(lov);
                Logging.logMessage((int)7, (Object)this, (String)"REQUEST: Recognized master failover @ LSN(%s).", (Object[])new Object[]{lov.toString()});
                ReplicationStage.StageCondition stageCondition = this.finish(until);
                return stageCondition;
            }
            final AtomicInteger count = new AtomicInteger(logEntries.length);
            LSN check = null;
            for (ReusableBuffer le : logEntries) {
                try {
                    LogEntry logentry = LogEntry.deserialize((ReusableBuffer)le, (Checksum)this.checksum);
                    LSN lsn = logentry.getLSN();
                    assert (check == null || check.getViewId() == lsn.getViewId() && check.getSequenceNo() + 1L == lsn.getSequenceNo() || check.getViewId() + 1 == lsn.getViewId() && lsn.getSequenceNo() == 1L) : "ERROR: last LSN (" + check.toString() + ") received LSN (" + lsn.toString() + ")!";
                    check = lsn;
                    if (lsn.getSequenceNo() == 1L && this.babuDB.getState().getViewId() < lsn.getViewId()) {
                        this.lastOnView.set(this.babuDB.checkpoint());
                    }
                    this.babuDB.appendToLocalPersistenceManager(logentry, new DatabaseRequestListener<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void finished(Object result, Object context) {
                            AtomicInteger atomicInteger = count;
                            synchronized (atomicInteger) {
                                if (count.decrementAndGet() == 0) {
                                    count.notify();
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void failed(BabuDBException error, Object context) {
                            Logging.logError((int)3, (Object)this, (Throwable)error);
                            AtomicInteger atomicInteger = count;
                            synchronized (atomicInteger) {
                                count.set(-1);
                                count.notify();
                            }
                        }
                    });
                }
                finally {
                    this.checksum.reset();
                }
            }
            AtomicInteger atomicInteger = count;
            synchronized (atomicInteger) {
                while (count.get() > 0) {
                    count.wait();
                }
            }
            if (count.get() == -1) {
                throw new LogEntryException("At least one insert could not be proceeded.");
            }
            Logging.logMessage((int)7, (Object)this, (String)"REQUEST: Inserted %d logEntries.", (Object[])new Object[]{logEntries.length});
            ReplicationStage.StageCondition stageCondition = this.finish(until);
            return stageCondition;
        }
        catch (ReplicationClientAdapter.ErrorCodeException ece) {
            if (ece.getCode() == 4) {
                Logging.logMessage((int)7, (Object)this, (String)"REQUEST: LogFile unavailable @Master(%s).", (Object[])new Object[]{master.toString()});
                ReplicationStage.StageCondition stageCondition = this.finish(until, true);
                return stageCondition;
            }
            Logging.logMessage((int)7, (Object)this, (String)"REQUEST: Transmission to Master (%s) failed.", (Object[])new Object[]{master.toString()});
            ReplicationStage.StageCondition stageCondition = condition;
            return stageCondition;
        }
        catch (BabuDBException be) {
            Logging.logMessage((int)4, (Object)this, (String)"REQUEST: Insert did not succeed, because %s.", (Object[])new Object[]{be.getMessage()});
            Logging.logError((int)4, (Object)this, (Throwable)be);
            ReplicationStage.StageCondition stageCondition = this.finish(until, true);
            return stageCondition;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            Logging.logMessage((int)4, (Object)this, (String)"REQUEST: Retry because of unexpected exception: %s.", (Object[])new Object[]{e.getMessage()});
            Logging.logError((int)4, (Object)this, (Throwable)e);
            ReplicationStage.StageCondition stageCondition = condition;
            return stageCondition;
        }
        finally {
            if (logEntries != null) {
                for (ReusableBuffer buf : logEntries) {
                    if (buf == null) continue;
                    BufferPool.free((ReusableBuffer)buf);
                }
            }
        }
    }

    @Override
    public ReplicationStage.StageCondition run(StageRequest rq) {
        throw new UnsupportedOperationException("PROGRAMATICAL ERROR!");
    }
}

