/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.replication.service.operations;

import com.google.protobuf.Message;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xtreemfs.babudb.pbrpc.GlobalTypes;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Operation;
import org.xtreemfs.babudb.replication.transmission.dispatcher.Request;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class ChunkOperation
extends Operation {
    @Override
    public int getProcedureId() {
        return 3;
    }

    @Override
    public Message getDefaultRequest() {
        return GlobalTypes.Chunk.getDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(Request rq) {
        GlobalTypes.Chunk chunk = (GlobalTypes.Chunk)rq.getRequestMessage();
        int length = (int)(chunk.getEnd() - chunk.getStart());
        Logging.logMessage((int)6, (Object)this, (String)"%s request received from %s", (Object[])new Object[]{chunk.toString(), rq.getSenderAddress().toString()});
        FileChannel channel = null;
        ReusableBuffer payload = null;
        try {
            channel = new FileInputStream(chunk.getFileName()).getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(length);
            if (channel.read(buffer, chunk.getStart()) != length) {
                throw new Exception();
            }
            buffer.flip();
            payload = new ReusableBuffer(buffer);
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.getDefaultInstance(), payload);
        }
        catch (Exception e) {
            if (payload != null) {
                BufferPool.free(payload);
            }
            if (e.getMessage() == null) {
                Logging.logError((int)4, (Object)this, (Throwable)e);
            } else {
                Logging.logMessage((int)6, (Object)this, (String)"The requested chunk (%s) is not available anymore, because: %s", (Object[])new Object[]{chunk.toString(), e.getMessage()});
            }
            rq.sendSuccess((Message)GlobalTypes.ErrorCodeResponse.newBuilder().setErrorCode(3).build());
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

